import os,glob,sys
from netCDF4 import Dataset # http://code.google.com/p/netcdf4-python/
#-----------------------------------------------------------------------
def expand_ncfiles(ncfiles,proc):
#
# Expand list of ncfiles provided on the command line.
# 
#
# Mixed quoted and unquoted list comes in as a single string,
# so split them by commas:
#
  if len(ncfiles)==1:
    file = ncfiles[0]
    if not os.path.isfile(file):
      flist = file.split(',')
      ncfiles.pop()
      for ffile in flist: ncfiles.append(ffile)
# print 'ncfiles after len(ncfiles)==1: ncfiles=',ncfiles
#
# If a member of the list has a wildcard, expand it via glob, 
#   and append each to ncfiles:
#
  i = 0
  for file in ncfiles:
    if '*' in file:             # assume this is a wildcard in file spec
      flist = glob.glob(file)
      if flist:
        for ffile in flist:
          ncfiles.append(ffile)
      continue
    i = i+1
# print 'ncfiles after expand wildcard spec: ncfiles=',ncfiles
#
# Remove any remaining file specs:
#
  remove_list = []
  for file in ncfiles:
    if '*' in file:
      remove_list.append(file)
  ncfiles = list(set(ncfiles) - set(remove_list))
  if len(ncfiles)==0:
    print '>>> Could find no input history files to process.'
    sys.exit()
# print 'ncfiles after remove file wildcard spec: ncfiles=',ncfiles
#
# Remove any non-existant files:
#
  remove_list = []
  for file in ncfiles:
    if not os.path.isfile(file):
      print '>>> Could not find file ',file
      remove_list.append(file)
  ncfiles = list(set(ncfiles) - set(remove_list))
# print 'ncfiles after remove non-existant: ncfiles=',ncfiles
#
# Remove any files that do not open as netcdf files:
#
  remove_list = []
  for file in ncfiles:
    try:
      nc_fid = Dataset(file,'r')
    except:
      print '>>> File ',file,' does not open as netcdf file.'
      remove_list.append(file)
      continue
    nc_fid.close()
  ncfiles = list(set(ncfiles) - set(remove_list))
# print 'ncfiles after check open: ncfiles=',ncfiles
#
# Remove duplicate file names, and sort (so they can be read as a series):
#
  ncfiles = list(set(ncfiles)) # remove duplicate file names
  ncfiles = sorted(ncfiles)    # sort alpha-numerically
#
  return ncfiles

