import os,sys,re
from netCDF4 import Dataset # http://code.google.com/p/netcdf4-python/
#
# Processor Class definition:
#
class Processor:
#-----------------------------------------------------------------------
  def make_namelist_singleut(self):
    self.list = [
      ['&proc_input'  , ''],
      ['histvols'     , self.ncfiles_str],
      ['mtimes'       , self.mtimes],
      ['cfields'      , self.cfields],
      ['modelhts'     , '1'],
      ['icolor'       , '1'],
      ['outplt'       , "'ps'"],
      ['flnm_ps'      , "'"+self.flnm_ps+"'"],
      ['ipltmaps'     , self.pltmaps],
      ['map_global'   , '1'],
      ['map_polar'    , '0'],
      ['fmap_polar_perimlat' , '-40.,40.'],
      ['fmap_zpht'    , self.fmap_zpht],
      ['ipltlon'      , self.pltlon],
      ['flons'        , "'"+self.flons+"'"],
      ['fslts'        , self.fslts],
      ['flon_zprange' , '-99.,99.'],
      ['ipltlat'      , self.pltlat],
      ['flats'        , self.flats],
      ['flat_zprange' , '-99.,99.'],
      ['ipltxyloc'    , self.pltxyloc],
      ['xylocs'       , self.xylocs],
      ['xyloc_zprange', self.xyloc_zprange]
      ]
    
    f = open(self.nlfile,'w')
    groupname = re.compile('^&\w+')
    for pair in self.list:
      if groupname.match(pair[0]):
        f.write(pair[0]+'\n')
        comment = ( \
        "!\n",
        "! Namelist input file for tgcmproc (single-ut run)\n",
        "!\n")
        for line in comment: f.write(line)
      else:
#
# Keyword value pair[1] must be a string:
        value = pair[1]
#       print 'key=',pair[0],' value=',pair[1]
        line = pair[0] + ' = ' + pair[1]
        f.write(line+'\n')

    f.write('/\n')
    f.close()
#   print 'Wrote namelist file ',self.nlfile

#-----------------------------------------------------------------------
  def make_namelist_multiut(self):
    self.list = [
      ['&proc_input'   , ''],
      ['histvols'      , self.ncfiles_str],
      ['mtimes'        , self.mtimes],
      ['cfields'       , self.cfields],
      ['modelhts'      , '1'],
      ['icolor'        , '1'],
      ['outplt'        , "'ps'"],
      ['flnm_ps'       , "'"+self.flnm_ps+"'"],
      ['ipltutvert'    , self.pltutvert],
      ['utvert_locs'   , self.utvert_locs],
      ['utvert_zprange', self.utvert_zprange],
      ['ipltutlat'     , self.pltutlat],
      ['utlat_zphtlon' , self.utlat_zphtlon]
      ]
    
    f = open(self.nlfile,'w')
    groupname = re.compile('^&\w+')
    for pair in self.list:
      if groupname.match(pair[0]):
        f.write(pair[0]+'\n')
        comment = ( \
        "!\n",
        "! Namelist input file for tgcmproc (multi-ut run)\n",
        "!\n")
        for line in comment: f.write(line)
      else:
#
# Keyword value pair[1] must be a string:
        value = pair[1]
#       print 'make_namelist_multiut: pair[0]=',pair[0],' pair[1]=',pair[1]
        line = pair[0] + ' = ' + pair[1]
        f.write(line+'\n')

    f.write('/\n')
    f.close()
#   print 'Wrote namelist file ',self.nlfile
#-----------------------------------------------------------------------
  def find_mtime(self,mtime_find):
#
# Search files for mtime_find:
#   If mtime_find[0] >= 999, then user wants the last mtime in file series
#   If mtime_find[0] < 0, then user wants the first mtime in file series
# If mtime_find is found, return the file it was found in, and the mtime
# If mtime_find is not found, return an empty string, and mtime_find 
#
    found = 0
    nfiles = len(self.ncfiles)
    ifile = 0
    for file in self.ncfiles: 
      ncid = Dataset(file,'r')
      mtimes = ncid.variables['mtime']
      time = ncid.variables['time'] ; ntime = len(time)

      if mtime_find[0] < 0:      # user wants first mtime in the file series
        return file,mtimes[0][:]
      elif mtime_find[0] >= 999: # user wants last mtime in the file series
        if ifile == nfiles-1: 
          return file,mtimes[ntime-1][:]
        else: 
          ifile = ifile+1
          continue
      for i in xrange(ntime):
        mtime = mtimes[i][:]
        if mtime[0]==mtime_find[0] and mtime[1]==mtime_find[1] and mtime[2]==mtime_find[2]:
          found = 1
          break
      if not found: 
        continue
      else:
        return file,mtime
    if not found:
      print '>>> find_mtime: Could not find mtime ',mtime_find
      print '    The following files were searched:'
      for file in self.ncfiles:
        print '  ',file
      return '',mtime_find
#-----------------------------------------------------------------------
  def find_dhist(self):
    file = self.ncfiles[0]
    ncid = Dataset(file,'r')
#   print 'Global attributes in file ',file
    for name in ncid.ncattrs():
      value = getattr(ncid,name)
#     print 'Global attr ',name,' = ',value
      if name=='delhist_mins': return value
    return ''
#-----------------------------------------------------------------------
  def getres(self,ncfiles):
#
# Get resolution from nlat on history files, and make sure 
# all files are at same resolution.
#
    prevres = '0'
    for file in ncfiles:
      ncid = Dataset(file,'r')
      lats = ncid.variables['lat'][:] ; nlat = len(lats)
      res = '5.0'
      if nlat == 72: res = '2.5'
      if prevres != '0' and prevres != res:
        print '>>> History file ',file,' has different model resolution (',res,')\nthan previous file in the list.'
        sys.exit()
      ncid.close()
      prevres = res
    return res
