PRO getDatMinMax,info,line,field,file,imtime_min,nframes,func
;
;  Get state info
;
    data = *field.data
;
; Set min,max for constant scale:
; Save current:
;
    savefmin  = line.fmin  & savefmax = line.fmax & saveslat = line.slat & saveimtime = line.imtime
    fminmax,*line.data,fMinDataIn,fMaxDataIn,line.missing_value
;
; Calculate min,max for entire animation if not already fixed:
;
    IF func EQ 'time_fixlon' THEN line.slat = line.latmin
    IF savefmin GT fMinDataIn-0.001 AND savefmin LT fMinDataIn+0.001 AND $
       savefmax GT fMaxDataIn-0.001 AND savefmax LT fMaxDataIn+0.001 THEN BEGIN
    
      line.fmin =  1.e36 & line.fmax = -1.e36
      for i=0,nframes-1 do begin
        IF func EQ 'time_fixlon' OR func EQ 'time_fixslt' THEN line.imtime = i+imtime_min
;
; For fixed local solar time need to get the longitude index for each imtime independently
;        
        IF func EQ 'time_fixslt' THEN BEGIN
      
          line.mtime = file.mtimes[*,line.imtime]
          line.ut = line.mtime[1]+line.mtime[2]/60.
          line.slon = fslt(line.sslt,line.ut,line.slon,"getlon",mag=mag)
;
; Is this necessary?
          if field.grid_type eq 'geographic' then begin ; add periodic point
            nlons = n_elements(*field.lons)
            lons = fltarr(nlons+1)
            lons[0:nlons-1] = *field.lons
            lons[nlons] = abs(lons[0]) ; +180
          endif else lons = *field.lons

          dlon = lons[1]-lons[0]
          if ixfind(lons,line.slon,0.) lt 0 then begin
            ilon = ixfind(lons,line.slon,dlon)
            line.slon = lons[ilon]
          endif
	  	  
	ENDIF
	
        IF func EQ 'time_fixlon' THEN line.slat = saveslat
        IF func EQ 'lon_fixut' THEN line.slon = (*field.lons)[i]
        IF func EQ 'lat_fixut' THEN line.slat = (*field.lats)[i]
        IF func EQ 'lon_fixut' THEN line.sslt = fslt(line.sslt,line.ut,line.slon,"getlt",mag=mag)
        IF func EQ 'lat_fixut' THEN line.sslt = fslt(line.sslt,line.ut,line.slon,"getlt",mag=mag)
        if line.plotz ge 1 and info.ftype eq 'WACCM' and line.plottype EQ 'profile' then *line.levs = *field.levs
        if line.plotz gt 0 and line.plottype ne 'profile' then getaltzdata,info,line,data ;Need to get vertical data if plotting on altitude        
        deflinedata,line,data
        data1 = *line.data
        fminmax,*line.data,fmin,fmax,file.missing_value
        if fmin lt line.fmin then line.fmin = fmin
        if fmax gt line.fmax then line.fmax = fmax
	
      endfor

    ENDIF ELSE BEGIN  
    
      line.fmin = savefmin
      line.fmax = savefmax      

    ENDELSE
    
    line.slat = saveslat

    
 END
      
;-----------------------------------------------------------------------
pro animate_lines,info,func
;
; Animate line plots in one of three ways, according to input func:
;   In time (at fixed longitude)    func = 'time_fixlon'
;   In time (at fixed local time)   func = 'time_fixslt'
;   In longitude (at fixed ut)      func = 'lon_fixut'
;
; Get state info:
;
line = *info.pline
fields = *info.fields
field = fields[line.ifield]
data = *field.data
file = *info.pfile
wanim_xsize=490 & wanim_ysize=490
mag = 0 & if field.grid_type eq 'magnetic' then mag = 1
;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; Animate in time (fixed longitude):
;
widget_control,/hourglass
case func of
  "time_fixlon": begin

    savelon = line.slon & saveslt = line.sslt
    savefmin = line.fmin & savefmax = line.fmax
    savedata = *line.data

    animbase = widget_base(title=$
      'Animate line plots in time (fixed longitude)')
    newtimes=intarr(3,3)
    utmin=intarr(3,1)
    utmax=intarr(3,1)
    utmin[0]=file.mtimes[0,0] & utmin[1]=file.mtimes[1,0] & $
      utmin[2]=file.mtimes[2,0]
    utmax[0]=file.mtimes[0,file.ntimes-1] & utmax[1]=file.mtimes[1,file.ntimes-1] & $
      utmax[2]=file.mtimes[2,file.ntimes-1]
    interval=1  
    newtimes=setaxis_ut(info,info.pline,utmin,utmax,interval)
    utmin[0]=newtimes[0,0] & utmin[1]=newtimes[1,0] & $
      utmin[2]=newtimes[2,0]
    utmax[0]=newtimes[0,1] & utmax[1]=newtimes[1,1] & $
      utmax[2]=newtimes[2,1]
    interval=newtimes[0,2]
    if (interval eq -1) then begin
      print,'Cancelling line slice animation..'
      return
    endif
    type_hist=newtimes[1,2]
    imtime_min = -1
    imtime_max = -1
    for i=0,file.ntimes-1 do begin
      if file.mtimes[0,i] eq utmin[0] and file.mtimes[1,i] eq utmin[1] and $
        file.mtimes[2,i] eq utmin[2] then begin
        imtime_min=i
      endif
      if file.mtimes[0,i] eq utmax[0] and file.mtimes[1,i] eq utmax[1] and $
        file.mtimes[2,i] eq utmax[2] then begin
        imtime_max=i
      endif
    endfor
    if imtime_min gt imtime_max then $
      imtime_max=file.ntimes-1 & $  
      print,'max time is less than min time resetting max time:',imtime_max
    nframes=imtime_max-imtime_min+1
;
; Save some state parameters of fixed window:
;
    savefmin = line.fmin & savefmax = line.fmax
    savemtime = line.mtime   & saveimtime = line.imtime
    saveut = line.ut         & savelon = line.slon
    savedata = *line.data
;
; Set min,max for constant scale from manual setting or data range:
;
    getDatMinMax,info,line,field,file,imtime_min,nframes,func
;
; Load frames and run cw_animate:
;
    numberframes=0 
    for i=0,nframes-1 do begin
      line.imtime = i+imtime_min
      if file.mtimes[type_hist,line.imtime] mod interval eq 0 then begin
        numberframes=numberframes+1
      endif
    endfor
    animate = cw_animate(animbase,wanim_xsize,wanim_ysize,numberframes )
    add_animid,info,animate

    widget_control,animbase,/realize 
    framenum=0
    for i=0,nframes-1 do begin
      line.imtime = i+imtime_min
      if file.mtimes[type_hist,line.imtime] mod interval eq 0 then begin
        line.mtime = file.mtimes[*,line.imtime]
        line.ut = line.mtime[1]+line.mtime[2]/60.
        line.sslt = fslt(line.sslt,line.ut,line.slon,"getlt",mag=mag)
        if line.plotz ge 1 and info.ftype eq 'WACCM' and line.plottype EQ 'profile' then *line.levs = *field.levs
        if line.plotz gt 0 and line.plottype ne 'profile' then getaltzdata,info,line,data ;Need to get vertical data if plotting on altitude        
        deflinedata,line,data
        IF line.plotz GE 1 and line.plottype eq 'profile' THEN getzprof,info,line,'profile',fields,zalt
        *info.pline = line
        window,xsize=wanim_xsize,ysize=wanim_ysize,/pixmap
        windo = !d.window
        wset,windo
        pltline,info,/animate
        cw_animate_load,animate,frame=framenum,window=windo,/track
        framenum=framenum+1
      endif
    endfor
;
    line.mtime = savemtime & line.imtime = saveimtime
    line.fmin  = savefmin  & line.fmax = savefmax
    line.ut    = saveut    & line.sslt = saveslt
    line.data = PTR_NEW(savedata)
    *info.pline = line
    cw_animate_run,animate,nframes=numberframes
  end ; animate in time (fixed longitude)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; Animate in time (fixed local time):
; Longitude and ut will vary, and current local time line.sslt remains constant.
;
  "time_fixslt": begin
    animbase = widget_base(title=$
      'Animate line plots in time (fixed local time)')
    newtimes=intarr(3,3)
    utmin=intarr(3,1)
    utmax=intarr(3,1)
    utmin[0]=file.mtimes[0,0] & utmin[1]=file.mtimes[1,0] & $
      utmin[2]=file.mtimes[2,0]
    utmax[0]=file.mtimes[0,file.ntimes-1] & utmax[1]=file.mtimes[1,file.ntimes-1] & $
      utmax[2]=file.mtimes[2,file.ntimes-1]
    interval=1  
    newtimes=setaxis_ut(info,info.pline,utmin,utmax,interval)
    utmin[0]=newtimes[0,0] & utmin[1]=newtimes[1,0] & $
      utmin[2]=newtimes[2,0]
    utmax[0]=newtimes[0,1] & utmax[1]=newtimes[1,1] & $
      utmax[2]=newtimes[2,1]
    interval=newtimes[0,2]
    if (interval eq -1) then begin
      print,'Cancelling line slice animation..'
      return
    endif
    type_hist=newtimes[1,2]
    imtime_min = -1
    imtime_max = -1
    for i=0,file.ntimes-1 do begin
      if file.mtimes[0,i] eq utmin[0] and file.mtimes[1,i] eq utmin[1] and $
        file.mtimes[2,i] eq utmin[2] then begin
        imtime_min=i
      endif
      if file.mtimes[0,i] eq utmax[0] and file.mtimes[1,i] eq utmax[1] and $
        file.mtimes[2,i] eq utmax[2] then begin
        imtime_max=i
      endif
    endfor
    if imtime_min gt imtime_max then $
      imtime_max=file.ntimes-1 & $  
      print,'max time is less than min time resetting max time:',imtime_max
    nframes=imtime_max-imtime_min+1
;
; Save some state parameters of fixed window:
;
    savefmin = line.fmin & savefmax = line.fmax
    savemtime = line.mtime   & saveimtime = line.imtime
    saveut = line.ut         & savelon = line.slon
    savedata = *line.data
;
; Set min,max for constant scale from manual setting or data range:
;
    getDatMinMax,info,line,field,file,imtime_min,nframes,func
;
; Load frames and run cw_animate:
;
    numberframes=0 
    for i=0,nframes-1 do begin
      line.imtime = i+imtime_min
      if file.mtimes[type_hist,line.imtime] mod interval eq 0 then begin
        numberframes=numberframes+1
      endif
    endfor
    animate = cw_animate(animbase,wanim_xsize,wanim_ysize,numberframes )
    add_animid,info,animate

    widget_control,animbase,/realize 
    framenum=0
    for i=0,nframes-1 do begin
      line.imtime = i+imtime_min
      if file.mtimes[type_hist,line.imtime] mod interval eq 0 then begin

        line.mtime = file.mtimes[*,line.imtime]
        line.ut = line.mtime[1]+line.mtime[2]/60.
        line.slon = fslt(line.sslt,line.ut,line.slon,"getlon",mag=mag)
;
; Is this necessary?
        if field.grid_type eq 'geographic' then begin ; add periodic point
          nlons = n_elements(*field.lons)
          lons = fltarr(nlons+1)
          lons[0:nlons-1] = *field.lons
          lons[nlons] = abs(lons[0]) ; +180
        endif else lons = *field.lons

        dlon = lons[1]-lons[0]
        if ixfind(lons,line.slon,0.) lt 0 then begin
          ilon = ixfind(lons,line.slon,dlon)
          line.slon = lons[ilon]
        endif
;
        if line.plotz ge 1 and info.ftype eq 'WACCM' and line.plottype EQ 'profile' then *line.levs = *field.levs
        if line.plotz gt 0 and line.plottype ne 'profile' then getaltzdata,info,line,data ;Need to get vertical data if plotting on altitude        
        deflinedata,line,data
        IF line.plotz GE 1 and line.plottype eq 'profile' THEN getzprof,info,line,'profile',fields,zalt
        *info.pline = line
        window,xsize=wanim_xsize,ysize=wanim_ysize,/pixmap
        windo = !d.window
        wset,windo
        pltline,info,/animate
        cw_animate_load,animate,frame=framenum,window=windo,/track
        framenum=framenum+1
      endif
    endfor
;
; Restore state to fixed window:
;
    line.fmin = savefmin & line.fmax = savefmax
    line.mtime = savemtime & line.imtime = saveimtime
    line.ut = saveut & line.slon = savelon
    line.data = PTR_NEW(savedata)
    *info.pline = line
;
; Run the animation
;
    cw_animate_run,animate,nframes=numberframes 
  end
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; Animate in longitude (fixed ut):
;
  "lon_fixut": begin
    animbase = widget_base(title='Animate in longitude (fixed ut)')
    nframes = field.nlon
;
; Save some state parameters of fixed window:
;
    savefmin = line.fmin & savefmax = line.fmax
    savemtime = line.mtime   & saveimtime = line.imtime
    saveut = line.ut         & savelon = line.slon
    saveslt = line.sslt
    savedata = *line.data
;
; Set min,max for constant scale from manual setting of data range:
;
    getDatMinMax,info,line,field,file,0,nframes,func
;
; Load frames and run cw_animate:
;
    animate = cw_animate(animbase,wanim_xsize,wanim_ysize,nframes)
    add_animid,info,animate

    widget_control,animbase,/realize 
    for i=0,nframes-1 do begin
      line.slon = (*field.lons)[i]
;     line.sslt = fslt(0.,line.ut,line.slon,1)
      line.sslt = fslt(line.sslt,line.ut,line.slon,"getlt",mag=mag)
      if line.plotz ge 1 and info.ftype eq 'WACCM' and line.plottype EQ 'profile' then *line.levs = *field.levs
      if line.plotz gt 0 and line.plottype ne 'profile' then getaltzdata,info,line,data ;Need to get vertical data if plotting on altitude        
      deflinedata,line,data
      IF line.plotz GE 1 and line.plottype eq 'profile' THEN getzprof,info,line,'profile',fields,zalt
      *info.pline = line
      window,xsize=wanim_xsize,ysize=wanim_ysize,/pixmap
      windo = !d.window
      wset,windo
      pltline,info,/animate
      cw_animate_load,animate,frame=i,window=windo,/track
    endfor
    line.fmin = savefmin & line.fmax = savefmax
    line.slon = savelon & line.sslt = saveslt
    line.data = PTR_NEW(savedata)
    *info.pline = line
    cw_animate_run,animate,nframes=nframes
  end
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; Animate in latitude (fixed ut/longitude):
;
  "lat_fixut": begin
    animbase = widget_base(title='Animate in latitude (fixed ut)')
    nframes = field.nlat
;
; Save some state parameters of fixed window:
;
    savefmin = line.fmin & savefmax = line.fmax
    savemtime = line.mtime   & saveimtime = line.imtime
    saveut = line.ut         & savelon = line.slon
    saveslt = line.sslt      & savelat = line.slat
    savedata = *line.data
;
; Set min,max for constant scale from manual setting or data range:
;
    getDatMinMax,info,line,field,file,0,nframes,func
;
; Load frames and run cw_animate:
;
    animate = cw_animate(animbase,wanim_xsize,wanim_ysize,nframes)
    add_animid,info,animate

    widget_control,animbase,/realize 
    for i=0,nframes-1 do begin
      line.slat = (*field.lats)[i]
;     line.sslt = fslt(0.,line.ut,line.slon,1)
      line.sslt = fslt(line.sslt,line.ut,line.slon,"getlt",mag=mag)
      if line.plotz ge 1 and info.ftype eq 'WACCM' and line.plottype EQ 'profile' then *line.levs = *field.levs
      if line.plotz gt 0 and line.plottype ne 'profile' then getaltzdata,info,line,data ;Need to get vertical data if plotting on altitude        
      deflinedata,line,data
      IF line.plotz GE 1 and line.plottype eq 'profile' THEN getzprof,info,line,'profile',fields,zalt
      data1 = *line.data
      *info.pline = line
      window,xsize=wanim_xsize,ysize=wanim_ysize,/pixmap
      windo = !d.window
      wset,windo
      pltline,info,/animate
      cw_animate_load,animate,frame=i,window=windo,/track
    endfor
    line.fmin = savefmin & line.fmax = savefmax
    line.slat = savelat & line.sslt = saveslt
    line.data = PTR_NEW(savedata)
    *info.pline = line
    cw_animate_run,animate,nframes=nframes
  end
;
; Unknown animation type:
;
  else: print,'>>> animate_lines: unknown animation type func=',func
endcase

widget_control,hourglass=0
xmanager,"Map Animation",animbase,event_handler="anim_event"
;info = save_info
end

