;
pro animate_maps,info,map,func
;
; Animate in time if func=='time', or in zvert if func='zvert'
;
fields = *info.fields
file = *info.pfile
field = fields[map.ifield]
save_info = info
data = *fields[map.ifield].data
 wanim_xsize=455 & wanim_ysize=450
;
; Animate in time:
;
widget_control,/hourglass
if (func eq 'time') then begin
  animbase = widget_base(title='Animate maps in time')
  newtimes=intarr(3,3)
  utmin=intarr(3,1)
  utmax=intarr(3,1)
  utmin[0]=file.mtimes[0,0] & utmin[1]=file.mtimes[1,0] & $
    utmin[2]=file.mtimes[2,0]
  utmax[0]=file.mtimes[0,file.ntimes-1] & utmax[1]=file.mtimes[1,file.ntimes-1] & $
    utmax[2]=file.mtimes[2,file.ntimes-1]

  interval=1 ; NO!!
;
; Set interval to mtimes[*,1] - mtimes[*,0] in day,hr,min:
  interval_mtime = intarr(3)
  interval_mtime[0] = file.mtimes[0,1]-file.mtimes[0,0] ; day diff 
  interval_mtime[1] = file.mtimes[1,1]-file.mtimes[1,0] ; hr diff 
  interval_mtime[2] = file.mtimes[2,1]-file.mtimes[2,0] ; min diff 

      if file.mtimes[0,0] ne file.mtimes[0,1] and file.mtimes[1,1] eq file.mtimes[1,0] $
        and file.mtimes[2,0] eq file.mtimes[2,1] then type='day'
      if file.mtimes[1,1] ne file.mtimes[1,0] $
        and file.mtimes[2,0] eq file.mtimes[2,1] then type='hr'
      if file.mtimes[2,0] ne file.mtimes[2,1] then type='min'
      
;
; Set interval for setaxis_ut:
;
  if (type eq 'day') then interval = interval_mtime[0]
  if (type eq 'hr') then interval = interval_mtime[1]
  if (type eq 'min') then interval = interval_mtime[2]

  newtimes=setaxis_ut(info,info.pmap,utmin,utmax,interval)

  utmin[0]=newtimes[0,0] & utmin[1]=newtimes[1,0] & $
    utmin[2]=newtimes[2,0]
  utmax[0]=newtimes[0,1] & utmax[1]=newtimes[1,1] & $
    utmax[2]=newtimes[2,1]
  interval=newtimes[0,2]
  if (interval eq -1) then begin
    print,'Cancelling lon slice animation..'
    return
  endif
  type_hist=newtimes[1,2]
  imtime_min = -1
  imtime_max = -1
  for i=0,file.ntimes-1 do begin
    if file.mtimes[0,i] eq utmin[0] and file.mtimes[1,i] eq utmin[1] and $
      file.mtimes[2,i] eq utmin[2] then begin
      imtime_min=i
    endif
    if file.mtimes[0,i] eq utmax[0] and file.mtimes[1,i] eq utmax[1] and $
      file.mtimes[2,i] eq utmax[2] then begin
      imtime_max=i
    endif
  endfor
  if imtime_min gt imtime_max then $
    imtime_max=file.ntimes-1 & $  
  nframes=imtime_max-imtime_min+1
;
; Calculate min,max for entire animation if not already fixed:
;
  savemtime  = map.mtime  & saveimtime = map.imtime
  savefmin = map.fmin & savefmax = map.fmax
;
  if map.setcontour eq 'off' then begin
    map.fmin =  1.e36 & map.fmax = -1.e36
    for i=0,nframes-1 do begin
      defmapdata,map,data,map.izvert,i 
      fminmax,*map.data,fmin,fmax,file.missing_value
      if fmin lt map.fmin then map.fmin = fmin
      if fmax gt map.fmax then map.fmax = fmax
      cmin=0. & cmax=0. & cint=0.
      levels = mkclevels(fmin,fmax,cmin,cmax,cint)
      *map.clevels = levels
    endfor
  endif
;
; Load frames and run cw_animate:
;
  numberframes=0 
  for i=0,nframes-1 do begin
    map.imtime = i+imtime_min
    if file.mtimes[type_hist,map.imtime] mod interval eq 0 then begin
      numberframes=numberframes+1
    endif
  endfor
  animate = cw_animate(animbase,wanim_xsize,wanim_ysize, $
    numberframes)
  add_animid,info,animate

  widget_control,animbase,/realize 
  framenum=0
  for i=0,nframes-1 do begin
    defmapdata,map,data,map.izvert,i 
    map.imtime = i+imtime_min
    if file.mtimes[type_hist,map.imtime] mod interval eq 0 then begin
      map.mtime = file.mtimes[*,map.imtime]
      *info.pmap = map
      window,xsize=wanim_xsize,ysize=wanim_ysize,/pixmap
      windo = !d.window
      wset,windo
      pltmaps,info,/animate
      cw_animate_load,animate,frame=framenum,window=windo,/track
      framenum=framenum+1
    endif
  endfor
  map.mtime = savemtime & map.imtime = saveimtime
  map.fmin = savefmin & map.fmax = savefmax
  *info.pmap = map
  cw_animate_run,animate,numberframes
;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; Animate in zvert:
;
endif else begin ; animate in zvert 
  animbase = widget_base(title='Animate maps in vertical')
  nframes = field.nlev
;
;  WACCM data is interpolated to a 'standard' log pressure grid so level information comes from map structure
;
  IF info.ftype EQ 'WACCM' THEN BEGIN
    
    levsW = map.levs
    nframes = N_ELEMENTS(levsW)

  ENDIF
;
; Calculate min,max for entire animation if not already fixed:
;
  savezvert = map.zvert & saveizvert = map.izvert
  savefmin = map.fmin & savefmax = map.fmax
;
  if map.fmin ge map.fmax then begin ; user has not set minmax
    map.fmin =  1.e36 & map.fmax = -1.e36
    for i=0,nframes-1 do begin
      defmapdata,map,data,i,map.imtime
      fminmax,*map.data,fmin,fmax,file.missing_value
      if fmin lt map.fmin then map.fmin = fmin
      if fmax gt map.fmax then map.fmax = fmax
    endfor
  endif else $
    print,'animate_maps: using already set fmin,max=',map.fmin,map.fmax
;
  animate = cw_animate(animbase,wanim_xsize,wanim_ysize,nframes)
  add_animid,info,animate
  widget_control,animbase,/realize 
  for i=0,nframes-1 do begin
    defmapdata,map,data,i,map.imtime 
    map.izvert = i
    map.zvert = (*field.levs)[map.izvert]
;
;  WACCM gets level values from map structure
;    
    IF info.ftype EQ 'WACCM' THEN map.zvert = levsW[map.izvert]

    *info.pmap = map
    window,xsize=wanim_xsize,ysize=wanim_ysize,/pixmap
    windo = !d.window
    wset,windo
    pltmaps,info,/animate
    cw_animate_load,animate,frame=i,window=windo,/track
  endfor
  map.fmin = savefmin & map.fmax = savefmax
  map.zvert = savezvert & map.izvert = saveizvert
  *info.pmap = map
  cw_animate_run,animate,nframes=nframes
endelse
widget_control,hourglass=0
xmanager,"Map Animation",animbase,event_handler="anim_event"
info = save_info
end

