;-----------------------------------------------------------------------
function ifindtime,mtime,mtimes,ntimes
  for i=0,ntimes-1 do begin
    if mtimes[0,i] eq mtime[0] and mtimes[1,i] eq mtime[1] and $
       mtimes[2,i] eq mtime[2] then begin
      return,i
    endif
  endfor
  print,format="('>>> ifindtime: could not find mtime ',3i4)",mtime
  print,format="('>>> ntimes=',i4)",ntimes
  print,format="('mtimes[*,0]=',3i4,' mtimes[*,ntimes]=',3i4)",$
    mtimes[*,0],mtime[*,ntimes-1]
  return,-1
end
;-----------------------------------------------------------------------
function total_mins,mtime
;
; Return total time in minutes from and mtime (day,hr,min):
;
  totaltime = long(mtime[0]*24) & totaltime=totaltime*60
  totaltime = totaltime+mtime[1]*60+mtime[2]
  return,totaltime
end 
;-----------------------------------------------------------------------
pro animate_utvert,info,func

utvert = *info.putvert
fields = *info.fields
field = fields[utvert.ifield]
data = *field.data
file = *info.pfile
wanim_xsize=utvert.draw_xsize & wanim_ysize=utvert.draw_ysize
mag = 0 & if field.grid_type eq 'magnetic' then mag = 1

;
; Animate in latitude (fixed longitude):
;
widget_control,/hourglass
if (func eq "lat_fixlon") then begin
    animbase = widget_base(title=$
      'Animate ut vs vertical in latitude (fixed longitude)')
    nframes=field.nlat
    print,'animate_utvert: nframes = nlat = ',nframes

;
; Set min,max for constant scale:
; Save current:
;
    savefmin  = utvert.fmin  & savefmax = utvert.fmax
    savecint  = utvert.cint
;
; Calculate min,max for entire animation if not already fixed:
;
    setcontour = utvert.setcontour ; save current setting
    if utvert.setcontour eq 'off' then begin
      utvert.fmin =  1.e36 & utvert.fmax = -1.e36
      for i=0,nframes-1 do begin
        defutvertdata,utvert,data
        IF utvert.plotz GE 1 THEN getzlatlonut,info,utvert,'ut',fields,zalt
        fminmax,*utvert.data,fmin,fmax,file.missing_value
        if fmin lt utvert.fmin then utvert.fmin = fmin
        if fmax gt utvert.fmax then utvert.fmax = fmax
        cmin=0. & cmax=0. & cint=0.
        levels = mkclevels(fmin,fmax,cmin,cmax,cint)
        *utvert.clevels = levels
        utvert.setcontour = 'on'
      endfor
      print,'animate_utvert: calculated min,max for animation sequence:',$
        utvert.fmin,utvert.fmax
    endif

    animate = cw_animate(animbase,wanim_xsize,wanim_ysize,nframes)
    widget_control,animbase,/realize 
    framenum=0
    for j=0,nframes-1 do begin
      utvert.slat = (*field.lats)[j]
      defutvertdata,utvert,data
      IF utvert.plotz GE 1 THEN getzlatlonut,info,utvert,'ut',fields,zalt
      *info.putvert = utvert
      window,xsize=wanim_xsize,ysize=wanim_ysize,/pixmap
      windo = !d.window
      wset,windo
      pltutvert,info,/animate
      cw_animate_load,animate,frame=framenum,window=windo,/track
      framenum=framenum+1
    endfor
    utvert.fmin = savefmin  & utvert.fmax = savefmax
    utvert.cint = savecint
    utvert.setcontour = setcontour
    *info.putvert = utvert
    cw_animate_run,animate,nframes=numberframes
;
; Scan ut or jump ut:
;
  endif else if func eq "ut_scan" or func eq "ut_jump" then begin
    savefmin  = utvert.fmin  & savefmax = utvert.fmax
    savecint  = utvert.cint
    setcontour = utvert.setcontour ; save current setting
    animbase = widget_base(title=$
      'Animate scan ut (fixed location)')
    uts=intarr(3,3)
    utbeg=intarr(3,1)
    utend=intarr(3,1)
    utbeg[0]=file.mtimes[0,0] & utbeg[1]=file.mtimes[1,0] & $
      utbeg[2]=file.mtimes[2,0]
    utend[0]=file.mtimes[0,file.ntimes-1] & utend[1]=file.mtimes[1,file.ntimes-1] & $
      utend[2]=file.mtimes[2,file.ntimes-1]
    interval=1  
;
; Select beginning/ending uts for window width:
;
    uts = setaxis_ut(info,info.putvert,utbeg,utend,interval)
    utbeg[0]=uts[0,0] & utbeg[1]=uts[1,0] & $
      utbeg[2]=uts[2,0]
    utend[0]=uts[0,1] & utend[1]=uts[1,1] & $
      utend[2]=uts[2,1]
    interval=uts[0,2]
    type_hist=uts[1,2]
    if (interval eq -1) then begin
      print,'Cancelling utvert (ut scan) animation..'
      return
    endif
    print,format="('animate_utvert: utbeg=',3i4,' utend=',3i4,' interval=',i3)",$
      utbeg,utend,interval
    print,format="('animate_utvert: utvert.utmin=',3i4,' utvert.utmax=',3i4)",$
      utvert.utmin,utvert.utmax
    timebeg = total_mins(utbeg)
    timeend = total_mins(utend)
    timeplt0 = total_mins(utvert.utmin)
    timeplt1 = total_mins(utvert.utmax)
    plt_mins = timeplt1-timeplt0+1
    time_mins = timeend-timebeg
    if (plt_mins ge time_mins) then begin
      print,' '
      print,'>>> animate_utvert: Plot time-width must be less than total time period'
      print,format="('Plot width (minutes)=',i8,' (',3i4,' to ',3i4,')')",$
        plt_mins,timeplt0,timeplt1
      print,format="('Time width (minutes)=',i8,' (',3i4,' to ',3i4,')')",$
        time_mins,timebeg,timeend
      print,'Please narrow the utvert x-axis to fit inside the beginning/ending times'
      print,'Cancelling utvert animation..'
      print,' '
      return 
    endif
    print,format="('Plot left =',3i4,' Plot right=',3i4)",utvert.utmin,utvert.utmax
    print,format="('Time begin=',3i4,' Time end  =',3i4)",utbeg,utend
    itime_beg = ifindtime(utbeg,file.mtimes,file.ntimes)
    itime_end = ifindtime(utend,file.mtimes,file.ntimes)
    itime_pltbeg = ifindtime(utvert.utmin,file.mtimes,file.ntimes)
    itime_pltend = ifindtime(utvert.utmax,file.mtimes,file.ntimes)
    plt_width = itime_pltend-itime_pltbeg+1

    jump = 1 & if func eq "ut_jump" then jump = plt_width
    print,' plt_width=',plt_width,' jump=',jump
    nframes=0
    for i=itime_beg,itime_end do begin
      if (i mod jump ne 0) then continue
      utvert.utmin = file.mtimes[*,i]
      nframes = nframes+1
      if (i+plt_width gt itime_end) then break
    endfor
    print,'animate_utvert: nframes=',nframes,' plt_width=',plt_width
    animate = cw_animate(animbase,wanim_xsize,wanim_ysize,nframes)
    widget_control,animbase,/realize 
    framenum = 0
    for i=itime_beg,itime_end do begin
      if (i mod jump ne 0) then continue
      utvert.utmin = file.mtimes[*,i]
      if (i+plt_width gt itime_end) then break
      utvert.utmax = file.mtimes[*,i+plt_width]
      print,format=$
        "('i=',i3,' itime_beg,end=',2i8,' jump=',i4,' utvert.utmin,max=',3i4,',',3i4)",$
        i,itime_beg,itime_end,jump,utvert.utmin,utvert.utmax
      defutvertdata,utvert,data
      IF utvert.plotz GE 1 THEN getzlatlonut,info,utvert,'ut',fields,zalt
      *info.putvert = utvert
      window,xsize=wanim_xsize,ysize=wanim_ysize,/pixmap
      windo = !d.window
      wset,windo
      pltutvert,info,/animate
      cw_animate_load,animate,frame=framenum,window=windo,/track
      framenum=framenum+1
    endfor
    utvert.fmin = savefmin  & utvert.fmax = savefmax
    utvert.cint = savecint
    utvert.setcontour = setcontour
    *info.putvert = utvert
    cw_animate_run,animate,nframes=numberframes
  endif else begin
;
; Unknown animation type:
;
    print,'>>> animate_utvert: unknown animation type func=',func
    return
  endelse  
widget_control,hourglass=0
xmanager,"Utvert Animation",animbase,event_handler="anim_event"
end
