;
function calcmean, rval,nval,log10,rmin,spval,iprnt
;
; Return mean of rval(nval), ignoring any values = spval.
; If log10 flag is set, return log10 of mean, or
;   spval if rval(i) is < rmin.
;
calcmean = 0.
ngood = 0
;
; Find the mean, checking for spval:
for i=0,nval-1 do begin
  if (rval(i) ne spval) then begin
    calcmean = calcmean + rval(i)
    ngood = ngood+1
  endif
endfor
;
if (ngood eq nval) then $
  calcmean = calcmean / float(nval) else $
if (ngood le nval and ngood gt 0) then $
  calcmean = calcmean / float(ngood) else $
calcmean = spval
;
if (ngood ne nval and iprnt gt 0) then $
  print,'Calcmean encountered spval: nval=',nval,' ngood=',ngood,$
    ' calcmean=',calcmean
;
if (log10 gt 0) then begin
  if (calcmean eq spval or calcmean le rmin) then $
    calcmean = spval $
  else $
    calcmean = alog10(calcmean)
endif
return,calcmean
end
