;
pro clrbar,bw,bh,xo,yo,labels,BOTCOLOR=botcolor,TOPCOLOR=topcolor,$
  LABCOLOR=labcolor,CHARSIZE=charsize,LABLEFT=lableft,LABTOP=labtop,$
  LABOFFSET=laboffset,COLORTAB=colortab
;
; Display color scale bar (current color table) with optional labels:
; (note: first 4 arguments must be in normalized coordinates (0.->1.)
;
; On input (normalized coords):
;   bw = bar width
;   bh = bar height
;   xo,yo = coordinates of origin of bar (lower left corner)
;   labels (optional) = array of strings to be spaced regularly along 
;     color bar as labels (labels ignored if n_elements(labels) <= 0)
;
; On output:
;   Horizontal color bar is drawn if bw >= bh
;   Vertical bar is drawn if bw < bh
;   Color bar is outlined with color index !p.color, or labcolor if that
;     keyword is set
;   If number of strings in labels is > 0, then labels are drawn in
;     color index !p.color (or labcolor if set) at regularly spaced 
;     intervals, with the first and last labels at each end of the bar.
;     (If n_elements(labels)=1, the single label is placed at the middle
;       of the color bar)
;     (if the bar is horizontal and keyword labtop is not set, labels
;      will appear below the color bar)
;     (if the bar is vertical and keyword lableft is not set, labels
;      will appear to right of color bar)
;     (note: use strcompress to remove white space from label strings
;      for proper centering of labels)
;     Tic marks are drawn across the short dimension of the color bar 
;       at each label, in color index !p.color, or labcolor if that 
;       keyword is set
;
; Keywords:
;   BOTCOLOR = bottom (1st) color index to display (e.g., if botcolor=1, 
;     then the color bar will consist of colors corresponding to indices 
;     1->topcolor) (note this is useful if you have tweaked the color 
;     table to insure a certain background color like black in index 0)
;     (default botcolor = 0)
;   TOPCOLOR = top color index to display, analogous to botcolor above 
;     (e.g., if topcolor=240, then the color bar will consist of colors 
;      corresponding to indices 0->240, (or botcolor->240)) (this is useful
;      if you are reserving the top color index of your table, e.g., 241,
;      to be used for text or polylines (!d.color), rather than data) 
;      (default topcolor index = !d.table_size-1)
;   CHARSIZE = character size for labels (default=1.5)
;   LABLEFT = 1 -> for vertical bar, draw labels on left instead of right
;   LABTOP = 1 -> for horizontal bar, draw labels on top instead of bottom
;   LABOFFSET = offset for labels from nearest bar edge (defaults=.035 for
;     horizontal bar with labels below, .025 for horizontal bar with labels
;     above (/labtop), and .02 for vertical bar (labels left or right))
;   LABCOLOR = color index to use for labels, tic marks, and color bar 
;     outline (default = !p.color)
;
; Contributed by Ben Foster (foster@ncar.ucar.edu) (x1595) 4/93
;
if n_elements(colortab) gt 0 then setclrtab,colortab
;
if (bw le 0. or bw gt 1. or bh le 0. or bh gt 1. or $
    xo lt 0. or xo gt 1. or yo lt 0. or yo gt 1.) then begin
  print,'>>> clrbar: bad arg (all coords and sizes ',$
    'must be in normalized coords (0->1.)): bw,bh=',bw,bh,$
    ' xo,yo=',xo,yo
  return
endif
if (keyword_set(charsize)) then chsize=charsize else chsize = 1.5
if (keyword_set(labcolor)) then iclab = labcolor else iclab = !p.color
if (keyword_set(topcolor)) then itopclr = topcolor else $
  itopclr = !d.table_size-1
if (keyword_set(botcolor)) then ibotclr = botcolor else ibotclr = 0
nc = itopclr-ibotclr+1
if (nc le 0) then begin
  print,'>>> clrbar: no colors?? nc=',nc,' bot,top color indices=',$
    ibotclr,itopclr
  return
endif
nlab = n_elements(labels)
;
; Horizontal color bar:
;
if (bw ge bh) then begin
  cellw = bw/float(nc)
  ii = 0
  for i=ibotclr,itopclr do begin
    x0 = xo + float(ii)*cellw
    x1 = x0+cellw
    x = [x0,x0,x1,x1]
    y = [yo,yo+bh,yo+bh,yo]
    polyfill,x,y,color=i,/norm
    ii = ii+1
  endfor
;
; Border:
;
  x = [xo,xo,xo+bw,xo+bw,xo]
  y = [yo,yo+bh,yo+bh,yo,yo]
  plots,x,y,color=iclab,/norm
;
; Labels:
;
  if (nlab gt 0) then begin
    if (keyword_set(laboffset)) then begin
      laboff = laboffset
    endif else begin
      laboff = .035
      if (keyword_set(labtop)) then laboff = .025
    endelse
    if (keyword_set(labtop)) then yl = yo+bh+laboff else yl = yo-laboff
    if (nlab gt 1) then begin
      labspace = bw/(nlab-1)
      for i = 1,nlab do begin
        xl = xo+(i-1)*labspace
        xyouts,xl,yl,labels(i-1),/norm,align=.5,charsize=chsize
        if (i ne 1 and i ne nlab) then plots,[xl,xl],[yo,yo+bh],$
          color=iclab,/norm
      endfor
    endif else begin	; only one label -- place at middle of bar
      xl = xo+.5*bw
      xyouts,xl,yl,labels(0),/norm,align=.5,charsize=chsize
      plots,[xl,xl],[yo,yo+bh],color=iclab,/norm
    endelse
  endif
;
; Vertical color bar:
;
endif else begin
  cellh = bh/float(nc)
  ii = 0
  for i=ibotclr,itopclr do begin
    y0 = yo + float(ii)*cellh
    y1 = y0+cellh
    x = [xo,xo,xo+bw,xo+bw]
    y = [y0,y1,y1,y0]
    polyfill,x,y,color=i,/norm
    ii = ii+1
  endfor
;
; Border:
;
  x = [xo,xo,xo+bw,xo+bw,xo]
  y = [yo,yo+bh,yo+bh,yo,yo]
  plots,x,y,color=iclab,/norm
;
; Labels:
;
  if (nlab gt 0) then begin
    if (keyword_set(laboffset)) then laboff = laboffset else laboff = .02
    if (keyword_set(lableft)) then begin
      xl = xo-laboff
      align = 1.
    endif else begin
      xl = xo+bw+laboff
      align = 0.
    endelse
    if (nlab gt 1) then begin
      labspace = bh/(nlab-1)
      for i=1,nlab do begin
        yl = yo + (i-1)*labspace
;
; If label goes off right side of window, plot on left side of bar,
; and vice versa (added 10/26/93):
        xpos = xl & alig = align
;       xyouts,2.,2.,labels(i-1),/norm,width=width ; fake to get string width
;       if xpos+width gt 1. then begin
;         xpos = xo-laboff
;         alig = 1.
;       endif
;       if xpos-width lt 0. then begin
;         xpos = xo+bw+laboff
;         alig = 0.
;       endif
        xpos = xo+bw+laboff
        alig = 0.
;
; Draw the label:
        xyouts,xpos,yl-.01,labels(i-1),/norm,align=alig,charsize=chsize
        if (i ne 1 and i ne nlab) then plots,[xo,xo+bw],[yl,yl],$
          color=iclab,/norm
      endfor    
    endif else begin ; only one label -- place halfway up
      yl = yo+.5*bh
      xyouts,xl,yl-.01,labels(0),/norm,align=align,charsize=chsize
      plots,[xo,xo+bw],[yl,yl],color=iclab,/norm
    endelse
  endif
endelse
return
end
