PRO convertlons,info,data
;
;  Convert a 1D data array between WACCM (0 to 360 degrees) longitude grid to 
;  TIME-GCM (-180 to 180 degrees) longitude grid.  Assumes the data array comes 
;  in with 0.0 degrees longitude corresponding to first element.
;
  nDims = SIZE(data,/N_DIMENSIONS)

  IF nDims EQ 1 THEN BEGIN

    nDats = N_ELEMENTS(data)
  
    dataTemp = data

    data = SHIFT(datatemp,nDats/2)
 
  ENDIF ELSE IF nDims EQ 4 THEN BEGIN

    lonID = NCDF_DIMID(info.cdfid,'lon')
    NCDF_DIMINQ,info.cdfid,lonID,lonName,nLons

    varDims = SIZE(data,/DIMENSIONS)
    lonDim = WHERE(varDims eq nLons)

;    if (lonDim LT 0) THEN BEGIN
;      mlonID = NCDF_DIMID(info.cdfid,'mlon')
;      NCDF_DIMINQ,info.cdfid,mlonID,mlonName,nmLons
;      varDims = SIZE(data,/DIMENSIONS)
;      nlonDim = WHERE(varDims eq nmLons)
;      PRINT, 'Magnetic grid field so no longitude conversion needed'
;      RETURN
;      
;    endif

    IF lonDim LT 0 THEN BEGIN

      PRINT, 'Could not find lon dimension for this variable '
      RETURN

    ENDIF

    IF (lonDim EQ 0) THEN BEGIN

      dataTemp = data

      data = SHIFT(dataTemp,nLons/2,0,0,0)

    ENDIF ELSE BEGIN

      MESSAGE,' First dimension of variable is not longitude.  Quitting. '

    ENDELSE
 
  ENDIF

  RETURN

END
