;
pro deflinedata,line,data
;
;  This routine finds the subset of the field data which will be plotted for 
;  three types of line plots, profile, meridional, and zonal.
;
;  If plotting on altitude data is already defined in getaltzdata so just grab 
;  appropriate dimension here depending on line plot type
;
;
; Define line.data(nlat,nlev) from processed var in data.
;
field = line.field
nlon = field.nlon & nlat = field.nlat & nlev = field.nlev

IF line.plotz GE 1 and line.plottype ne 'profile' THEN BEGIN

  dataalt = *line.data
;
;  Based on line plot type vertical profile(data/lev), meridional(lon/data), and zonal(lat/data), 
;  get 2-D subset data for line plot
;
  CASE line.plottype OF

    'meridional': BEGIN

       lons = *field.lons

       for i=0,nlon-1 do begin

         if lons[i] le line.slon+.01 and lons[i] ge line.slon-.01 then begin
  
           iLon = i
           goto, foundLonM 

         endif

       endfor

       foundLonM:

       linedata = REFORM(dataalt[iLon,*])
;
; Take log10 of densities:
;
       if (line.log10 eq 'density fields' and isdensity(field.name) gt 0) or $
          (line.log10 eq 'this frame only') or $
          (line.log10 eq 'all fields') then begin
         missing_value = float(line.missing_value)
         log10f,linedata,missing_value
       endif    
;
; Update line structure:
;
       line.data = ptr_new(linedata)
;
;  Update min/max for data
;  
       fminmax,linedata,line.fmin,line.fmax,line.missing_value

    END

    'zonal': BEGIN

       lats = *field.lats

       FOR iLt=0,nLat-1 DO BEGIN

         IF lats[iLt] LE line.slat+.01 AND lats[iLt] GE line.slat-.01 THEN BEGIN

           iLat = iLt
           goto, foundLatM

         ENDIF

       ENDFOR

       foundLatM:

       linedata = REFORM(dataalt[*,iLat])
;
; Take log10 of densities:
;
       if (line.log10 eq 'density fields' and isdensity(field.name) gt 0) or $
          (line.log10 eq 'this frame only') or $
          (line.log10 eq 'all fields') then begin
         missing_value = float(line.missing_value)
         log10f,linedata,missing_value
       endif    
;
; Update line structure:
;
       line.data = ptr_new(linedata)
;
;  Update min/max for data
;  
       fminmax,linedata,line.fmin,line.fmax,line.missing_value
;
;  Set longitude axis range for meridional mean
;    
       IF line.amplitude NE 0 AND field.name NE 'YAXZ' THEN BEGIN  ;Get wavenumber amplitude
         line.lonmin = 0
         line.lonmax = nlon    
       ENDIF
 
    END

    ELSE: PRINT,'>>> deflinedata: unknown plot type ',line.plottype

  ENDCASE ; plot type
  
ENDIF ELSE BEGIN; Not plotting on altitude level or plotting profile 
;
; Define line.data(nlat,nlev) from processed var in data.
;
nlon = field.nlon & nlat = field.nlat & nlev = field.nlev
;print,' '
;
; Check dimensions (return if field is only 2d lat x lon)
;
dims = size(data,/dimensions)
ndims = n_elements(dims)
error = 0
if (dims[0] ne field.nlon) then begin
  print,'>>> WARNING deflinedata: 1st dimension is not nlons: dims[0]=',$
    dims[0],' but nlon=',field.nlon
  error = 1 
endif
if (dims[1] ne field.nlat) then begin
  print,'>>> WARNING deflinedata: 2nd dimension is not nlats: dims[1]=',$
    dims[1],' but nlat=',field.nlat
  error = 1 
endif
if (dims[2] ne field.nlev) then begin
  print,'>>> WARNING deflinedata: 3rd dimension is not nlevs: dims[2]=',$
    dims[2],' but nlev=',field.nlev
  error = 1 
endif
if nlev le 0 then begin
  print,'>>> deflinedata: nlev=',nlev,' -- cannot make vertical slice.'
  error = 1 
endif
if error gt 0 then begin
  heap_free,line.data
  return
endif
lons = *field.lons
lats = *field.lats
latindices = indgen(nlat)
;
fieldlevs = *field.levs
nfieldlevs = n_elements(fieldlevs)
;
levs = *line.levs
IF line.plottype EQ 'profile' THEN levs = fieldlevs

nlev = n_elements(levs)
;
;  Get profile data for this latitude/longitude
;
iLat = -1
iLon = -1
iLev = -1
;
;  Find indices into field data for longitude, latitude, and vertical level
;
IF line.slev LE line.levmin THEN line.slev = levs[0]
IF line.slev GE line.levmax THEN line.slev = levs[nLev-1]
 
FOR iLv = 0, nLev - 1 DO BEGIN

   IF levs[iLv] LE line.slev+.01 AND levs[iLv] GE line.slev-.01 THEN BEGIN

      iLev = iLv
      goto, foundLev
           
    ENDIF

ENDFOR

foundLev:

for i=0,nlon-1 do begin
  if lons[i] le line.slon+.01 and lons[i] ge line.slon-.01 then begin

    iLon = i
    goto, foundLon 

  endif
endfor

foundLon:

FOR iLt=0,nLat-1 DO BEGIN

  IF lats[iLt] LE line.slat+.01 AND lats[iLt] GE line.slat-.01 THEN BEGIN

    iLat = iLt
    goto, foundLat

  ENDIF

ENDFOR

foundLat:
;
;  Form subset data array
;
linedata = fltarr(nlev)
linedata[*] = 0.
;
;  Check to make sure data indices found for longitude, latitude, and level
;
IF (iLat EQ -1 OR iLon EQ -1 OR iLev EQ -1) THEN BEGIN

  if (iLat EQ -1) then begin
    print,'>>> deflinedata: cannot find latitude ',line.slat,': nlat=',nlat,$
      ' ilat=',ilat,' lats=' & print,lats
    line.data = ptr_new(linedata)
  endif

  if (iLon EQ -1) then begin
    print,'>>> deflinedata: cannot find longitude ',line.slon,': nlon=',nlon,$
      ' ilon=',ilon,' lons=' & print,lons
    line.data = ptr_new(linedata)
  endif

  if (iLev EQ -1) then begin
    print,'>>> deflinedata: cannot find level ',line.slev,': nlev=',nlev,$
      ' ilev=',ilev,' levs=' & print,levs
    line.data = ptr_new(linedata)
  endif

  RETURN

ENDIF
;
;  Set latitude, longitude, and level indices for subsetting input data 
;
line.ilat = ilat
line.ilon = ilon
line.ilev = ilev
line.lats = ptr_new(lats)
line.lons = ptr_new(lons)
;
;  Based on line plot type vertical profile(data/lev), meridional(lon/data), and zonal(lat/data), 
;  get 2-D subset data for line plot
;
CASE line.plottype OF

  'profile': BEGIN

     defprofdata,line,data,linedata

  END

  'meridional': BEGIN

     defmeriddata,line,data,linedata

  END

  'zonal': BEGIN

     defzonaldata,line,data,linedata

  END

  ELSE: PRINT,'>>> deflinedata: unknown plot type ',line.plottype

ENDCASE ; plot type
;
; Update line structure geolocation variables:
;
line.lats = ptr_new(lats)
line.lons = ptr_new(lons)

ENDELSE ; plot on altitude or not

end
