;
pro defprofdata,line,data,linedata
;
;  Get subset of field data to be plotted for profile line plot
;
;  Get data and variables needed
;
  field = line.field
  fieldlevs = *field.levs
  IF line.plotz GE 1 THEN fieldlevs = *line.levs
  nfieldlevs = n_elements(fieldlevs)
  iLat = line.ilat
  ilon = line.ilon
  iLev = line.ilev

  nlon = field.nlon
;
;  Form data array for plotting
;
  linedata = fltarr(nfieldlevs)
  linedata[*] = 0.
;
;  Pick out data based on profile type of line plot
;
;  Get the wavenumber amplitude if requested
; 
  IF line.amplitude NE 0 AND field.name NE 'YAXZ' THEN BEGIN
  
    iwvn = line.wavenumber
    ampdata = fltarr(nlon)
    ampmin = 1.0E+24
    for k=0,nfieldlevs-1 do begin
        
      ampdata[*] = float(data[*,iLat,k,line.imtime])
      ampdata[*] = ABS(FFT(ampdata[*], -1)) * 2.
      if ampdata[iwvn] LT ampmin AND ampdata[iwvn] GT 0.0 then ampmin = ampdata[iwvn]
      linedata[k] = ampdata[iwvn]
    
    endfor

    zeroind = WHERE(linedata[*] EQ 0.0)
    if zeroind[0] NE -1 then linedata[zeroind] = ampmin
 
    IF line.amplitude EQ 2 THEN linedata[*] = ALOG10(linedata[*])
 
  ENDIF ELSE BEGIN
;
;  Grab data from vertical dimension and calculate zonal mean if requested
;
    if line.zonalmean eq 0 then begin
      linedata[*] = float(data[ilon,iLat,*,line.imtime])
    endif else begin ; zonal mean
      for k=0,nfieldlevs-1 do begin
        linedata[k] = float(mean(data[*,iLat,k,line.imtime]))
      endfor
    endelse ; zonal mean
;
; Take log10 of densities if requested:
;
    if (line.log10 eq 'density fields' and isdensity(field.name) gt 0) or $
       (line.log10 eq 'this frame only') or $
       (line.log10 eq 'all fields') then begin
;     print,'deflinedata: taking log10 of field ',field.name,'...'
      missing_value = float(line.missing_value)
      log10f,linedata,missing_value
    endif
 
  ENDELSE
;
;  Update vertical levels
;
  line.levs = PTR_NEW(fieldlevs)
;
; Update line structure:
;
  line.data = ptr_new(linedata)
;
;  Update data min/max for wavenumber amplitude
;
  IF line.amplitude NE 0 AND field.name NE 'YAXZ' THEN fminmaxlev,line
;
;  Interpolate WACCM data to 'standard' log pressure levels
;
  IF line.ftype EQ 'WACCM' THEN BEGIN

    if line.plotz gt 0 then line.levmin = MIN(*line.levs)
    if line.plotz gt 0 then line.levmax = MAX(*line.levs)

    interpwdata, line

  ENDIF

end
