;
function fields_menu,parent,fields,event_pro,mk_insensitive=mk_insensitive
;
; Construct a fields menu, returning widget id.
;
nflds = n_elements(fields)
mxitems = 20
if nflds le mxitems then begin
  fieldsmenu = widget_button(parent,value='Fields')
  for i=0,nflds-1 do begin
    button = widget_button(fieldsmenu,value=fields[i].name,$
      uvalue=fields[i].name,event_pro=event_pro)
  endfor
endif else begin ; > mxitems times
  fieldsmenu = widget_button(parent,value='Fields',/menu)
  nmenus = nflds / mxitems
  menubases = intarr(nmenus)
  print,'fields_menu: nflds=',nflds,' nmenus=',nmenus
  ifld = 0
  for m=0,nmenus-1 do begin
    field0 = fields[ifld].name
    field1 = fields[ifld+mxitems-1].name
    title = field0+' to '+field1
    menubases[m] = widget_button(fieldsmenu,value=title,/menu)
    for i=0,mxitems-1 do begin
      button = widget_button(menubases[m],value=fields[ifld].name,$
        uvalue=fields[ifld].name,event_pro=event_pro)
      ifld = ifld+1
    endfor
  endfor
  nflds_last = nflds mod mxitems
  if nflds_last gt 0 then begin
    title = fields[ifld].name+' to '+fields[ifld+nflds_last-1].name
    menubase = widget_button(fieldsmenu,value=title,/menu)
    for m=0,nflds_last-1 do begin
      button = widget_button(menubase,value=fields[ifld].name,$
        uvalue=fields[ifld].name,event_pro=event_pro)
      ifld = ifld+1
    endfor
  endif
endelse
if keyword_set(mk_insensitive) then $
  widget_control,fieldsmenu,sensitive=0
end

