PRO fminmaxlev, line
;
;  Set minimum and maximum data values in line structure based on the data between the minimum 
;  and maximum vertical levels to plot
;
  data = *line.data
  levs = *line.levs
  levMin = line.levmin
  levMax = line.levmax
  fMin = line.fmin
  fMax = line.fmax
  
  nLevs = N_ELEMENTS(levs)
  
  dataSub = data(WHERE(levs GE levMin AND levs LE levMax))
  
  minDatSub = MIN(dataSub)
  maxDatSub = MAX(dataSub)
  
  IF minDatSub NE fMin THEN line.fmin = minDatSub
  IF maxDatSub NE fMax THEN line.fmax = maxDatSub
    
END
