function get_time_min,mtime,utmin1,utmax1,no_limit=no_limit
;this function returns an array giving all the times in minutes
;written by Tom Freestone 9/17/03

if keyword_set(no_limit) then begin
  tmax=size(mtime)
  tmax=tmax[2]
  utmin=findgen(3)
  utmax=findgen(3)
  utmin[0]=mtime[0,0]
  utmin[1]=mtime[1,0]
  utmin[2]=mtime[2,0]
  utmax[0]=mtime[0,tmax-1]
  utmax[1]=mtime[1,tmax-1]
  utmax[2]=mtime[2,tmax-1]
  utmin=utmin[0]*24.*60.+utmin[1]*60.+utmin[2]
  utmax=utmax[0]*24.*60.+utmax[1]*60.+utmax[2]
endif else begin
  utmin=utmin1[0]*24.*60.+utmin1[1]*60.+utmin1[2]
  utmax=utmax1[0]*24.*60.+utmax1[1]*60.+utmax1[2]
endelse

dims=size(mtime)
if dims[0] eq 1 then dims=1
if dims[0] eq 2 then dims=dims[2]

mtimes=findgen(dims)

t=0
for i=0,dims-1 do begin
  mtimes[i]=mtime[0,i]*24.*60.+mtime[1,i]*60.+mtime[2,i]
  if mtimes[i] ge utmin and mtimes[i] le utmax then begin
    t=t+1
  endif
endfor
times=findgen(t)

t=0
for i=0,dims-1 do begin
  if mtimes[i] ge utmin and mtimes[i] le utmax then begin
    times[t]=mtimes[t]
    t=t+1
  endif
endfor

return,times
end

