;---------------------------------------------------------
pro get_vectors_event,event
  widget_control,event.id,get_uvalue=widget
  widget_control,event.top,get_uvalue=pinfo
  info = *pinfo
  fields = *info.fields
  map = *info.pmap
  vector = map.vector
  field = map.field
  nfields=info.nflds
  case widget of
    'LON_VEC': begin
      widget_control,event.id,get_value=lonvec
      ; gets data for the wind vectors and stores the current field
      for i=0,nfields-1 do begin
        if strcompress(fields[i].name,/remove_all) eq lonvec then iUN = i
      endfor
      mapdata=*map.data
      vector.ilonvec=iUN
      vector.lonvector=lonvec
      index=map.ifield
      data = get_field_data(info,iUN) 
      *vector.lonvecdata=data
      vector.units=fields[iUN].units
      vector.lon_grid_type=fields[iUN].grid_type
      cmin=0. & cmax=0. & cint=0.
      fminmax,data,fmin,fmax,map.missing_value
      levels = mkclevels(fmin,fmax,cmin,cmax,cint)
      vector.lonint=cint
      data = get_field_data(info,index) 
      *map.data=data
      map.vector=vector
      *info.pmap = map
      widget_control,event.top,/destroy
      get_vectors,info
    end
    'LAT_VEC': begin
      widget_control,event.id,get_value=latvec
      for i=0,n_elements(fields)-1 do begin
        if strcompress(fields[i].name,/remove_all) eq latvec then iVN = i
      endfor
      mapdata=*map.data
      vector.ilatvec=iVN
      vector.latvector=latvec
      index=map.ifield
      data = get_field_data(info,iVN) 
      *vector.latvecdata=data
      vector.lat_grid_type=fields[iVN].grid_type
      cmin=0. & cmax=0. & cint=0.
      fminmax,data,fmin,fmax,map.missing_value
      levels = mkclevels(fmin,fmax,cmin,cmax,cint)
      vector.latint=cint
      data = get_field_data(info,index) 
      *map.data=data
      map.vector=vector
      *info.pmap = map
      widget_control,event.top,/destroy
      get_vectors,info
    end
    'VEC_MAG': begin
      widget_control,event.id,get_value=vmagnitude
      vector.vmag=vmagnitude
   ;   if vector.lonint ne 0.0 and vector.latint ne 0.0 then $
   ;     vector.windint=((vector.lonint)^2+(vector.latint)^2)^0.5
      map.vector=vector
      *info.pmap = map
    end
    'TXT_VMAG': begin
      widget_control,event.id,get_value=vmag
      if vmag lt 0. then begin
        print,'>>> Bad scale arrow magnitude (must be >= 0.)'
	vmag=0.0
      endif
      vector.vmag=vmag
      map.vector=vector
      *info.pmap = map
    end
    'SL_VLEN': begin
      vector.vlen = float(event.value)/100.
      devlen = vector.vlen*float(500)
      alen = convert_coord([devlen],[0.],/device,/to_normal)
      mkarrow,.5-.5*alen(0),.5, .5+.5*alen(0),.5,theta=50,color=0
      map.vector=vector
      *info.pmap = map
    end
    'BGP_CLR': begin
      widget_control,event.id,get_value=vclr
      if vclr eq 0 then begin
	vector.carrows=0
	endif else vector.carrows=!d.table_size-1
      map.vector=vector
      *info.pmap = map
    end
    'OK': begin
   ;   if vector.lonint ne 0.0 and vector.latint ne 0.0 then $
   ;     vector.windint=((vector.lonint)^2+(vector.latint)^2)^0.5
      if field.grid_type ne vector.lon_grid_type or $
	 field.grid_type ne vector.lat_grid_type and $
	 vector.ilonvec ge 0 and vector.ilatvec ge 0 and $
	 vector.control ne 'only' then begin
        errtlb=map.tlb  
        message='Map coordinates do not match for the wind fields and current field'  
        error_popup,errtlb,message
	vector.control = 'off'
      endif else if $ 
        vector.ilonvec lt 0 or vector.ilatvec lt 0 then begin
        errtlb=map.tlb  
        message='Make sure that both a Zonal and Meridional Wind Vector is selected'  
        error_popup,errtlb,message
	vector.control = 'off'
      endif else begin  
        widget_control,event.top,/destroy
        map.vector=vector
        *info.pmap = map
        pltmaps,info
      endelse
    end
    'DEFAULT': begin
      if vector.control eq 'only' then begin
        vector.carrows=!d.table_size-1
      endif else vector.carrows =0
      vector.vmag=0.0
      vector.vlen=.07
      vector.londensity=1
      vector.latdensity=1
      if field.grid_type ne vector.lon_grid_type or $
	 field.grid_type ne vector.lat_grid_type and $
	 vector.ilonvec ge 0 and vector.ilatvec ge 0 and $
	 vector.control ne 'only' then begin
        errtlb=map.tlb  
        message='Map coordinates do not match for the wind fields and current field'  
        error_popup,errtlb,message
	vector.control = 'off'
      endif else if $ 
        vector.ilonvec lt 0 or vector.ilatvec lt 0 then begin
        errtlb=map.tlb  
        message='Make sure that both a Zonal and Meridional Wind Vector is selected'  
        error_popup,errtlb,message
	vector.control = 'off'
      endif else begin
        widget_control,event.top,/destroy
        map.vector=vector
        *info.pmap = map
        index=map.ifield
        data = get_field_data(info,vector.ilonvec) 
        *vector.lonvecdata=data
        data = get_field_data(info,vector.ilatvec) 
        *vector.latvecdata=data
        data = get_field_data(info,index) 
        *map.data=data
        map.vector=vector
        *info.pmap = map
        pltmaps,info
      endelse
    end
    'CANCEL': begin
      widget_control,event.top,/destroy
      vector.control='off'
      map.vector=vector
      *info.pmap = map
    end
    else: print,'>>> get_vectors_event: unknown widget ',widget
  endcase
end
;---------------------------------------------------
pro get_vectors,info

  map = *info.pmap
  vector = map.vector
  field = map.field
  fields = *info.fields
  nfields=info.nflds
  mxitems = 20

  title='Vector Arrows'
  vecbase = widget_base(column=1,title=title,group_leader=map.tlb,/modal)
  ;vecbase = widget_base(column=1,title=title)

  ; Sets default fields 
  if vector.ilonvec lt 0 then begin
    for i=0,nfields-1 do begin
      field_string = strcompress(fields[i].name,/remove_all)
      if field_string eq 'UN' then begin 
	vector.lonvector='UN'
        vector.ilonvec=i
      endif else if field_string eq 'UI' and  vector.lonvector ne 'UN' then begin
	vector.lonvector='UI'
        vector.ilonvec=i
      endif 
    endfor
    if vector.ilonvec ge 0 then begin
      index=map.ifield
      data = get_field_data(info,vector.ilonvec) 
      *vector.lonvecdata=data
      vector.units=fields[vector.ilonvec].units
      vector.lon_grid_type=fields[vector.ilonvec].grid_type
      cmin=0. & cmax=0. & cint=0.
      fminmax,data,fmin,fmax,map.missing_value
      levels = mkclevels(fmin,fmax,cmin,cmax,cint)
      vector.lonint=cint
      data = get_field_data(info,index) 
      *map.data=data
      map.vector=vector
      *info.pmap = map
    endif
  endif

  if vector.ilatvec lt 0 then begin
    for i=0,nfields-1 do begin
      field_string = strcompress(fields[i].name,/remove_all)
      if field_string eq 'VN' then begin 
	vector.latvector='VN'
        vector.ilatvec=i
      endif else if field_string eq 'VI' and  vector.latvector ne 'VN' then begin
	vector.latvector='VI'
        vector.ilatvec=i
      endif 
    endfor
    if vector.ilatvec ge 0 then begin
      index=map.ifield
      data = get_field_data(info,vector.ilatvec) 
      *vector.latvecdata=data
      vector.units=fields[vector.ilatvec].units
      vector.lat_grid_type=fields[vector.ilatvec].grid_type
      cmin=0. & cmax=0. & cint=0.
      fminmax,data,fmin,fmax,map.missing_value
      levels = mkclevels(fmin,fmax,cmin,cmax,cint)
      vector.latint=cint
      data = get_field_data(info,index) 
      *map.data=data
      map.vector=vector
      *info.pmap = map
    endif
  endif

  if vector.lonvector ne ' ' then begin
    title='Zonal Vector Field ('
    lonLabel=title+vector.lonvector+')'
  endif else begin
    lonlab = widget_label(vecbase,ysize=15,$
      value="(Please Choose Zonal Vector Field Below)")
    lonLabel='Zonal Vector Field >>'
  endelse
  if nfields le mxitems then begin
    fieldmenu = widget_button(vecbase,value=lonLabel,/menu)
    for i=0,nfields-1 do begin
      field_string = strcompress(fields[i].name,/remove_all)
      button = widget_button(fieldmenu,value=field_string,uvalue='LON_VEC',$
        event_pro=event_pro)
    endfor
  endif else begin ; > mxitems fields
    fieldsmenu = widget_button(vecbase,value=lonLabel,/menu)
    nmenus = nfields / mxitems
    menubases = intarr(nmenus)
;    print,'fields_menu: nflds=',nflds,' nmenus=',nmenus
    ifld = 0
    for m=0,nmenus-1 do begin
      field0 = fields[ifld].name
      field1 = fields[ifld+mxitems-1].name
      title = field0+' to '+field1
      menubases[m] = widget_button(fieldsmenu,value=title,/menu)
      for i=0,mxitems-1 do begin
  	button = widget_button(menubases[m],value=fields[ifld].name,$
  	  uvalue='LON_VEC',event_pro=event_pro)
  	ifld = ifld+1
      endfor
    endfor
    nflds_last = nfields mod mxitems
    if nflds_last gt 0 then begin
      title = fields[ifld].name+' to '+fields[ifld+nflds_last-1].name
      menubase = widget_button(fieldsmenu,value=title,/menu)
      for m=0,nflds_last-1 do begin
  	button = widget_button(menubase,value=fields[ifld].name,$
  	  uvalue='LON_VEC',event_pro=event_pro)
  	ifld = ifld+1
      endfor
    endif
  endelse
     
  if vector.latvector ne ' ' then begin
    title='Meridional Vector Field ('
    latLabel=title+vector.latvector+')'
  endif else begin
    latlab = widget_label(vecbase,ysize=15,$
      value="(Please Choose Meridional Vector Field Below)")
    latLabel='Meridional Vector Field >> '
  endelse
  if nfields le mxitems then begin
    fieldmenu = widget_button(vecbase,value=latLabel,/menu)
    for i=0,nfields-1 do begin
      field_string = strcompress(fields[i].name,/remove_all)
      button = widget_button(fieldmenu,value=field_string,uvalue='LAT_VEC',$
        event_pro=event_pro)
    endfor
  endif else begin ; > mxitems fields
    fieldsmenu = widget_button(vecbase,value=latLabel,/menu)
    nmenus = nfields / mxitems
    menubases = intarr(nmenus)
;    print,'fields_menu: nflds=',nflds,' nmenus=',nmenus
    ifld = 0
    for m=0,nmenus-1 do begin
      field0 = fields[ifld].name
      field1 = fields[ifld+mxitems-1].name
      title = field0+' to '+field1
      menubases[m] = widget_button(fieldsmenu,value=title,/menu)
      for i=0,mxitems-1 do begin
  	button = widget_button(menubases[m],value=fields[ifld].name,$
  	  uvalue='LAT_VEC',event_pro=event_pro)
  	ifld = ifld+1
      endfor
    endfor
    nflds_last = nfields mod mxitems
    if nflds_last gt 0 then begin
      title = fields[ifld].name+' to '+fields[ifld+nflds_last-1].name
      menubase = widget_button(fieldsmenu,value=title,/menu)
      for m=0,nflds_last-1 do begin
  	button = widget_button(menubase,value=fields[ifld].name,$
  	  uvalue='LAT_VEC',event_pro=event_pro)
  	ifld = ifld+1
      endfor
    endif
  endelse
;
; Vector scaling is accomplished with use provided arrow length 
;   corresponding to a magnitude (e.g., a 500 m/s arrow will be of length n)
; map.vmag = magnitude of scale arrow (float)
; mag.vlen = length of scale arrow (int)
;
wvlenwidth = 80. ; this is apparently only a "hint"
hdeg = 50.
base = widget_base(vecbase,/column)
wlab_vscale0 = widget_label(base,ysize=15,$
  value="Magnitude of scale arrow (m/s):")
wlab_vscale1 = widget_label(base,ysize=15,$
  value="(0. means program will choose a magnitude)")
wtxt_vmag = widget_text(base,/editable,/all_events,/no_newline,ysize=1,$
    value=string(format="(f5.1)",vector.vmag),uvalue='TXT_VMAG')
wsl_vlen = widget_slider(base,minimum=0,maximum=25,value=fix(vector.vlen*100.),$
  uvalue='SL_VLEN')
wlab_vlen = widget_label(base,value=$
  string(format="('Length of scale arrow: ',f6.4)",vector.vlen))
;
; Arrow color (currently just black or white):
;
;if imcon eq 1 or vector.vec eq 1 then vector.vclr = 0 else vector.vclr = !d.table_size-1
;ival = 0 & if vector.vclr eq 0 then ival = 1
base = widget_base(vecbase)
if vector.carrows eq 0 then begin
  ival = 0
endif else ival =1
wbgp_vecclr = cw_bgroup(base,/exclusive,/row,set_value=ival,uvalue="BGP_CLR",$
  ["BLACK ARROWS","WHITE ARROWS"])
;

;  arrows = widget_button(vecbase,value='Arrow Color >>',/menu)
;  button = widget_button(arrows,value='Arrows White',$
;    uvalue='ARROWS_WHITE')
;  button = widget_button(arrows,value='Arrows Black',$
;    uvalue='ARROWS_BLACK')

  buttonbase = widget_base(vecbase,column=3)
   
  button = widget_button(buttonbase,value='DEFAULT',uvalue='DEFAULT')
  button = widget_button(buttonbase,value='OK',uvalue='OK')
  button = widget_button(buttonbase,value='CANCEL',uvalue='CANCEL')

;  vector.wdrw_vlen=wdrw_vlen
  widget_control,map.draw,get_value=window
;  widget_control,get_value=window,vector.wdrw_vlen
  wset,window

  pinfo = ptr_new(info)
  widget_control,vecbase,set_uvalue=pinfo
  widget_control,vecbase,/realize
  xmanager,'get_vectors',vecbase,/no_block
end
