;
function gethts,info,slice,slicetype
zp = *slice.levs 
nlev = n_elements(zp)
print,'gethts: zp min,max=',min(zp),max(zp)
fields = *info.fields
;
; Get heights from Z field:
;
ixz = -1
for i=0,n_elements(fields)-1 do begin
  if strcompress(fields[i].name,/remove_all) eq 'Z' then ixz = i
endfor
if ixz eq -1 then begin
  print,'>>> WARNING gethts: Could not find Z field -- extra right-hand',$
    ' axis NOT added.'
  return,0
endif
;
; Read Z field if necessary:
;
if not ptr_valid(fields[ixz].data) then begin ; field has not been read
  print,'WARNING altyax: Z has not been read..'
  widget_control,/hourglass
  varget,info,fields[ixz],zdata
  field = fields[ixz]
  procfield,info,zdata,field,info.z_hist
  fields[ixz] = field
  fmin = min(*fields[ixz].data) & fmax = max(*fields[ixz].data)
  rpt_minmax,info,fields[ixz],fmin,fmax
  *info.fields = fields
endif
fielddata = *fields[ixz].data
slicedata = *slice.data       ; save
log10save = slice.log10       ; save
slice.log10 = 'none'          ; want linear heights
if slicetype eq 'lon' then $
  deflondata,slice,fielddata $ ; get for lon slices (lat,lev)
else $
  deflatdata,slice,fielddata   ; get for lat slices (lon,lev)
zheights = *slice.data
*slice.data = slicedata ; restore
slice.log10 = log10save ; restore
;
; Average over first dimension (lat or lon):
;
dims = size(zheights,/dimensions)
heights = fltarr(dims[1])
for k=0,dims[1]-1 do begin
  heights[k] = calcmean(zheights[*,k],dims[0],0,1.e-20,$
    float(slice.missing_value),0)
endfor
return,heights
end
