;
;-----------------------------------------------------------------------
pro anim_event,event
;
; Event handler for animation window:
;
case event.action of
  "DONE": begin
    widget_control,event.top,/destroy
    return
  end
  else: print,'anim_event: Unknown action: ',event.action
endcase
return
end
;-----------------------------------------------------------------------
pro lats_event,event
widget_control,event.id,get_uvalue=widget
widget_control,event.top,get_uvalue=pinfo
info = *pinfo
lat = *info.plat
fields = *info.fields
field = fields[lat.ifield]
mag = 0 & if field.grid_type eq 'magnetic' then mag = 1
;
case widget of
  'CLOSE': widget_control,event.top,/destroy
  'SELECT_LAT': begin
    lat.slat = event.value
    lats = *fields[lat.ifield].lats
    ilat = ixfind_nearest(lats,lat.slat)
    lat.slat = lats[ilat]
    data = *fields[lat.ifield].data
    deflatdata,lat,data
    IF lat.plotz GE 1 THEN getzlatlonut,info,lat,'lat',fields,zalt ; For altitude as vertical coordinate 
    fminmax,*lat.data,fmin,fmax,lat.missing_value
    lat.fmin = fmin
    lat.fmax = fmax   
    widget_control,lat.wfsl_lat,set_value=lat.slat
    *info.plat = lat
    pltlat,info
  end
  'COLOR': begin
    clrtab = xcolor(info.colortab,event.top)
    info.colortab = clrtab
    pltlat,info
  end
  'LOG10': begin
    lat.log10 = 'density fields'
    data = *fields[lat.ifield].data
    deflatdata,lat,data
    IF lat.plotz GE 1 THEN getzlatlonut,info,lat,'lat',fields,zalt ; For altitude as vertical coordinate    
;
; Reset min,max and contour interval:
    fminmax,*lat.data,fmin,fmax,lat.missing_value
    cmin=0. & cmax=0. & cint=0.
    *lat.clevels = mkclevels(fmin,fmax,cmin,cmax,cint)
    lat.fmin=cmin & lat.fmax=cmax & lat.cint=cint
    *info.plat = lat
    print,'Will plot log10 of density fields'
    pltlat,info
  end
  'LOG10_ALLFIELDS': begin
    lat.log10 = 'all fields'
    data = *fields[lat.ifield].data
    deflatdata,lat,data
    IF lat.plotz GE 1 THEN getzlatlonut,info,lat,'lat',fields,zalt ; For altitude as vertical coordinate
;
; Reset min,max and contour interval:
    fminmax,*lat.data,fmin,fmax,lat.missing_value
    cmin=0. & cmax=0. & cint=0.
    *lat.clevels = mkclevels(fmin,fmax,cmin,cmax,cint)
    lat.fmin=cmin & lat.fmax=cmax & lat.cint=cint
    *info.plat = lat
    print,'Will plot log10 of all fields'
    pltlat,info
  end
  'LINEAR': begin
    lat.log10 = 'none'
    data = *fields[lat.ifield].data
    deflatdata,lat,data
    IF lat.plotz GE 1 THEN getzlatlonut,info,lat,'lat',fields,zalt ; For altitude as vertical coordinate
;
; Reset min,max and contour interval:
    fminmax,*lat.data,fmin,fmax,lat.missing_value
    cmin=0. & cmax=0. & cint=0.
    *lat.clevels = mkclevels(fmin,fmax,cmin,cmax,cint)
    lat.fmin=cmin & lat.fmax=cmax & lat.cint=cint
    *info.plat = lat
    print,'Will plot linear fields (no log10)'
    pltlat,info
  end
  'ANIM_TIME_FIXLAT': begin
    if field.ntime eq 1 then begin
      print,'>>> Cannot animate in time: there is only one time on the file!'
      widget_control,event.id,sensitive=0
    endif else begin
      widget_control,event.id,/sensitive
      animate_lats,info,'time_fixlat'
    endelse
  end
  'ANIM_LAT': begin
    animate_lats,info,'lat_fixut'
  end
  'SET_MINMAX': begin
    umin=lat.fmin & umax=lat.fmax
    setminmax,info,umin,umax  ; lat.fmin,fmax are intent(inout)
    lat.fmin=umin & lat.fmax=umax
    *info.plat = lat
    pltlat,info
  end
  'RESET_MINMAX': begin
    lat.fmin=0. & lat.fmax=0.
    print,'Lon slices: reset image min,max to full range.'
    *info.plat = lat
    pltlat,info
  end
  'SET_YAXIS': begin
; setaxis_vert sets y-axis limits lat.levmin,max and updates *info.plat
; For altitude as vertical coordinate, need to set min/max vertical levels to altitude values   
    IF lat.plotz GE 1 THEN BEGIN
      lat.levmin = lat.levminz
      lat.levmax = lat.levmaxz
    ENDIF
    *info.plat = lat
    setaxis_vert,info,info.plat 
    lat = *info.plat
; For altitude as vertical coordinate, need to set min/max vertical altitude levels    
    IF lat.plotz GE 1 THEN BEGIN
      lat.levminz = lat.levmin
      lat.levmaxz = lat.levmax
    ENDIF
    data = *fields[lat.ifield].data
    deflatdata,lat,data
    IF lat.plotz GE 1 THEN getzlatlonut,info,lat,'lat',fields,zalt ; For altitude as vertical coordinate
    data = *lat.data
    fminmax,data,fmin,fmax,lat.missing_value
; Reset min,max and contour interval:
    cmin=0. & cmax=0. & cint=0.
    levels = mkclevels(fmin,fmax,cmin,cmax,cint) ; reset contour levels
    lat.fmin=cmin & lat.fmax=cmax & lat.cint=cint
    *lat.clevels = levels
    *info.plat = lat
    pltlat,info
  end
  'RESET_YAXIS': begin
    lat.levmin = (*field.levs)[0] & lat.levmax = (*field.levs)[field.nlev-1]
    print,'Lat slices: reset y-axis (zp or ht) to full range.'
    data = *fields[lat.ifield].data
    deflatdata,lat,data
; For altitude as vertical coordinate, need to reset min/max vertical levels    
    IF lat.plotz GE 1 THEN BEGIN
      lat.levminz = 0
      lat.levmaxz = 0
      getzlatlonut,info,lat,'lat',fields,zalt
    ENDIF
    *info.plat = lat
    pltlat,info
  end
  'SET_XAXIS': begin
; sets x-axis limits lon.latmin,max and updates *info.plon
    setaxis_lon,info,info.plat 
    lat = *info.plat
    data = *fields[lat.ifield].data
    deflatdata,lat,data
    IF lat.plotz GE 1 THEN getzlatlonut,info,lat,'lat',fields,zalt ; For altitude as vertical coordinate
    *info.plat = lat
    pltlat,info
  end
  'RESET_XAXIS': begin
    lat.lonmin = (*field.lons)[0] & lat.lonmax = (*field.lons)[field.nlon-1]
    print,'Lat slices: reset x-axis (longitude) to full range.'
;   data = *fields[lat.ifield].data
    data = *field.data
    deflatdata,lat,data
    IF lat.plotz GE 1 THEN getzlatlonut,info,lat,'lat',fields,zalt ; For altitude as vertical coordinate
    *info.plat = lat
    pltlat,info
  end
  'ADD_YAX': begin
    lat.rhyaxis = 1 ; add extra right-hand y-axis
    if field.difftype ne '' then begin
      print,'>>> WARNING: this is a difference fields file: right-hand',$
            '    axis in height is not available...'
      lat.rhyaxis = 0
    endif else if mag eq 1 then begin
      print,'>>> WARNING: this is a magnetic gridded field: right-hand',$
            '    axis in height is not available...'
      lat.rhyaxis = 0
    endif else begin
      print,'Will add extra right-hand y-axis'
    endelse
    *info.plat = lat
    pltlat,info
  end
  'RM_YAX': begin
    lat.rhyaxis = 0 ; remove extra right-hand y-axis
    print,'Will remove extra right-hand y-axis'
    IF lat.plotz GE 1 THEN BEGIN
      data = *fields[lat.ifield].data
      deflatdata,lat,data
      getzlatlonut,info,lat,'lat',fields,zalt
    ENDIF     
    *info.plat = lat
    pltlat,info
  end
  'GPZALT_ON': begin
; Saves current zp levels and data and define and plot new data on geopotential altitude
print, 'Plotting on geopotential altitude in vertical'
; Save current zp levels and data and define and plot new data on geopotential altitude
    IF lat.plotz EQ 0 THEN *lat.levszp = *lat.levs
    IF lat.plotz EQ 0 THEN *lat.datazp = *lat.data
    lat.plotz = 1
    data = *fields[lat.ifield].data
    deflatdata,lat, data
    getzlatlonut,info,lat,'lat',fields,zalt
    *info.plat = lat
    pltlat,info
    lat = *info.plat
  end
  'GMZALT_ON': begin
; Saves current zp levels and data and define and plot new data on geometric altitude
print, 'Plotting on geometric altitude in vertical'
    IF lat.plotz EQ 0 THEN *lat.levszp = *lat.levs
    IF lat.plotz EQ 0 THEN *lat.datazp = *lat.data
    lat.plotz = 2
    data = *fields[lat.ifield].data
    deflatdata,lat, data
    getzlatlonut,info,lat,'lat',fields,zalt
    *info.plat = lat
    pltlat,info
    lat = *info.plat
  end
  'ZALT_OFF': begin
; Resets vertical zp axis and data from altitude vertical
print, 'Plotting on altitude in vertical off'
    lat.plotz = 0
    lfield = lat.field
    if info.ftype ne 'WACCM' then *lfield.levs = *lat.levszp
    lat.field = lfield
    *lat.levs = *lat.levszp
    *lat.data = *lat.datazp
    lat.levmin = MIN(*lat.levs)
    lat.levmax = MAX(*lat.levs)
    fminmax,*lat.data,fmin,fmax,lat.missing_value
    lat.fmin=fmin & lat.fmax=fmax 
    *info.plat = lat
    pltlat,info
    lat = *info.plat
  end
  'MINMAXLAB_ON': begin
; Turns bottom minimum maximum data range label on
print, 'Turning on mimimum/maximum data label'
    lat.minmaxlab = 1
    *info.plat = lat
    pltlat,info
  end
  'MINMAXLAB_OFF': begin
; Turns bottom minimum maximum data range label off
print, 'Turning off mimimum/maximum data label'
    lat.minmaxlab = 0
    *info.plat = lat
    pltlat,info
  end
  'FILELAB_ON': begin
; Turns bottom file range label on
print, 'Turning on file label'
    lat.filelab = 1
    *info.plat = lat
    pltlat,info
  end
  'FILELAB_OFF': begin
; Turns bottom file label off
print, 'Turning off file label'
    lat.filelab = 0
    *info.plat = lat
    pltlat,info
  end
  'CUSTOM_CONTOUR': begin
    lat.setcontour='on'
    cmin=lat.fmin & cmax=lat.fmax & cint=lat.cint & clineclr = lat.clineclr
    custom_contour,info.tlb,cmin,cmax,cint,clineclr
    lat.clineclr = clineclr
    data = *fields[lat.ifield].data
    deflatdata,lat,data
    IF lat.plotz GE 1 THEN getzlatlonut,info,lat,'lat',fields,zalt ; For altitude as vertical coordinate
    data = *lat.data
    fminmax,data,fmin,fmax,lat.missing_value
    levels = mkclevels(fmin,fmax,cmin,cmax,cint)
    lat.fmin=cmin & lat.fmax=cmax & lat.cint=cint
    *lat.clevels = levels
    *info.plat = lat
    pltlat,info
  end
  'RESET_CONTOUR': begin
    lat.setcontour='off'
    cmin=0. & cmax=0. & cint=0.
    print,'Lat slices: reset contour min,max to full range.'
    data = *fields[lat.ifield].data
    deflatdata,lat,data
    IF lat.plotz GE 1 THEN getzlatlonut,info,lat,'lat',fields,zalt ; For altitude as vertical coordinate
    data = *lat.data
    fminmax,data,fmin,fmax,lat.missing_value
    levels = mkclevels(fmin,fmax,cmin,cmax,cint)
    lat.fmin=cmin & lat.fmax=cmax & lat.cint=cint
    *lat.clevels = levels
    *info.plat = lat
    pltlat,info
  end
;
; Save images in ps or bitmap file for export:
;
  'SAVE_PS': begin
    title='Select File for Postscript'
    psfile = dialog_pickfile(path=info.openpath,title=title,$
      group=event.top)
    if (psfile ne '') then begin
      widget_control,event.top,hourglass=1
      pson,filename=psfile,margin=1.0
      setclrtab,info.colortab,/ps
      pltlat,info,/ps
      psoff
      widget_control,event.top,hourglass=0
    endif
  end
  'SAVE_PNG': begin
    windowsave = !d.window
    window,xsize=lat.draw_xsize,ysize=lat.draw_ysize,/pixmap
    windo = !d.window
    wset,windo
    setclrtab,info.colortab
    pltlat,info,/png
    writeimage,info.openpath,event.top,'PNG'
    wset,windowsave
  end
  'SAVE_GIF': begin
    version = float(!version.release)
    if version le 5.3 then begin
      writeimage,info.openpath,event.top,'GIF'
    endif else begin 
      print,'>>> NEED IDL version 5.3 to make GIF'
    endelse
  end  
  'SAVE_BMP': writeimage,info.openpath,event.top,'BMP'
  'SAVE_JPEG': writeimage,info.openpath,event.top,'JPEG'
  'SAVE_TIFF': writeimage,info.openpath,event.top,'TIFF'
;
; Plot types
;
  'IMAGE_ONLY': begin
    lat.plottype = 'image_only'
;  Need to get data again for altitude vertical axis
    IF lat.plotz GE 1 THEN BEGIN
      data = *fields[lat.ifield].data
      deflatdata,lat,data
      getzlatlonut,info,lat,'lat',fields,zalt
    ENDIF     
    *info.plat = lat
    print,'Set plot type to ',lat.plottype
    pltlat,info
    widget_control,lat.minmaxmenu,sensitive=1   ; can set image min,max
    widget_control,lat.contourmenu,sensitive=0  ; not doing contours
  end
  'IMAGE+CONTOURS': begin
    lat.plottype = 'image+contours'
;  Need to get data again for altitude vertical axis
    IF lat.plotz GE 1 THEN BEGIN
      data = *fields[lat.ifield].data
      deflatdata,lat,data
      getzlatlonut,info,lat,'lat',fields,zalt
    ENDIF     
    *info.plat = lat
    print,'Set plot type to ',lat.plottype
    pltlat,info
    widget_control,lat.minmaxmenu,sensitive=0   ; image minmax will be fmin,fmax
    widget_control,lat.contourmenu,sensitive=1  ; doing contours
  end
  'MONOCHROME_CONTOURS': begin
    lat.plottype = 'monochrome_contours'
;  Need to get data again for altitude vertical axis
    IF lat.plotz GE 1 THEN BEGIN
      data = *fields[lat.ifield].data
      deflatdata,lat,data
      getzlatlonut,info,lat,'lat',fields,zalt
    ENDIF     
    *info.plat = lat
    print,'Set plot type to ',lat.plottype
    pltlat,info
    widget_control,lat.minmaxmenu,sensitive=0   ; image minmax will be fmin,fmax
    widget_control,lat.contourmenu,sensitive=1  ; doing contours
  end
  'COLORFILL_CONTOURS': begin
    lat.plottype = 'colorfill_contours'
;  Need to get data again for altitude vertical axis
    IF lat.plotz GE 1 THEN BEGIN
      data = *fields[lat.ifield].data
      deflatdata,lat,data
      getzlatlonut,info,lat,'lat',fields,zalt
    ENDIF     
    *info.plat = lat
    print,'Set plot type to ',lat.plottype
    pltlat,info
    widget_control,lat.minmaxmenu,sensitive=0   ; image minmax will be fmin,fmax
    widget_control,lat.contourmenu,sensitive=1  ; doing contours
  end
  else: print,'>>> lats_event: unknown widget ',widget
endcase
*pinfo = info
end
;-----------------------------------------------------------------------
pro field_lat_event,event
;
; User has selected a field. Read field from the file and update
; lat structure.
;
widget_control,event.id,get_uvalue=widget
widget_control,event.top,get_uvalue=pinfo
info = *pinfo
lat = *info.plat
lat.setcontour='off'
fields = *info.fields
gridtype_prev = fields[lat.ifield].grid_type
for i=0,info.nflds-1 do begin
  if (widget eq fields[i].name) then begin
    lat.ifield = i
    if ptr_valid(fields[i].data) then begin ; field has been read
      print,'Selected field ',fields[i].name
      fmin = min(*fields[i].data) & fmax = max(*fields[i].data)
      lat.field = fields[i];;;;JOE
    endif else begin
      widget_control,/hourglass
      varget,info,fields[i],ncdata
      field = fields[i]
      procfield,info,ncdata,field,info.z_hist
      fields[i] = field
      lat.field = field
      lat.levs = lat.field.levs
      lat.data = lat.field.data;;;;JOE
      IF lat.plotz GT 0 AND lat.ftype EQ 'WACCM' THEN *lat.levszp = *lat.field.levs
      IF lat.plotz GT 0 AND lat.ftype EQ 'WACCM' THEN *lat.datazp = *lat.field.data
      fmin = min(*fields[i].data) & fmax = max(*fields[i].data)
      rpt_minmax,info,fields[i],fmin,fmax
    endelse
    data = *fields[lat.ifield].data
;
; If this is a change in grid type, reset select-latitude slider:
;
    if fields[lat.ifield].grid_type ne gridtype_prev then begin
      mag = 0 & if fields[lat.ifield].grid_type eq 'magnetic' then mag = 1
;     print,'Switching latitude slider geo<->mag..'
      base = widget_info(lat.wfsl_lat,/parent)
      widget_control,lat.wfsl_lat,/destroy
      lats = *fields[lat.ifield].lats
      nlat = n_elements(lats)

      if fields[lat.ifield].grid_type eq 'magnetic' then begin
        title = 'Find Nearest Magnetic Latitude'
        ilat = ixfind_nearest(lats,lat.slat)
        slat = lats[ilat]
        lat.wfsl_lat = cw_fslide(base,minimum=lats[0],maximum=lats[nlat-1],$
          delta=1.,xsize=240,uvalue="SELECT_LAT",format='(f7.2)',value=slat,$
          title=title)
      endif else begin
        dlat = lats[1]-lats[0] ; new dlat
        ilat = ixfind(lats,lat.slat,dlat)
        lat.slat = lats(ilat)
        title = 'Select Geographic Latitude'
        lat.wfsl_lat = cw_fslide(base,minimum=lats[0],maximum=lats[nlat-1],$
          delta=dlat,xsize=200,uvalue="SELECT_LAT",format='(f7.2)',$
          value=lat.slat,title=title)
      endelse
    endif
    deflatdata,lat,data
    if (not ptr_valid(lat.data)) then begin 
;     print,'lats: invalid pointer returned from deflatdata -- returning'
      return
    endif
    IF lat.plotz GE 1 THEN getzlatlonut,info,lat,'lat',fields,zalt ; For altitude as vertical coordinate
;
; Reset contour levels:
;
    data = *lat.data
    fminmax,data,fmin,fmax,lat.missing_value
    cmin=0. & cmax=0. & cint=0.
    levels = mkclevels(fmin,fmax,cmin,cmax,cint)
    lat.fmin=cmin & lat.fmax=cmax & lat.cint=cint
    *lat.clevels = levels
  endif ; found field name
endfor
;
; Update state info:
*info.fields = fields
*info.plat = lat
*pinfo = info
pltlat,info
end
;-----------------------------------------------------------------------
pro mtime_lat_event,event
;
; Respond to user selection of a model time:
;
widget_control,event.top,get_uvalue=pinfo
widget_control,event.id,get_uvalue=mtime_request
info = *pinfo
fields = *info.fields
lat = *info.plat
field = fields[lat.ifield]
mag = 0 & if field.grid_type eq 'magnetic' then mag = 1
file = *info.pfile
imtime = -1
for i=0,file.ntimes-1 do begin
  mtime_string = $
    strcompress(string(file.mtimes[0,i]),/remove_all)+','+ $
    strcompress(string(file.mtimes[1,i]),/remove_all)+','+ $
    strcompress(string(file.mtimes[2,i]),/remove_all)
  if mtime_string eq mtime_request then begin
    imtime = i
    goto, found
  endif
endfor
print,'>>> WARNING mtime_lat_event: could not find index to model time ',$
  mtime_request
return
found:
lat.imtime = imtime
lat.mtime = file.mtimes[*,imtime]
;
; Reset slt slider from new ut and current selected lat:
;
lat.ut = lat.mtime[1]+lat.mtime[2]/60.
;
; Define latitude slice data:
;
data = *fields[lat.ifield].data
deflatdata,lat,data
IF lat.plotz GE 1 THEN getzlatlonut,info,lat,'lat',fields,zalt ; For altitude as vertical coordinate
;
; Reset contour levels:
;
if lat.setcontour eq 'off' then begin
  data = *lat.data
  fminmax,data,fmin,fmax,lat.missing_value
  cmin=0. & cmax=0. & cint=0.
  levels = mkclevels(fmin,fmax,cmin,cmax,cint)
  lat.fmin=cmin & lat.fmax=cmax & lat.cint=cint
  *lat.clevels = levels
endif
;
*info.plat = lat
pltlat,info
end ; mtime_lat_event
;-----------------------------------------------------------------------
pro lats,info
;
; Set up latitude slice widget:
;
file = *info.pfile     ; file info structure
fields = *info.fields  ; fields info structure
;
title = 'Lat Slices: '+info.file
tlb = widget_base(column=1,mbar=mbar, title=title)
;
lat_ids = *info.plat_ids
for i=0,n_elements(lat_ids)-1 do begin
  if (lat_ids(i) le 0) then begin
    lat_ids(i) = tlb
;   print,'lats: added tlb ',tlb,' to lat_ids at i=',i
    goto,done
  endif
endfor
done:
latbase = tlb
missing_value = file.missing_value
;
; Fields menu:
;
;fieldsmenu = widget_button(mbar,value='Field')
;for i=0,info.nflds-1 do begin
;  button = widget_button(fieldsmenu,value=fields[i].name,$
;    uvalue=fields[i].name,event_pro='field_lat_event')
;  if (i eq 0) then field = fields[i].name
;endfor
 fieldsmenu = fields_menu(mbar,fields,'field_lat_event')
;
; Model times menu:
;
mtimesmenu = mtime_menu(mbar,file.mtimes,'mtime_lat_event')
mtime = file.mtimes[*,0]
imtime = 0
ut = mtime[1]+mtime[2]/60.
;
; ------------------------- Plot options menus -----------------
;
optsmenu = widget_button(mbar,value='PlotOptions')
;
; Plot types (submenu under plot options):
;
plottype = widget_button(optsmenu,value='Plot Type',/menu)
button = widget_button(plottype,$
  value='Image Only',uvalue='IMAGE_ONLY')
button = widget_button(plottype,$
  value='Image plus Contours',uvalue='IMAGE+CONTOURS')
button = widget_button(plottype,$
  value='Monochrome Contours',uvalue='MONOCHROME_CONTOURS')
button = widget_button(plottype,$
  value='Color-fill Contours',uvalue='COLORFILL_CONTOURS')
;
; Plotting log10 of the fields: there are 3 options:
;   lat.log10 = 'density fields'  -> plot log10 of density fields only
;   lat.log10 = 'all fields'      -> always plot log10
;   lat.log10 = 'none'            -> never plot log10
; (See pro lats_event above, and deflatdata.pro and pltlat.pro)
; Log10 submenu under PlotOptions:
;
log10menu = widget_button(optsmenu,value='Plot log10 of field:',/menu)
button = widget_button(log10menu,value='Plot log10 (density fields only)',$
  uvalue='LOG10')
button = widget_button(log10menu,value='Plot log10 (all fields)',$
  uvalue='LOG10_ALLFIELDS')
button = widget_button(log10menu,value='Plot linear (all fields)',$
  uvalue='LINEAR')
;
; Add or remove extra right-hand y-axis (if left-hand y-axis is linear
; Zp then add non-linear right y-axis in height):
;
yaxmenu = widget_button(optsmenu,value='Extra right-hand y-axis:',/menu)
button = widget_button(yaxmenu,value='Add Extra Right-hand Y-axis',$
  uvalue='ADD_YAX')
button = widget_button(yaxmenu,value='Remove Extra Right-hand Y-axis',$
  uvalue='RM_YAX')
;
; User set y-axis range (zp):
;
yaxismenu = widget_button(optsmenu,value='Set y-axis range (zp or ht)',/menu)
button = widget_button(yaxismenu,value='Reset to full range',$
  uvalue='RESET_YAXIS')
button = widget_button(yaxismenu,value='Set vertical min,max...',$
  uvalue='SET_YAXIS')
;
; User set x-axis range (longitude):
;
xaxismenu = widget_button(optsmenu,value='Set x-axis range (longitude)',/menu)
button = widget_button(xaxismenu,value='Reset to full range',$
  uvalue='RESET_XAXIS')
button = widget_button(xaxismenu,value='Set longitude min,max...',$
  uvalue='SET_XAXIS')
;
; Custom Contour:
;
contourmenu = widget_button(optsmenu,value='Custom Contour',/menu)
button = widget_button(contourmenu,value='Reset to full range',$
  uvalue='RESET_CONTOUR')
button = widget_button(contourmenu,value='Set min,max,interval...',$
  uvalue='CUSTOM_CONTOUR')
;
; User set field min,max to be plotted:
;
minmaxmenu = widget_button(optsmenu,value='Fix Image min,max',/menu)
button = widget_button(minmaxmenu,value='Reset to full range',$
  uvalue='RESET_MINMAX') 
button = widget_button(minmaxmenu,value='Set Image min,max...',$
  uvalue='SET_MINMAX') 
;
; Change color tables:
;
button = widget_button(optsmenu,value='Color...',uvalue='COLOR')
;
; Plot profiles on altitude as the vertical y-axis
;    
zaltmenu = widget_button(optsmenu,value='Set y-axis to Altitude',/menu)
button = widget_button(zaltmenu,value='Geopotential Altitude as y-axis On',uvalue='GPZALT_ON')
button = widget_button(zaltmenu,value='Geometric Altitude as y-axis On',uvalue='GMZALT_ON')
button = widget_button(zaltmenu,value='Altitude as y-axis Off',uvalue='ZALT_OFF')
;
; Turn min/max and file labels on/off
;    
labsmenu = widget_button(optsmenu,value='Turn Labels On/Off',/menu)
button = widget_button(labsmenu,value='Min/Max Label On',uvalue='MINMAXLAB_ON')
button = widget_button(labsmenu,value='Min/Max Label Off',uvalue='MINMAXLAB_OFF')
button = widget_button(labsmenu,value='File Label On',uvalue='FILELAB_ON')
button = widget_button(labsmenu,value='File Label Off',uvalue='FILELAB_OFF')
;
; ------------------------- Animation menus --------------------------
;
animmenu = widget_button(mbar,value='Animate')
button = widget_button(animmenu,value='Animate in time (fixed latitude)',$
  uvalue='ANIM_TIME_FIXLAT')
animlat = widget_button(animmenu,value='Animate in latitude (fixed ut)',$
  uvalue='ANIM_LAT')
;
; ------------------------- Save output files --------------------------
;
savemenu = widget_button(mbar,value='SaveFiles')
button = widget_button(savemenu,value='Postscript...',uvalue='SAVE_PS')
button = widget_button(savemenu,value='PNG...',uvalue='SAVE_PNG')
button = widget_button(savemenu,value='GIF...',uvalue='SAVE_GIF')
button = widget_button(savemenu,value='BMP...',uvalue='SAVE_BMP')
button = widget_button(savemenu,value='JPEG...',uvalue='SAVE_JPEG')
button = widget_button(savemenu,value='TIFF...',uvalue='SAVE_TIFF')
;
; ------------------ Sliders for selected lats ------------------------
;
; Base for slider that selects latitude:
;
sliderbase = widget_base(tlb,column=1,/frame)
;
; Select latitude:
;
lats = *fields[0].lats
nlat = n_elements(lats)
dlat = lats[1]-lats[0] ; this will be irregular if magnetic
slat = lats[0]
slatbase = widget_base(sliderbase)
if fields[0].grid_type eq 'magnetic' then begin
  title = 'Find Nearest Magnetic Latitude'
  wfsl_slat = cw_fslide(slatbase,minimum=lats[0],maximum=lats[nlat-1],$
    delta=1.,xsize=240,uvalue="SELECT_LAT",format='(f7.2)',value=slat,$
    title=title)
endif else begin ; geographic
  title = 'Select '+fields[0].grid_type+' Latitude'
  wfsl_slat = cw_fslide(slatbase,minimum=lats[0],maximum=lats[nlat-1],$
    delta=dlat,xsize=230,uvalue="SELECT_LAT",format='(f7.2)',value=slat,$
    title=title)
endelse
;
*info.plat_ids = lat_ids
draw_xsize = 500 & draw_ysize = 500
draw = widget_draw(tlb,xsize=draw_xsize,ysize=draw_ysize,uvalue='DRAW_LATS')
button = widget_button(tlb,value='Close',uvalue='CLOSE')
;
lons = *fields[0].lons
lonmin = lons[0] & lonmax = lons[n_elements(lons)-1]
levs = *fields[0].levs
levmin = levs[0]
nlev = fields[0].nlev
levmax = levs[nlev-1]
;
; -------------------------- Lat slice structure ---------------------
;
lat = {latstruct,                 $
  field:fields[0],                $ ; current field structure
  ifield:0,		          $ ; index to current field	
  slat:slat,                      $ ; selected latitude
  mtime:mtime,                    $ ; model time (default first time on file)
  imtime:imtime,                  $ ; index to mtime (file.mtimes[imtime]) 
  ut:ut,                          $ ; ut (hrs)
  missing_value:missing_value,    $ ; missing data value
  latbase:latbase,                $ ; widget id of cw lev slider base
  rhyaxis:1,                      $ ; if > 0 then add extra right-hand y-axis
  wfsl_lat:wfsl_slat,             $ ; widget id of lat selection slider
  log10:'density fields',         $ ; plot log10 (densities, current field, on none)
  draw:draw,                      $ ; draw widget id
  draw_xsize:draw_xsize,          $ ; x size of draw widget
  draw_ysize:draw_ysize,          $ ; y size of draw widget
  minmaxmenu:minmaxmenu,          $ ; menu widget for setting image min,max
  contourmenu:contourmenu,        $ ; menu widget for custom contour
  ftype:info.ftype,               $ ; Type of input file (TIME-GCM or WACCM presently)
  plottype:'image+contours',      $ ; 4 options (see plottype_menu)
  clineclr:!d.table_size-1,       $ ; contour line color
  plotz:0,                        $ ; plot altitude as vertical axis(profiles) if = 1
  minmaxlab:1,                    $ ; Minimum/maximum data range bottom label on if = 1
  filelab:1,                      $ ; File bottom label on if = 1
  setcontour:'off',               $ ; knows if the contour levels have been set
  fmin:0.,fmax:0.,cint:0.,        $ ; contour min,max,interval
  clevels:ptr_new(/allocate_heap),$ ; contour levels
  lons:ptr_new(/allocate_heap),   $ ; longitudes for x axis
  lonmin:lonmin,lonmax:lonmax,    $ ; optional latitude range for x-axis
  levs:ptr_new(/allocate_heap),   $ ; vertical levels for y axis
  levszp:ptr_new(/allocate_heap), $ ; vertical levels in zp for y axis
  levmin:levmin,levmax:levmax,    $ ; min,max of lev y-axis
  levminz:0.,levmaxz:0.,          $ ; min,max of lev y-axis altitude
  data:ptr_new(/allocate_heap),   $ ; 2d data (lats,levs)
  datazp:ptr_new(/allocate_heap)  $ ; 2d data (lats,levs) on zp vertical grid
}
;
; Read data from first field:
;
if ptr_valid(fields[0].data) then begin ; field has been read
  deflatdata,lat,*fields[0].data
endif else begin
  widget_control,/hourglass
  varget,info,fields[0],ncdata
  field = fields[0]
  procfield,info,ncdata,field,info.z_hist
  fields[0] = field
  lat.field = field
  lat.levmin = (*field.levs)[0] & lat.levmax = (*field.levs)[field.nlev-1]
  deflatdata,lat,*fields[0].data
  lat.field = field
  lat.levs = lat.field.levs
endelse
;
; Set min,max for first field:
;
fminmax,*lat.data,fmin,fmax,lat.missing_value
rpt_minmax,info,fields[0],fmin,fmax
widget_control,lat.minmaxmenu,sensitive=0 ; because default plottype is image+contour
;
; Set contour levels:
;
cmin=0. & cmax=0. & cint=0.
levels = mkclevels(fmin,fmax,cmin,cmax,cint)
lat.fmin=cmin & lat.fmax=cmax & lat.cint=cint
*lat.clevels = levels
;
; Update state info, realize the widgets, plot the slice:
;
*info.fields = fields
info.plat = ptr_new(lat)
widget_control,tlb,/realize
pinfo = ptr_new(info)
pltlat,info
widget_control,tlb,set_uvalue=pinfo
xmanager,'lats',tlb,/no_block
end
