;-----------------------------------------------------------------------
PRO meridsliders,line

  field = line.field
  sliderbase = line.sliderbase

  widget_control,line.wfsl_lon,/destroy,bad_id=badid
  widget_control,line.wfsl_lev,/destroy,bad_id=badid
  widget_control,line.wfsl_slt,/destroy,bad_id=badid
  widget_control,line.wfsl_wvn,/destroy,bad_id=badid

;
; ------------------ Sliders for selected lons, levs -------------------
;
; Select longitude:
;
  lons = *field.lons
  nlon = n_elements(lons)
  dlon = lons[1]-lons[0]
  slon = line.slon
  slonbase = widget_base(sliderbase)
  title='Select '+field.grid_type+' Longitude'
  wfsl_slon = cw_fslide(slonbase,minimum=lons[0],maximum=lons[nlon-1],$
    delta=dlon,xsize=230,uvalue="SELECT_LON",format='(f7.2)',value=slon,$
    title=title)

  IF line.zonalmean EQ 1 OR line.amplitude EQ 1 THEN widget_control, wfsl_slon, sensitive=0

  line.wfsl_lon = wfsl_slon
;
; Select level:
;
  levs = *line.levs
  nlev = n_elements(levs)
  dlev = levs[1]-levs[0]
  slev = line.slev
  slevbase = widget_base(sliderbase)
  title='Select Vertical Level'
  wfsl_slev = cw_fslide(slevbase,minimum=levs[0],maximum=levs[nlev-1],$
    delta=dlev,xsize=230,uvalue="SELECT_LEV",format='(f7.2)',value=slev,$
    title=title)
  line.wfsl_lev = wfsl_slev
;
; Select local time:
;
  sltbase = widget_base(sliderbase)
  sslt = line.sslt
  dslt = dlon/15.
  title='Select '+field.grid_type+' Local Time'
  wfsl_slt = cw_fslide(sltbase,minimum=0.,maximum=24.,$
    delta=dslt,xsize=230,uvalue="SELECT_SLT",format='(f5.2)',value=sslt,$
    title=title)

  IF line.zonalmean EQ 1 OR line.amplitude EQ 1 THEN widget_control, wfsl_slt, sensitive=0

  line.wfsl_slt = wfsl_slt
;
; Select wavenumber:
;
  swvnbase = widget_base(sliderbase)
  swvn = line.wavenumber
  dwvn = 1
  title='Select Amplitude Wavenumber'
  wfsl_wvn = cw_fslide(swvnbase,minimum=0,maximum=nlon/2,$
    delta=dwvn,xsize=230,uvalue="SELECT_WVN",format='(i2)',value=swvn,$
    title=title)

  IF line.amplitude EQ 0 THEN widget_control, wfsl_wvn, sensitive=0

  line.wfsl_wvn = wfsl_wvn

END
