;
function make_mtime_string,mtime
return,$
  strcompress(string(mtime[0]),/remove_all)+','+ $
  strcompress(string(mtime[1]),/remove_all)+','+ $
  strcompress(string(mtime[2]),/remove_all)
end
;-----------------------------------------------------------------------
function mtime_utmenu,parent,mtimes,utmin,utmax,interval,event_pro,mk_insensitive=mk_insensitive
;
; Construct an mtimes menu, returning widget id.
;
;print,'Enter mtime_utmenu: interval=',interval
dims = size(mtimes,/dimensions)
ndims = n_elements(dims)
if dims[0] ne 3 then begin
  print,'>>> construct_mtime_menu: first dim of mtimes should be 3,',$
    ' but is ',dims[0]
  return,-1
endif
if ndims eq 2 then begin
  if dims[1] le 0 then begin
    print,'>>> construct_mtime_menu: no times? ntimes=',ntimes
    return,-1
  endif
endif
if ndims eq 1 then begin
  ntimes = 1
endif else begin
  ntimes = dims[1]
endelse
sizetime=size(mtimes)
sizetime=sizetime[2]
for i=0, sizetime-1 do begin
  if mtimes[0,i] eq utmin[0] and mtimes[1,i] eq utmin[1] and $
    mtimes[2,i] eq utmin[2] and i ne 0 then begin
     mk_insensitive=1 
  endif
  if mtimes[0,i] eq utmax[0] and mtimes[1,i] eq utmax[1] and $
    mtimes[2,i] eq utmax[2] and i ne sizetime-1 then begin
     mk_insensitive=1
  endif
endfor
;
; xmin mtime menu
;
data_str=strcompress(string(utmin[0]))+','+strcompress(string(utmin[1]))+','+$
  strcompress(string(utmin[2]))
minLabel='Beginning time: ' + data_str
mxitems = 25
if ntimes le mxitems then begin
  mtimesmenu = widget_button(parent,value=minLabel,/menu)
  for i=0,ntimes-1 do begin
    mtime_string = make_mtime_string(mtimes[*,i])
    button = widget_button(mtimesmenu,value=mtime_string,uvalue='UTBEG',$
      event_pro=event_pro)
  endfor
endif else begin ; > mxitems times
  mtimesmenu = widget_button(parent,value=minLabel,/menu)
  nmenus = ntimes / mxitems
  menubases = intarr(nmenus)
;  print,'construct_mtime_menu: ntimes=',ntimes,' nmenus=',nmenus
  imtime = 0
  for m=0,nmenus-1 do begin
    mtime_string0 = make_mtime_string(mtimes[*,imtime])
    mtime_string1 = make_mtime_string(mtimes[*,imtime+mxitems-1])
    title = mtime_string0+'to'+mtime_string1
    menubases[m] = widget_button(mtimesmenu,value=title,/menu)
    for i=0,mxitems-1 do begin
      mtime_string = make_mtime_string(mtimes[*,imtime])
      button = widget_button(menubases[m],value=mtime_string,$
        uvalue='UTBEG',event_pro=event_pro)
      imtime = imtime+1
    endfor
  endfor ; m=0,nmenus-1
  ntimes_last = ntimes mod mxitems
  if ntimes_last gt 0 then begin
    mtime_string0 = make_mtime_string(mtimes[*,imtime])
    mtime_string1 = make_mtime_string(mtimes[*,imtime+ntimes_last-1])
    title = mtime_string0+'to'+mtime_string1
    menubase = widget_button(mtimesmenu,value=title,/menu)
    for m=0,ntimes_last-1 do begin
      mtime_string = make_mtime_string(mtimes[*,imtime])
      button = widget_button(menubase,value=mtime_string,$
        uvalue='UTBEG',event_pro=event_pro)
      imtime = imtime+1
    endfor
  endif
endelse
; 5/9/08
;if interval ne 1 then widget_control,mtimesmenu,sensitive=0
;
; xmax mtime menu
;
data_str=strcompress(string(utmax[0]))+','+strcompress(string(utmax[1]))+','+$
  strcompress(string(utmax[2]))
maxLabel='Ending time: ' + data_str
mxitems = 25
if ntimes le mxitems then begin
  mtimesmenu = widget_button(parent,value=maxLabel,/menu)
  for i=0,ntimes-1 do begin
    mtime_string = make_mtime_string(mtimes[*,i])
    button = widget_button(mtimesmenu,value=mtime_string,uvalue='UTEND',$
      event_pro=event_pro)
  endfor
endif else begin ; > mxitems times
  mtimesmenu = widget_button(parent,value=maxLabel,/menu)
  nmenus = ntimes / mxitems
  menubases = intarr(nmenus)
; print,'construct_mtime_menu: ntimes=',ntimes,' nmenus=',nmenus
  imtime = 0
  for m=0,nmenus-1 do begin
    mtime_string0 = make_mtime_string(mtimes[*,imtime])
    mtime_string1 = make_mtime_string(mtimes[*,imtime+mxitems-1])
    title = mtime_string0+'to'+mtime_string1
    menubases[m] = widget_button(mtimesmenu,value=title,/menu)
    for i=0,mxitems-1 do begin
      mtime_string = make_mtime_string(mtimes[*,imtime])
      button = widget_button(menubases[m],value=mtime_string,$
        uvalue='UTEND',event_pro=event_pro)
      imtime = imtime+1
    endfor
  endfor ; m=0,nmenus-1
  ntimes_last = ntimes mod mxitems
  if ntimes_last gt 0 then begin
    mtime_string0 = make_mtime_string(mtimes[*,imtime])
    mtime_string1 = make_mtime_string(mtimes[*,imtime+ntimes_last-1])
    title = mtime_string0+'to'+mtime_string1
    menubase = widget_button(mtimesmenu,value=title,/menu)
    for m=0,ntimes_last-1 do begin
      mtime_string = make_mtime_string(mtimes[*,imtime])
      button = widget_button(menubase,value=mtime_string,$
        uvalue='UTEND',event_pro=event_pro)
      imtime = imtime+1
    endfor
  endif
endelse
; 5/9/08
;if interval ne 1 then widget_control,mtimesmenu,sensitive=0
; 
; mtime interval
;
for i=0,ntimes-1 do begin
  if mtimes[0,i] eq utmin[0] and mtimes[1,i] eq utmin[1] and $
    mtimes[2,i] eq utmin[2] then begin
    imtime_min=i
  endif
  if mtimes[0,i] eq utmax[0] and mtimes[1,i] eq utmax[1] and $
    mtimes[2,i] eq utmax[2] then begin
    imtime_max=i
  endif
endfor
imax=imtime_max
imin=imtime_min
if mtimes[0,0] ne mtimes[0,1] and mtimes[1,1] eq mtimes[1,0] $
  and mtimes[2,0] eq mtimes[2,1] then begin
  type='day' 
  histunit=0
endif
if mtimes[1,1] ne mtimes[1,0] $
  and mtimes[2,0] eq mtimes[2,1] then begin
  type='hr' 
  histunit=1
endif
if mtimes[2,0] ne mtimes[2,1] then begin
  type='min' 
  histunit=2
endif

if type eq 'hr' then begin
 min_interval=mtimes[1,1]-mtimes[1,0] 
endif else if type eq 'min' then begin
  min_interval=mtimes[2,1]-mtimes[2,0] 
endif else begin
  min_interval=mtimes[0,1]-mtimes[0,0]
endelse  

;print,'type=',type,' mtimes[*,1]=',mtimes[*,1],' mtimes[*,0]=',mtimes[*,0],$
;  ' min_interval=',min_interval

if min_interval eq 0 then begin
; print,'min_interval==0: setting min_interval 1'
  min_interval=1
endif

if ntimes ge 48 and type eq 'hr' then begin
  choicemax=23
endif else begin
  choicemax=sizetime/2-1
endelse 

;print,'mtime_utmenu: interval=',interval,' min_interval=',min_interval

 data_str=strcompress(string(interval))+' '+type

;data_str=strcompress(string(interval-1))+' '+type
intrvLabel='Time interval: ' + data_str

  mtimesmenu = widget_button(parent,value=intrvLabel,/menu)
  for i=0,choicemax do begin
    mtime_string=strcompress(string(min_interval*i))+' '+type

    if (i eq 0) then mtime_string=strcompress(string(min_interval*i+1))+' '+type
;   print,'mtime_utmenu: i=',i,' mtime_string=',mtime_string

    if (i gt 0) then $
    button = widget_button(mtimesmenu,value=mtime_string,uvalue='UTINT',$
      event_pro=event_pro)
  endfor
  minutes=mtimes[0,ntimes-1]*60*24+mtimes[1,ntimes-1]*60+mtimes[2,ntimes-1]- $
    (mtimes[0,0]*60*24+mtimes[1,0]*60+mtimes[2,0])

;print,format="('mtime_utmenu: interval=',i4,' type=',a,' min_interval=',i4,' minutes=',i4,' imin,imax=',2i5,' ntimes=',i4)",$
; interval,type,min_interval,minutes,imin,imax,ntimes
;
; 5/9/08 btf: comment this out to allow time interval to be set
;             when delta time is in minutes
;
; if type eq 'min' and minutes gt 120. then begin
;   widget_control,mtimesmenu,sensitive=0
; endif
;
; if imax ne ntimes-1 then begin
;   widget_control,mtimesmenu,sensitive=0
; endif
; if imin ne 0 then begin
;   widget_control,mtimesmenu,sensitive=0
; endif
; 
; mtime interval

if arg_present(mk_insensitive) then begin
  print,'mk_insensitive is present..'
  widget_control,mtimesmenu,sensitive=0
endif
end
