;
pro pltlat,info,animate=animate,ps=ps,png=png
;
; Plot latitude slice (y:x = zp:lon):
;

file = *info.pfile
lat = *info.plat
field = lat.field
fields = *info.fields
flons = *fields[lat.ifield].lons
nflons = n_elements(flons)
data = *lat.data
lons = *lat.lons & nlon = n_elements(lons)
levs = *lat.levs 
nlev = n_elements(levs)

rhyaxis = lat.rhyaxis
if rhyaxis gt 0 and (file.diffs gt 0 or field.grid_type eq 'magnetic') then $
  rhyaxis = 0
lonrangeset = 0
if lat.lonmin gt flons[0] or lat.lonmax lt flons[nflons-1] then $
  lonrangeset = 1
find_nans,info,field.name,data,numnans
if numnans gt 0 then print,'>>NaNs found:',numnans
if numnans gt 0 then begin
  rhyaxis = 0   
  lat.rhyaxis = 0
endif

if not keyword_set(animate) and not keyword_set(ps) and $
   not keyword_set(png) then begin
  widget_control,lat.draw,get_value=index
  wset,index
  erase
endif
;
; Check for all missing value:
;
nmissing = 1 ; do not init this to 0 because check_missing uses "if keyword_set"
missing_value = float(lat.missing_value)
text = 1 & if keyword_set(animate) then text = 0
nodata = check_missing(data,missing_value,field.name,text=text,$
  nmissing=nmissing)
if nodata eq 1 then return
if nmissing gt 0 then print,'Lat slices: Field ',field.name,': Found ',$
  nmissing,' missing data points (out of ',n_elements(data),')'
;
; Min,max:
;
fminmax,data,framemin,framemax,missing_value
if lat.fmin ge lat.fmax then begin
  fminmax,data,fmin,fmax,missing_value
  if lat.fmin eq lat.fmax then begin
    lat.fmin=fmin & lat.fmax=fmax
    print,'pltlat reset lat.fmin,max=',lat.fmin,lat.fmax
  endif else $
    print,'pltlat did NOT reset min,max: lat.fmin,max=',lat.fmin,lat.fmax
endif else begin
  fmin = lat.fmin & fmax = lat.fmax
endelse

if lat.setcontour eq 'off' and lat.plotz eq 0 then begin
  cmin=0. & cmax=0. & cint=0.
; print,'Lats: reset contour min,max to full range.'
  deflatdata,lat,*fields[lat.ifield].data
;
;  Set local levels and number of levels variable since changed in deflatdata for WACCM
;
  IF info.ftype EQ 'WACCM' THEN BEGIN

    levs = *lat.levs 
    nlev = n_elements(levs)

  ENDIF
  
  levels = mkclevels(fmin,fmax,cmin,cmax,cint)
  lat.fmin=cmin & lat.fmax=cmax & lat.cint=cint
  *lat.clevels = levels
  *info.plat = lat
  data = *lat.data
endif  
;
; Image position:
;
xur = .90 & yur = .90
xll = .15 & yll = .31
axespos  = [xll,yll,xur,yur]
imagepos = [xll,yll,xur,yur]
xmid = .5*(xur+xll)
;
; Byte-scale to an image. Make any missing data black:
;
if (lat.plottype eq 'image_only') or (lat.plottype eq 'image+contours') then begin
  missing_indices = where(data eq missing_value,nmissing)
  if nmissing gt 0 then begin
;   print,'Field ',field.name,' lat slice: Found ',nmissing,' missing data points.'
    image = bytscl(data,min=fmin,max=fmax,top=!d.table_size-3)+1
    image(missing_indices) = 0
  endif else begin
    image = bytscl(data,min=fmin,max=fmax,top=!d.table_size-3)+1
  endelse
  if keyword_set(ps) eq 0 then begin
    xyll = convert_coord([xll],[yll],/norm,/to_device)
    xll_dev = xyll(0,0) & yll_dev = xyll(1,0)
    xyur = convert_coord([xur],[yur],/norm,/to_device)
    xur_dev = xyur(0,0) & yur_dev = xyur(1,0)
    image=congrid(image,xur_dev-xll_dev+1,yur_dev-yll_dev+1,/interp,$
      /minus_one)
    xsize=0. & ysize=0.
  endif else begin ; ps
    imscale = 8
    print,'pltlat call congrid for ps..'
    image=congrid(image,nlon*imscale,nlev*imscale,/interp,/minus_one)
    xsize=(xur)-(xll) & ysize=yur-yll
  endelse
endif ; making an image
;
; Set up for color bar:
;
if lat.plottype ne 'monochrome_contours' then begin
  barw = xur-xll-.05*(xur-xll) & barh = .03
  xbar = xmid-.5*barw
  ybar = yll-barh-.11
  baroff = .035
  cblabels = [strcompress(string(fmin,format="(g9.3)"),/remove_all),$
    strcompress(string(0.5*(fmin+fmax),format="(g9.3)"),/remove_all),$
    strcompress(string(fmax,format="(g9.3)"),/remove_all)]
endif
;
; Titles, labels, tic marks, etc:
;
if field.grid_type eq 'geographic' then begin
  xtitle = 'LONGITUDE (DEGREES GEOGRAPHIC)'
endif else begin
  xtitle = 'LONGITUDE (DEGREES MAGNETIC)'
endelse
;ytitle = 'ZP (LN(P0/P))'
ytitle = field.levname + ' (' + field.levunits + ')' ; zp or height
;
;  WACCM vertical coordinate converted to log pressure so change label
;
if info.ftype eq 'WACCM' THEN ytitle = 'ZP log pressure level ' + '(ln(p0/p))' 
;
;  Set y-axis title if geopotential or geometric altitude
;
IF lat.plotz EQ 1 THEN ytitle = ' GEOPOTENTIAL HEIGHT (km) '
IF lat.plotz EQ 2 THEN ytitle = ' GEOMETRIC HEIGHT (km) '
 
xticlabs = ['-180','-120','-60','0','60','120','180']
;
; Field label:
;
if (lat.log10 eq 'density fields' and isdensity(field.name) gt 0) or $
   (lat.log10 eq 'this frame only') or $
   (lat.log10 eq 'all fields') then begin
  if strlen(field.long_name) gt 0 then fieldlab = 'LOG10 '+field.long_name $
    else fieldlab = 'LOG10 '+field.name
endif else begin
  if strlen(field.long_name) gt 0 then fieldlab = field.long_name $
    else fieldlab = field.name
endelse
if file.diffs le 0 then begin 
  if strlen(field.units) gt 0 then $
    fieldlab = fieldlab + ' (' + strcompress(field.units,/remove_all) + ')'
endif else fieldlab = fieldlab + ' (' + field.difftype + ' ' + $
  strcompress(field.units,/remove_all) + ')'
;
uthrs = float(lat.mtime[1])+float(lat.mtime[2])/60.
toplab = string(format="('DAY = ',i3,' UT = ',f5.2)",lat.mtime[0],uthrs)
if field.grid_type eq 'geographic' then begin
  toplab = toplab + string(format="('  LAT = ',f7.2)",lat.slat)
endif else begin
  toplab = toplab + string(format="('  MLAT = ',f7.2)",lat.slat)
endelse
;
; Bottom label:
;
botlab1 = strcompress(field.ncfile,/remove_all)
;
; Min,max label:
;
minmaxlab = 'MIN,MAX = '+string(format="(g10.4)",framemin)+','+$
                         string(format="(g10.4)",framemax)
if lat.plottype ne 'image_only' then $
  minmaxlab = minmaxlab + string(format="(' INTERVAL = ',g10.4)",lat.cint)
;
; Contour levels were made by mkclevels.pro.
;
clevels = *lat.clevels
nlevels = n_elements(clevels)
clinestyle = intarr(nlevels)
clinestyle[*] = 0 ; solid
for i=0,nlevels-1 do if clevels[i] lt 0. then clinestyle[i] = 2 ; dashed
c_charsize = 1.1
chsize = 1.2
;
; Contour will not draw y-axis if extra non-linear right-hand axis is 
; to be drawn by pro altyax:
;
yaxstyle = 1 & if rhyaxis gt 0 then yaxstyle = 9
;
; Display image and/or contour:
;
case lat.plottype of
;
; Display image only. Use contour,/nodata to draw axes, ticmarks, labels:
;
  'image_only': begin
    tv,image,xll,yll,/norm,xsize=xsize,ysize=ysize                   ; ras image
    clrbar,barw,barh,xbar,ybar,cblabels,botcolor=1,topcolor=!d.table_size-2,$
      charsize=chsize,laboffset=baroff
    if lonrangeset then $
      contour,data,lons,levs,/noerase,/nodata,position=axespos,$       ; axes
        xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=yaxstyle,ticklen=-.015,$
        charsize=chsize $
    else $
      contour,data,lons,levs,/noerase,/nodata,position=axespos,$       ; axes
        xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=yaxstyle,ticklen=-.015,$
        xticks=n_elements(xticlabs)-1,xminor=3,xtickname=xticlabs,charsize=chsize
	
    xyouts,xmid,yur+.06,fieldlab ,/norm,align=0.5,charsize=chsize
    xyouts,xmid,yur+.025,toplab  ,/norm,align=0.5,charsize=chsize
    if lat.minmaxlab eq 1 then xyouts,xmid,yll-.21,minmaxlab,/norm,align=0.5,charsize=chsize
    if lat.filelab eq 1 then xyouts,xmid,yll-.24,botlab1  ,/norm,align=0.5,charsize=chsize
  end
;
; Display image with contour overlay:
;
  'image+contours': begin
    tv,image,xll,yll,/norm,xsize=xsize,ysize=ysize 
    contour,data,lons,levs,/noerase,position=imagepos,$              ; contour
      /follow,xstyle=5,ystyle=5,c_charsize=c_charsize,$
      levels=clevels,c_linestyle=clinestyle,max_value=missing_value,$
      c_colors=[lat.clineclr]
    if lonrangeset then $
      contour,data,lons,levs,/noerase,/nodata,position=axespos,$       ; axes
        xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=yaxstyle,ticklen=-.015,$
        charsize=chsize $
    else $
      contour,data,lons,levs,/noerase,/nodata,position=axespos,$       ; axes
        xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=yaxstyle,ticklen=-.015,$
        xticks=n_elements(xticlabs)-1,xminor=3,xtickname=xticlabs,charsize=chsize
	
    clrbar,barw,barh,xbar,ybar,cblabels,botcolor=1,topcolor=!d.table_size-2,$
      charsize=chsize,laboffset=baroff
    xyouts,xmid,yur+.06,fieldlab ,/norm,align=0.5,charsize=chsize
    xyouts,xmid,yur+.025,toplab  ,/norm,align=0.5,charsize=chsize
    if lat.minmaxlab eq 1 then xyouts,xmid,yll-.21,minmaxlab,/norm,align=0.5,charsize=chsize
    if lat.filelab eq 1 then xyouts,xmid,yll-.25,botlab1  ,/norm,align=0.5,charsize=chsize
  end
;
; Contour only (B&W):
;
  'monochrome_contours': begin
    if lonrangeset then $
      contour,data,lons,levs,/noerase,/nodata,position=axespos,$       ; axes
        xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=yaxstyle,ticklen=-.015,$
        charsize=chsize $
    else $
      contour,data,lons,levs,/noerase,/nodata,position=axespos,$       ; axes
        xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=yaxstyle,ticklen=-.015,$
        xticks=n_elements(xticlabs)-1,xminor=3,xtickname=xticlabs,charsize=chsize
	
    contour,data,lons,levs,/noerase,position=imagepos,$              ; contour
      /follow,xstyle=5,ystyle=5,c_charsize=c_charsize,$
      levels=clevels,c_linestyle=clinestyle,max_value=missing_value,$
      c_colors=[lat.clineclr]
    xyouts,xmid,yur+.06,fieldlab ,/norm,align=0.5,charsize=chsize
    xyouts,xmid,yur+.025,toplab,/norm,align=0.5,charsize=chsize
    if lat.minmaxlab eq 1 then xyouts,xmid,yll-.13,minmaxlab,/norm,align=0.5,charsize=chsize
    if lat.filelab eq 1 then xyouts,xmid,yll-.18,botlab1,/norm,align=0.5,charsize=chsize
  end
;
; Color fill contour:
;
  'colorfill_contours': begin
    if lonrangeset then $
      contour,data,lons,levs,/noerase,/nodata,position=axespos,$        ; axes
        xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=yaxstyle,ticklen=-.015,$
        charsize=chsize $
    else $
      contour,data,lons,levs,/noerase,/nodata,position=axespos,$        ; axes
        xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=yaxstyle,ticklen=-.015,$
        xticks=n_elements(xticlabs)-1,xminor=3,xtickname=xticlabs,charsize=chsize
	
    contour,data,lons,levs,/noerase,position=imagepos,$               ; colorfill
      /follow,/fill,xstyle=5,ystyle=5,levels=clevels
      
    contour,data,lons,levs,/noerase,position=imagepos,$               ; contours
      /follow,xstyle=5,ystyle=5,c_charsize=c_charsize,$
      levels=clevels,c_linestyle=clinestyle,max_value=missing_value,$
      c_colors=[lat.clineclr]
      
    clrbar,barw,barh,xbar,ybar,cblabels,botcolor=1,topcolor=!d.table_size-2,$
      charsize=chsize,laboffset=baroff
    xyouts,xmid,yur+.06,fieldlab ,/norm,align=0.5,charsize=chsize
    xyouts,xmid,yur+.025,toplab  ,/norm,align=0.5,charsize=chsize
    if lat.minmaxlab eq 1 then xyouts,xmid,yll-.21,minmaxlab,/norm,align=0.5,charsize=chsize
    if lat.filelab eq 1 then xyouts,xmid,yll-.25,botlab1  ,/norm,align=0.5,charsize=chsize
  end
  else: print,'>>> pltlat: unknown plot type ',lat.plottype
endcase ; plot type
;
;  Plot right hand axis is requested, altitude for vertical zp plots and zp for vertical altitude plots
;
if rhyaxis gt 0 and lat.plotz GE 1 then presyax,info,lat,'lat',xll,xur,yll,yur,chsize
if rhyaxis gt 0 and lat.plotz eq 0 then begin
  altyax,info,lat,'lat',xll,xur,yll,yur,chsize 
endif
;
; lat.fmin,max may have been changed, so update state:
;
*info.plat = lat
end

