;------------------------------------------------------------------------
pro pltsv,info,animate=animate,ps=ps
;written by Tom Freestone 6/9/03 to create satellite view of info
;This procedure is a modified versiion of pltce.pro that was previously
;written by Ben Foster
;
file = *info.pfile
map = *info.pmap
vector=map.vector
fields = *info.fields
field = map.field
data = *map.data
lons = *map.lons & nlon = n_elements(lons)
lats = *map.lats & nlat = n_elements(lats)
;
; Add periodic points (add a longitude):
;
   newdata = fltarr(nlon+1,nlat)
   newdata[0:nlon-1,*] = data[*,*]
   newdata[nlon,*] = data[0,*]
   data = newdata
   lons = fltarr(nlon+1)
   lons[0:nlon-1] = *map.lons
   lons[nlon] = 180.
   nlon = nlon+1
;
; Check for all missing value:
;
nmissing = 1
text = 1 & if keyword_set(animate) then text = 0
nodata = check_missing(data,float(map.missing_value),field.name,text=text,$
  nmissing=nmissing)
if nodata eq 1 then return
missing_value = float(map.missing_value)
if nmissing gt 0 then print,'Global Maps: Field ',field.name,': Found ',$
  nmissing,' missing data points (out of ',n_elements(data),')'
;
; Set map position (normalized coords):
wxsize = !d.x_size & wysize = !d.y_size
dia = 0.70 * wysize
xcen = 0.42 * (wxsize) & ycen = 0.53*wysize
xll_dev = xcen-0.5*dia & yll_dev = ycen-0.5*dia
norm = convert_coord([xll_dev, yll_dev],/device,/to_norm)
xll = norm(0) & yll = norm(1)
xur_dev = xcen+0.5*dia & yur_dev = ycen+0.5*dia
norm = convert_coord([xur_dev,yur_dev],/device,/to_norm)
xur=norm(0) & yur=norm(1)
mappos=[xll,yll,xur,yur]
xmid=.5*(xll+xur)
dlat = lats[1]-lats[0]
;
; Geographic field lats start at +/- 87.5, whereas magnetic fields go to +/- 90.
;
if (lats[0]-dlat/2. eq -90.) and (lats[nlat-1]+dlat/2. eq +90.) then begin
  poledeg = (dlat/2.)/180.*(yur-yll) ; distance between top lat and pole
  conpos = [xll,yll+poledeg,xur,yur-poledeg]
 conpos = [xll,yll+poledeg,xur,yur-poledeg*2.5]
endif else begin
  conpos = [xll,yll,xur,yur]
endelse
xmid = .5*(xll+xur)
;
; Set up map projection:
;
longitude=0
latitude=0
;center position for the latitude,longitude,and slt 
plat=map.cenlat & plon=map.cenlon & rot=0.0
censlt=map.censlt

;print,'pltsv: censlt=',censlt

;when slt radio button is clicked change the position
if(map.fixpolar eq 'SLT') then begin
  uthrs = float(map.mtime[1])+float(map.mtime[2])/60
  plon=fslt(censlt,uthrs,plon,'getlon')
; rot=censlt*15
endif
;sat_p is the parameters for the distance from the earth and the different angles
map_set, plat,plon,rot,/satellite, sat_p=[map.erad, longitude, latitude],$
	position=mappos,/noborder  
;
; Titles, labels, tic marks, etc:
;
fminmax,data,framemin,framemax,missing_value
if map.fmin ge map.fmax then begin
  fminmax,data,fmin,fmax,missing_value
  if map.fmin eq map.fmax then begin
    map.fmin=fmin & map.fmax=fmax
    if not keyword_set(animate) then $
      print,'Global SV maps reset map.fmin,max=',map.fmin,map.fmax
  endif else $
    if not keyword_set(animate) then $
      print,'Global SV maps did NOT reset min,max: map.fmin,max=',$
        map.fmin,map.fmax
endif else begin
  fmin = map.fmin & fmax = map.fmax
  if not keyword_set(animate) then $
    print,'Global SV maps using preset map.fmin,max=',map.fmin,map.fmax
endelse

;
; Byte-scale to an image. Make any missing data black:
;
if (map.plottype eq 'image_only') or (map.plottype eq 'image+contours') then begin
  missing_indices = where(data eq map.missing_value,nmissing)
  if nmissing gt 0 then begin
    print,'Field ',field.name,' SV map: Found ',nmissing,' missing data points.'
    ave = total(data(where(data ne map.missing_value)))/n_elements(data)
    data(missing_indices) = ave
    image = bytscl(data,top=!d.table_size-3,min=fmin,max=fmax)+1
    image(missing_indices) = 0
  endif else $
    image = bytscl(data,top=!d.table_size-3,min=fmin,max=fmax)+1

;
; Scale image up and warp image to map projection:
;
; As of 3/27/03: congrid + map_image results in offset contours and image
;   (contours do not match colors in the image, esp high north latitudes).
;   (This is apprently because of interpolating twice before contour)
;   Map_patch eliminates this problem, but results in a vertical dashed
;   black line at longitude=0. This is apparently due to a bug in map_patch.
;   A work-around is to reduce nlon by one with congrid before map_patch.
;   I will use this until the bugfix for map_patch is available. For
;   correspondence with RSI, see ~foster/tgcmproc/consult/image+contour.
; It is also necessary to use map_patch for irregular latitude grid with
;   fields on mag grid.
;
; imscale = 8
; image = congrid(image,nlon*imscale,nlat*imscale,/interp)
; image = map_image(image,startx,starty,xsize,ysize,$
;   latmin=lats[0],latmax=lats[nlat-1],$
;   lonmin=lons[0],lonmax=lons[nlon-1],compress=1)

; image = map_patch(image,lons,lats,xstart=startx,ystart=starty,$
;   xsize=xsize,ysize=ysize) ; dashed black line bug

  image_patch = congrid(image,nlon,nlat) ; bug fix hack
  image = map_patch(image_patch,dummy,lats,$
    xstart=startx,ystart=starty,xsize=xsize,ysize=ysize)
;
; Set up color bar (pro clrbar):
;
  barw = .04 & barh = yur-yll 
  xbar = xur+.05 & ybar = yll
  barlabs = [strcompress(string(fmin,format="(e8.1)"),/remove_all),$
    strcompress(string(0.5*(fmin+fmax),format="(e8.1)"),/remove_all),$
    strcompress(string(fmax,format="(e8.1)"),/remove_all)]
    chsize_clrbar = 1.2
    laboff_clrbar = .015
endif ; plottype is image_only or image+contours
;
; Field label:
;
if vector.control ne 'only' then begin
  if (map.log10 eq 'density fields' and isdensity(field.name) gt 0) or $
     (map.log10 eq 'this frame only') or $
     (map.log10 eq 'all fields') then begin
    if strlen(field.long_name) gt 0 then fieldlab = 'LOG10 '+field.long_name $
      else fieldlab = 'LOG10 '+field.name
  endif else begin
    if strlen(field.long_name) gt 0 then fieldlab = field.long_name $
      else fieldlab = field.name
  endelse
  ;if strlen(field.long_name) gt 0 then fieldlab = field.long_name $
  ;  else fieldlab = field.name
  if file.diffs le 0 then begin
    if strlen(field.units) gt 0 then $
      fieldlab = fieldlab + ' (' + strcompress(field.units,/remove_all) + ')'
  endif else fieldlab = fieldlab + ' (' + field.difftype + ' ' + $
    strcompress(field.units,/remove_all) + ')'
endif else begin
  fieldlab= vector.lonvector + '+' + vector.latvector
endelse
;
; Top label (under field label):
;
uthrs = float(map.mtime[1])+float(map.mtime[2])/60.
toplab = string(format="('DAY = ',i3,'  UT = ',f5.2)",map.mtime[0],uthrs)
if field.nlev gt 0 and map.plotz eq 0 then $
  toplab = toplab + string(format="('  ',a,' = ',f6.2,'  MEAN ALTITUDE = ',i3,' km')",$
    field.levshortname,map.zvert,map.zmean)
;
;  Change vertical level label for geopotential altitude plotting
;
if field.nlev gt 0 and map.plotz eq 1 then $
  toplab = toplab + string(format="('  ',a,' = ',f6.2,a)",$
    'Geopotential Altitude',map.alt,' km')
if field.nlev gt 0 and map.plotz eq 2 then $
  toplab = toplab + string(format="('  ',a,' = ',f6.2,a)",$
    'Geometric Altitude ',map.alt,' km')
if field.nlev gt 0 and map.plotz eq 3 then $
  toplab = toplab + string(format="('  ',a,' = ',f6.2,a)",$
    'Geometric Altitude (ZG)',map.alt,' km')
if field.nlev gt 0 and map.plotz eq 4 then $
  toplab = toplab + string(format="('  ',a,' = ',f6.2,a)",$
    'Geometric Altitude (ZG)',map.alt,' km')
;
; Min,max label:
;
if vector.control ne 'only' then begin
  minmaxlab = 'MIN,MAX = '+string(format="(g10.4)",framemin)+','+$
                         string(format="(g10.4)",framemax)
  if map.plottype ne 'image_only' then $
    minmaxlab = minmaxlab + string(format="(' INTERVAL = ',g10.4)",map.cint)
endif else begin
  lonvecdata=*vector.lonvecdata
  latvecdata=*vector.latvecdata
  winddata=windminmax(lonvecdata,latvecdata,vector.missing_value)
  *vector.vmin=winddata[0]
  *vector.vmax=winddata[1]
  *vector.vint=winddata[2]
  minmaxlab = 'MIN,MAX = '+string(format="(g10.4)",*vector.vmin)+','+$
			      string(format="(g10.4)",*vector.vmax)
  ;minmaxlab = minmaxlab + string(format="(' INTERVAL = ',g10.4)",*vector.vint)
endelse
;
; Bottom label:
;
filelab=strcompress(field.ncfile,/remove_all)
; botlab1 = strcompress(field.ncfile,/remove_all)
botlab1 = strcompress(field.ncfile,/remove_all)+ $
 string(format="(' (',i3,',',i2,',',i2,')')",map.mtime[*])
;
; Contour levels were made by mkclevels.pro.
;
clevels = *map.clevels
nlevels = n_elements(clevels)
clinestyle = intarr(nlevels)
clinestyle[*] = 0 ; solid
for i=0,nlevels-1 do if clevels[i] lt 0. then clinestyle[i] = 2 ; dashed
c_charsize = 1.1
chsize = 1.2
;
; get wind vector data
;
if vector.control ne 'off' then begin
; zonal data
;print, 'Calling get_field_data zdata SAT '
  zdata = get_field_data(info,vector.ilonvec) 
;print, 'Sat un zdata(*,5) ', zdata(*,5)
  *vector.lonvecdata=zdata
  cmin=0. & cmax=0. & cint=0.
  fminmax,zdata,fmin,fmax,map.missing_value
  levels = mkclevels(fmin,fmax,cmin,cmax,cint)
  vector.lonint=cint
    
; meridonal data
;print, 'Calling get_field_data mdata SAT '
  mdata = get_field_data(info,vector.ilatvec) 
;print, 'Sat vn mdata(*,5) ', mdata(*,5)
  *vector.latvecdata=mdata
  cmin=0. & cmax=0. & cint=0.
  fminmax,mdata,fmin,fmax,map.missing_value
  levels = mkclevels(fmin,fmax,cmin,cmax,cint)
  vector.latint=cint
    
  *map.data=data
  map.vector=vector
  *info.pmap = map
endif

;
; Display image and/or contour.
; Use position=mappos when drawing axes and labels, and use
;   position=conpos when drawing contours.
;
; When plotting vectors with gridvec, need to pass the current longitude
; at the top of the plot since this is an adjustable variable in this projection
;
case map.plottype of
;
; Display image only. 
; Use contour,/nodata to draw axes, ticmarks, labels:
;
  'image_only': begin
    if vector.control ne 'only' then begin
      tv,image,startx,starty,xsize=xsize,ysize=ysize
      clrbar,barw,barh,xbar,ybar,barlabs,charsize=chsize_clrbar, botcolor=1, $
        topcolor=!d.table_size-2, laboffset=laboff_clrbar
      if vector.control eq 'on' then begin
        vmagnitude=gridvec(*vector.lonvecdata,*vector.latvecdata,*vector.lonvecs, $
	  *vector.latvecs,map.projection, $
	  spval=map.missing_value,position=mappos, color=vector.carrows,ps=ps, $
          scalemag=vector.vmag,scalelen=vector.vlen,xscale=xmid,yscale=yll-.05, $
	  xarrowlabel=vector.lonvector, yarrowlabel=vector.latvector,toplon=plon)
        if vector.vecanimate eq 'on' then $
          vector.vmag=vmagnitude
      endif
    endif else begin
        vmagnitude=gridvec(*vector.lonvecdata,*vector.latvecdata,*vector.lonvecs, $
	  *vector.latvecs,map.projection, $
	  spval=map.missing_value,position=mappos, color=vector.carrows,ps=ps, $
          scalemag=vector.vmag,scalelen=vector.vlen,xscale=xmid,yscale=yll-.05, $
	  xarrowlabel=vector.lonvector, yarrowlabel=vector.latvector,toplon=plon)
        if vector.vecanimate eq 'on' then $
          vector.vmag=vmagnitude
;   axes:
;      contour,data,lons,lats,/noerase,position=mappos,/nodata,$
;        xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=1,ticklen=-.015,$
;        xticks=n_elements(xticlabs)-1,xminor=3,xtickname=xticlabs,$
;        yticks=n_elements(yticlabs)-1,yminor=3,ytickname=yticlabs
    endelse
;sets up labels on plot
    xyouts,xmid,yur+.06,fieldlab ,/norm,align=0.5,charsize=chsize
    xyouts,xmid,yur+.03,toplab   ,/norm,align=0.5,charsize=chsize
    if map.minmaxlab eq 1 then xyouts,xmid,yll-.21,minmaxlab,/norm,align=0.5,charsize=chsize
    if map.filelab eq 1 then xyouts,xmid,yll-.24,botlab1  ,/norm,align=0.5,charsize=chsize
  end
;
; Display image with contour overlay:
;
  'image+contours': begin
    if vector.control ne 'only' then begin
      tv,image,startx,starty,xsize=xsize,ysize=ysize
      addmapgrid,map,field
;   contours:
      ;contour,data,lons,lats,/overplot,xstyle=5,ystyle=5,$
      contour,data,lons,lats,xstyle=5,ystyle=5, position=mappos, $
        /follow,c_charsize=c_charsize,levels=clevels,c_linestyle=clinestyle,$
        c_colors=[map.clineclr],/noerase, /overplot
      clrbar,barw,barh,xbar,ybar,barlabs, botcolor=1,topcolor=!d.table_size-2,$
  	charsize=chsize_clrbar,laboffset=laboff_clrbar
      if vector.control eq 'on' then begin
        vmagnitude=gridvec(*vector.lonvecdata,*vector.latvecdata,*vector.lonvecs, $
	  *vector.latvecs,map.projection, $
	  spval=map.missing_value,position=mappos, color=vector.carrows,ps=ps, $
          scalemag=vector.vmag,scalelen=vector.vlen,xscale=xmid,yscale=yll-.05, $
	  xarrowlabel=vector.lonvector, yarrowlabel=vector.latvector,toplon=plon)
        if vector.vecanimate eq 'on' then $
          vector.vmag=vmagnitude
      endif
    endif else begin
;   axes:
;      contour,data,lons,lats,/noerase,position=mappos,/nodata,$
;        xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=1,ticklen=-.015,$
;        xticks=n_elements(xticlabs)-1,xminor=3,xtickname=xticlabs,$
;        yticks=n_elements(yticlabs)-1,yminor=3,ytickname=yticlabs
        vmagnitude=gridvec(*vector.lonvecdata,*vector.latvecdata,*vector.lonvecs, $
	  *vector.latvecs,map.projection, $
	  spval=map.missing_value,position=mappos, color=vector.carrows,ps=ps, $
          scalemag=vector.vmag,scalelen=vector.vlen,xscale=xmid,yscale=yll-.05, $
	  xarrowlabel=vector.lonvector, yarrowlabel=vector.latvector,toplon=plon)
        if vector.vecanimate eq 'on' then $
          vector.vmag=vmagnitude
    endelse
    xyouts,xmid,yur+.08,fieldlab ,/norm,align=0.5,charsize=chsize
    xyouts,xmid,yur+.05,toplab,/norm,align=0.5,charsize=chsize
    if map.minmaxlab eq 1 then xyouts,xmid,yll-.12,minmaxlab,/norm,align=0.5,charsize=chsize
    if map.filelab eq 1 then xyouts,xmid,yll-.16,filelab,/norm,align=0.5,charsize=1.0
  end
;
; Contour only (B&W):
;
  'monochrome_contours': begin
    if vector.control ne 'only' then begin
      contour,data,lons,lats,/noerase,position=conpos,xstyle=5,ystyle=5,$
        /follow,c_charsize=c_charsize,levels=clevels,c_linestyle=clinestyle,$
        c_colors=[map.clineclr],/overplot
      if vector.control eq 'on' then begin
        vmagnitude=gridvec(*vector.lonvecdata,*vector.latvecdata,*vector.lonvecs, $
	  *vector.latvecs,map.projection, $
	  spval=map.missing_value,position=mappos, color=vector.carrows,ps=ps, $
          scalemag=vector.vmag,scalelen=vector.vlen,xscale=xmid,yscale=yll-.05, $
	  xarrowlabel=vector.lonvector, yarrowlabel=vector.latvector,toplon=plon)
        if vector.vecanimate eq 'on' then $
          vector.vmag=vmagnitude
      endif
    endif else begin
        vmagnitude=gridvec(*vector.lonvecdata,*vector.latvecdata,*vector.lonvecs, $
	  *vector.latvecs,map.projection, $
	  spval=map.missing_value,position=mappos, color=vector.carrows,ps=ps, $
          scalemag=vector.vmag,scalelen=vector.vlen,xscale=xmid,yscale=yll-.05, $
	  xarrowlabel=vector.lonvector, yarrowlabel=vector.latvector,toplon=plon)
        if vector.vecanimate eq 'on' then $
          vector.vmag=vmagnitude
;   axes:
;      contour,data,lons,lats,/noerase,position=mappos,/nodata,$
;        xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=1,ticklen=-.015,$
;        xticks=n_elements(xticlabs)-1,xminor=3,xtickname=xticlabs,$
;        yticks=n_elements(yticlabs)-1,yminor=3,ytickname=yticlabs
    endelse
    xyouts,xmid,yur+.06,fieldlab ,/norm,align=0.5,charsize=chsize
    xyouts,xmid,yur+.03,toplab,/norm,align=0.5,charsize=chsize
    if map.minmaxlab eq 1 then xyouts,xmid,yll-.11,minmaxlab,/norm,align=0.5,charsize=chsize
    xyouts,xmid,yll-.15,botlab1,/norm,align=0.5,charsize=chsize
  end
;
; Color fill contour:
;
  'colorfill_contours': begin
    if vector.control ne 'only' then begin
      contour,data,lons,lats,/noerase,position=conpos,xstyle=5,ystyle=5,$
        c_charsize=c_charsize,levels=clevels,/follow,/cell_fill,/overplot
      contour,data,lons,lats,/noerase,position=conpos,xstyle=5,ystyle=5,$
        c_charsize=c_charsize,levels=clevels,/follow,c_linestyle=clinestyle,$
        c_colors=[map.clineclr],/overplot
      if vector.control eq 'on' then begin
        vmagnitude=gridvec(*vector.lonvecdata,*vector.latvecdata,*vector.lonvecs, $
	  *vector.latvecs,map.projection, $
	  spval=map.missing_value,position=mappos, color=vector.carrows,ps=ps, $
          scalemag=vector.vmag,scalelen=vector.vlen,xscale=xmid,yscale=yll-.05, $
	  xarrowlabel=vector.lonvector, yarrowlabel=vector.latvector,toplon=plon)
        if vector.vecanimate eq 'on' then $
          vector.vmag=vmagnitude
      endif
    endif else begin
        vmagnitude=gridvec(*vector.lonvecdata,*vector.latvecdata,*vector.lonvecs, $
	  *vector.latvecs,map.projection, $
	  spval=map.missing_value,position=mappos, color=vector.carrows,ps=ps, $
          scalemag=vector.vmag,scalelen=vector.vlen,xscale=xmid,yscale=yll-.05, $
	  xarrowlabel=vector.lonvector, yarrowlabel=vector.latvector,toplon=plon)
        if vector.vecanimate eq 'on' then $
          vector.vmag=vmagnitude
;   axes:
;      contour,data,lons,lats,/noerase,position=mappos,/nodata,$
;        xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=1,ticklen=-.015,$
;        xticks=n_elements(xticlabs)-1,xminor=3,xtickname=xticlabs,$
;        yticks=n_elements(yticlabs)-1,yminor=3,ytickname=yticlabs
    endelse
    xyouts,xmid,yur+.06,fieldlab ,/norm,align=0.5,charsize=chsize
    xyouts,xmid,yur+.03,toplab,/norm,align=0.5,charsize=chsize
    if map.minmaxlab eq 1 then xyouts,xmid,yll-.11,minmaxlab,/norm,align=0.5,charsize=chsize
    xyouts,xmid,yll-.15,botlab1,/norm,align=0.5,charsize=chsize
  end
  else: print,'>>> Global SV maps: unknown plot type ',map.plottype
endcase

;latnames=[0 10 20 30 40 50 60]
;lonnames=[70 80 90 85 75 65 55]
;
if (map.continents eq 1 or map.grid eq 1) and $
   field.grid_type ne 'magnetic' then begin
  if map.continents eq 1 then map_continents,color=map.continents_color
  if map.grid eq 1 then map_grid,/label,color=map.grid_color 
;	latnames=latnames, lonnames=lonnames
endif else if (map.continents eq 1 or map.grid eq 1) and $
  field.grid_type eq 'magnetic' then begin
  if map.continents eq 1 then begin
    print,'WARNING: cannot plot continents on magnetic grid.'
    map.continents = 0
  endif
  if map.grid eq 1 then begin
    print,'WARNING: cannot plot map grid on magnetic grid.'
    map.grid = 0
  endif
endif

; map.fmin,max and map.continents may have been changed, 
; so update state:
;
*info.pmap = map
end
