;-----------------------------------------------------------------------
function change_xaxis,utvert,x_axis
;
; This function returns a string array that is the ut axis on a plot
; the x_axis arguement will create an slt axis that is dependent on
; the user selected longitude and will make the necessary adjustments.
; written by Tom Freestone 9/3/03
;
; To plot the time axis the first step is to determine what type of 
; time unit is to be displayed, which will be used to retrieve the data
; from the correct column in the matrix.  Next the increment between 
; each label is chosen based on the size of the time file.  Then
; a string array (timelabs) with every time on the history is made.
; Then the appropriate labels are chosen based on what the user has chosen:
; min, max, or a specified interval of times.  modified 2/19/04 by Tom

;the minutes are used to determine the units to be used for the axis
;it is also the value used in determining the increment between labels

mtime = utvert.mtime
file=utvert.file
field = utvert.field
utmin=utvert.utmin
utmax=utvert.utmax
; finds the mtime index of the minimum and maximum times to be plotted
for i=0,file.ntimes-1 do begin
  if file.mtimes[0,i] eq utmin[0] and file.mtimes[1,i] eq utmin[1] and $
    file.mtimes[2,i] eq utmin[2] then begin
    imtime_min=i
  endif
  if file.mtimes[0,i] eq utmax[0] and file.mtimes[1,i] eq utmax[1] and $
    file.mtimes[2,i] eq utmax[2] then begin
    imtime_max=i
  endif
endfor
imax=imtime_max
imin=imtime_min
nhist=imax-imin+1
arr_minutes=get_time_min(file.mtimes,utvert.utmin,utvert.utmax)
dims=size(arr_minutes)
dims=dims[1]
minutes=arr_minutes[dims-1]-arr_minutes[0]
minutes=minutes+(arr_minutes[1]-arr_minutes[0])
utvert.minutes=minutes
utmin=utvert.utmin
utmax=utvert.utmax
;

; determines which unit of time the axis will be displayed in
if mtime[1,1]-mtime[1,0] ne 0 then begin
  type_hist=1
endif else if mtime[2,1]-mtime[2,0] ne 0 then begin
  type_hist=2
;  if minutes gt 180. then utvert.utint=1 
  if minutes gt 60*5*24 then type_hist=0
endif else begin
  type_hist=0
endelse  

; shifts the data the longitude by 71 degrees and calculates the corresponding time
if field.grid_type eq 'magnetic' then begin
  slon=fslt(utvert.sslt+(utvert.slon-71)/15.,12,utvert.slon,'getlon',mag=mag)
  lon_time=slon/15
endif else begin
  lon_time=utvert.slon/15
endelse

inc=0

timelabs = strarr(nhist)
sltlabs = fltarr(nhist)

label_count=0

if type_hist eq 2 then begin
  if minutes gt 180. then type_hist=1 

  if type_hist eq 2 then lon_time=lon_time*(60/(mtime[2,1]-mtime[2,0]))
  for i=0,nhist-1 do begin
  ; changes SLT axis with each longitude
    if x_axis eq 'slt' and utvert.slideselect ne 'SLT' then begin
      hour=imin+i+lon_time
      if hour gt imax then hour = hour-imax
      if hour lt 0 then hour = imax +hour
    endif else begin
      hour=i+imin
    endelse

    if mtime[type_hist,hour] mod utvert.utint eq 0 then begin
; if the number of histories is larger than 60 then contour is unable to display
; every history on the xaxis so instead of showing the hours, the days are 
; shown.  They are found with the if statements below.  
      if type_hist eq 1 then begin
        if mtime[2,hour] eq 0 then begin
            timelabs[inc] = string(format='(I4)',mtime[type_hist,hour])
            timelabs[inc] = strcompress(timelabs[inc],/remove_all)
	    label_count=label_count+1
        endif else begin
          timelabs[inc] = ' '
        endelse
      endif else begin
        timelabs[inc] = string(format='(I4)',mtime[type_hist,hour])
        timelabs[inc] = strcompress(timelabs[inc],/remove_all)
        label_count=label_count+1
      endelse
      inc=inc+1
    endif 
  endfor
; ensures that a large file will not make the labels too close
  label_inc=1.
  if nhist le 30 and nhist gt 12 then begin
    label_inc=2.
  endif 
  if nhist gt 60 then begin
    label_inc=4.
  endif
  if inc gt 120 then begin
    label_inc=20.
  endif
  if type_hist eq 1 and inc lt 30 then label_inc=1
endif else begin
for i=0,nhist-1 do begin
; changes SLT axis with each longitude
  if x_axis eq 'slt' and utvert.slideselect ne 'SLT' then begin
    hour=imin+i+lon_time
    if hour gt imax then hour = hour-imax
    if hour lt 0 then hour = imax +hour
  endif else begin
    hour=i+imin
  endelse

  if mtime[type_hist,hour] mod utvert.utint eq 0 then begin
; if the number of histories is larger than 60 then contour is unable to display
; every history on the xaxis so instead of showing the hours, the days are 
; shown.  They are found with the if statements below.  
    if nhist/utvert.utint gt 60 and type_hist eq 1 then begin
      if mtime[type_hist,hour] eq 0 then begin
        if type_hist eq 1 then type_hist2 = 0
        timelabs[inc] = string(format='(I4)',mtime[type_hist2,hour])
        timelabs[inc] = strcompress(timelabs[inc],/remove_all)
        label_count=label_count+1
      endif else begin
        timelabs[inc] = ' '
      endelse
    endif else begin
      timelabs[inc] = string(format='(I4)',mtime[type_hist,hour])
      timelabs[inc] = strcompress(timelabs[inc],/remove_all)
      label_count=label_count+1
    endelse
    inc=inc+1
  endif 
endfor
; ensures that a large file will not make the labels too close
  label_inc=1.
  if nhist/utvert.utint lt 24 and nhist/utvert.utint gt 12 then begin
    label_inc=2.
  endif else if nhist/utvert.utint le 60 then begin
    label_inc=4.
  endif else begin
    label_inc=24.
    ;if type_hist eq 1 then type_hist=0
    ;if type_hist eq 2 then type_hist=1
  endelse
if x_axis eq 'slt' and nhist/utvert.utint gt 60 then $
  label_inc=ceil(nhist/30.)
endelse
; this changes the label increment to its maximum to compensate for
; the shit in slt with a changing longitude

if inc le 30 then begin
  xticlabs=strarr(nhist)
  for i=0, nhist-1 do begin
      if (i mod label_inc) eq 0 then begin
        xticlabs[i] = timelabs[i]
      endif else begin
        xticlabs[i]=' '
      endelse
  endfor
endif else if nhist gt 30 and inc gt 12 then begin
  xticlabs = strarr(ceil(float(nhist/label_inc))+1)
  index=0
  for i=0, nhist-1 do begin
      if (i mod label_inc) eq 0 then begin
        xticlabs[index] = timelabs[i]
        index=index+1
      endif 
  endfor
  if timelabs[nhist-1] ne xticlabs[index-1] then begin
    xticlabs[index]=timelabs[nhist-1]
  endif else begin
    if xticlabs[index-1] eq '' then xticlabs[index-1] = ' '
    newstring=xticlabs
    xticlabs=strarr(ceil(float(nhist/label_inc)))
    xticlabs=newstring[0:fix((float(nhist)/float(label_inc)/float(utvert.utint)))]
  endelse
endif else begin
  xticlabs=strarr(inc)
  xticlabs=timelabs(0:inc-1)
endelse

return,xticlabs
end
;-----------------------------------------------------------------------
function change_time_units,utvert
;this function returns a string label that corresponds to the units in
;the string axis produced in the function above 
;written by Tom Freestone 9/3/03

mtime=utvert.mtime
minutes=utvert.minutes
dims=size(mtime)
if minutes lt 180. then units='MINS'
if minutes ge 180. and minutes le 2*24*60 then $
  units='HRS'
if minutes gt 2*24*60 then $
  units='DAYS'
return,units
end
;-----------------------------------------------------------------------
pro pltutvert,info,ps=ps,animate=animate,png=png
;this function is called from utverts.pro and it plots the data produced by
;defutvertdata.pro, this is where all of the plot options originate and 
;
utvert = *info.putvert
fields = *info.fields
if not keyword_set(animate) and not keyword_set(ps) and $
   not keyword_set(png) then begin
  widget_control,utvert.draw,get_value=index
  wset,index
  erase
endif
file = *info.pfile
mtime = file.mtimes
field = utvert.field
fields = *info.fields
data = *utvert.data
levs = *utvert.levs 
dim=size(mtime)
;if dim[0] gt 1 then begin
;  mod_ut=*utvert.uts
;endif else begin
  mod_ut=mtime
;endelse

times = *field.times
nlev = n_elements(levs)
nut = n_elements(ut)
utmin=utvert.utmin
utmax=utvert.utmax
for i=0,file.ntimes-1 do begin
  if file.mtimes[0,i] eq utmin[0] and file.mtimes[1,i] eq utmin[1] and $
    file.mtimes[2,i] eq utmin[2] then begin
    imtime_min=i
  endif
  if file.mtimes[0,i] eq utmax[0] and file.mtimes[1,i] eq utmax[1] and $
    file.mtimes[2,i] eq utmax[2] then begin
    imtime_max=i
  endif
endfor
imax=imtime_max
imin=imtime_min
rhyaxis = utvert.rhyaxis
if rhyaxis gt 0 and (file.diffs gt 0 or field.grid_type eq 'magnetic') then $
  rhyaxis = 0 
;
; finds the NaNs in the data
find_nans,info,field.name,data,numnans
if numnans gt 0 then print,'>>NaNs found:',numnans
if numnans gt 0 then begin
  rhyaxis = 0   
  utvert.rhyaxis = 0
endif

dataset=size(mod_ut)
if dataset[0] gt 1 then begin
  ;dataset=ceil(float(dataset[2])/float(utvert.utint))
  dataset=ceil(float(imax-imin+1)/float(utvert.utint))
  ut=fltarr(dataset)
  for x=0,dataset-1 do begin
    ut[x]=mod_ut[0,x+imin]*24.*60.+mod_ut[1,x+imin]*60.+mod_ut[2,x+imin]

  endfor
endif else begin
 dataset=2
 ut=mod_ut[0]*24.*60.+mod_ut[1]*60.+mod_ut[2]
endelse
;
; Check for all missing value:
;
nmissing = 1
missing_value = float(utvert.missing_value)
text = 1 
nodata = check_missing(data,missing_value,field.name,text=text,$
  nmissing=nmissing)
if nodata eq 1 then return
if nmissing gt 0 then print,'UT vs. Vertical: Field ',field.name,': Found ',$
  nmissing,' missing data points (out of ',n_elements(data),')'
;
; Field min,max:
; If utvert.fmin >  utvert.fmax, then leave as such for the animator but use 
;                              field extremes for plotting current frame.
; If utvert.fmin =  utvert.fmax, then reset to data extremes 
; If utvert.fmin <  utvert.fmax, then leave as such as for plotting.
;
fminmax,data,framemin,framemax,missing_value
if utvert.fmin ge utvert.fmax then begin  ; utvert.fmin >= utvert.fmax
  fminmax,data,fmin,fmax,missing_value
  if utvert.fmin eq utvert.fmax then begin
    utvert.fmin=fmin & utvert.fmax=fmax
    print,'pltutvert reset utvert.fmin,max=',utvert.fmin,utvert.fmax
  endif
endif else begin                        ; utvert.fmin < utvert.fmax
  fmin = utvert.fmin & fmax = utvert.fmax
endelse

if utvert.setcontour eq 'off' and utvert.plotz eq 0 then begin
  cmin=0. & cmax=0. & cint=0.
  defutvertdata,utvert,*fields[utvert.ifield].data
;
;  Set local levels and number of levels variable since changed in deflondata for WACCM
;
  IF info.ftype EQ 'WACCM' THEN BEGIN

    levs = *utvert.levs 
    nlev = n_elements(levs)

  ENDIF
  
  fminmax,*utvert.data,fmin,fmax,utvert.missing_value
  levels = mkclevels(fmin,fmax,cmin,cmax,cint)
  utvert.fmin=cmin & utvert.fmax=cmax & utvert.cint=cint
  *utvert.clevels = levels
  *info.putvert = utvert
  data = *utvert.data
endif
;
;  For altitude vertical coordinate, get min and max levels of data
;
if utvert.plotz gt 0 then begin
  cmin=0. & cmax=0. & cint=0.
  fminmax,*utvert.data,fmin,fmax,utvert.missing_value
  levels = mkclevels(fmin,fmax,cmin,cmax,cint)
  utvert.fmin=cmin & utvert.fmax=cmax & utvert.cint=cint
  *utvert.clevels = levels
  *info.putvert = utvert 
  data = *utvert.data
endif
;
; Image position:
;
xll = .15 & yll = .33
xur = .95 & yur = yll+.7*(xur-xll)
;corrects for position of and size of graphs and labels for extra y axi
if rhyaxis gt 0 then begin 
  xur=xur-.044 & xll=xll-.044 
endif
;if the UT and SLT axes are not necessary then this adjusts the other components
if utvert.slideselect ne 'LON' or utvert.add_slt eq 0 then $
  yll = yll -.1
axespos  = [xll,yll,xur,yur]
xmid = .5*(xur+xll)
;
; Byte-scale to an image. Make any missing data black:
; 12/9/05 btf: max=fmax should force bytscl to ignore missing values,
;              but this does not seem to work.
;
if (utvert.plottype eq 'image_only') or (utvert.plottype eq 'image+contours') then begin
  missing_indices = where(data eq missing_value,nmissing)
; notmissing = where(data ne missing_value,nnotmissing)
  if nmissing gt 0 then begin
    print,'Field ',field.name,' utvert slice: Found ',nmissing,' missing data points.'
    image = bytscl(data,min=fmin,max=fmax,top=!d.table_size-3)+1
;   image(missing_indices) = 0
  endif else begin
    image = bytscl(data,min=fmin,max=fmax,top=!d.table_size-3)+1
  endelse
endif ; making an image
;
; Set up for color bar:
;
if utvert.plottype ne 'monochrome_contours' then begin
  barw = xur-xll-.05*(xur-xll) & barh = .03
  xbar = xmid-.5*barw
  ybar = yll-barh-.19
  baroff = .035
  cblabels = [strcompress(string(fmin,format="(g9.3)"),/remove_all),$
    strcompress(string(0.5*(fmin+fmax),format="(g9.3)"),/remove_all),$
    strcompress(string(fmax,format="(g9.3)"),/remove_all)]
endif
;
; Titles, labels, tic marks, etc:
;
if utvert.slideselect eq 'SLT' then $
  axis_label='slt' else axis_label='ut'
xticlabs=change_xaxis(utvert,axis_label)
units = change_time_units(utvert)
;daytitle is the string array that will contain the utmin day in the first
;array box and it will contain the hour of utmin in the second box
daytitle=['','']
if utvert.minutes le 24.*60. then begin 
  daytitle[0]='DAY '+string(format="(i3)",utmin[0])
  daytitle[0]= strcompress(daytitle[0],/remove_all)
endif
xtitle = 'UT ('+units+') (MTIMES '+$
  string(format="(i3)",utvert.utmin[0])+','+$
  string(format="(i3)",utvert.utmin[1])+','+$
  string(format="(i3)",utvert.utmin[2])+' TO '+$
  string(format="(i3)",utvert.utmax[0])+','+$
  string(format="(i3)",utvert.utmax[1])+','+$
  string(format="(i3)",utvert.utmax[2])+')'
;when minutes are desired, this lets the user know what hour of the day it is
if units eq 'MINS' then begin
  daytitle[0]=daytitle[0]+'HR:  '+string(format="(i3)",utvert.utmin[1])
  daytitle[0]= strcompress(daytitle[0],/remove_all)
endif
ytitle = field.levname + ' (' + field.levunits + ')' ; zp or height
;
;  WACCM vertical coordinate converted to log pressure so change label
;
if info.ftype eq 'WACCM' THEN ytitle = 'ZP log pressure level (ln(p0/p))' 

IF utvert.plotz EQ 1 THEN ytitle = ' GEOPOTENTIAL HEIGHT (km) '
IF utvert.plotz EQ 2 THEN ytitle = ' GEOMETRIC HEIGHT (km) '
;
; Field label:
;
if (utvert.log10 eq 'density fields' and isdensity(field.name) gt 0) or $
   (utvert.log10 eq 'all fields') then begin
  if strlen(field.long_name) gt 0 then fieldlab = 'LOG10 '+field.long_name $
    else fieldlab = 'LOG10 '+field.name
endif else begin
  if strlen(field.long_name) gt 0 then fieldlab = field.long_name $
    else fieldlab = field.name
endelse
if file.diffs le 0 then begin
  if strlen(field.units) gt 0 then $
    fieldlab = fieldlab + ' (' + strcompress(field.units,/remove_all) + ')'
endif else fieldlab = fieldlab + ' (' + field.difftype + ' ' + $
  strcompress(field.units,/remove_all) + ')'
;
; Top label (under field label):
;
uthrs = float(utvert.mtime[1])+float(utvert.mtime[2])/60.
;taken out because makes the label too big
if utvert.minutes le 24*60. then begin
  toplab = string(format="('DAY = ',i3)",utvert.mtime[0])
endif else begin
  toplab = ''
endelse
if utvert.zonalmean gt 0 or utvert.globalmean gt 0 then begin
  if utvert.zonalmean gt 0 then begin
    toplab = toplab + ' ZONAL MEAN'
  endif
  if utvert.globalmean gt 0 then begin
    toplab = toplab + ' GLOBAL MEAN'
  endif
endif else begin
  if utvert.slideselect eq 'LON' then $
    toplab = toplab + string(format="('  LON = ',f7.2)",utvert.slon)
  if utvert.slideselect eq 'SLT' then begin
    if field.grid_type eq 'magnetic' then begin
      toplab = toplab + string(format="('  MLT = ',f7.2)",utvert.sslt)
    endif else begin
      toplab = toplab + string(format="('  SLT = ',f7.2)",utvert.slon/15.+12.)
    endelse
  endif
endelse
if utvert.globalmean eq 0 then begin
  toplab = toplab + string(format="('  LAT = ',f6.2)",utvert.slat)
endif 
;
; Bottom label:
;
botlab1 = strcompress(field.ncfile,/remove_all)
;
; Min,max label:
;
minmaxlab = 'MIN,MAX = '+string(format="(g10.4)",framemin)+','+$
                         string(format="(g10.4)",framemax)
if utvert.plottype ne 'image_only' then $
  minmaxlab = minmaxlab + string(format="(' INTERVAL = ',g10.4)",utvert.cint)
;
; Contour levels were made by mkclevels.pro.
;
clevels = *utvert.clevels
nlevels = n_elements(clevels)

clinestyle = intarr(nlevels)
clinestyle[*] = 0 ; solid
for i=0,nlevels-1 do if clevels[i] lt 0. then clinestyle[i] = 2 ; dashed
conlab = 'Contour from '+string(format="(g10.4)",utvert.fmin)+ $
         ' to '         +string(format="(g10.4)",utvert.fmax)+ $
         ' Interval = ' +string(format="(g10.4)",utvert.cint)
c_charsize = 1.1 ; contour line label character size
chsize = 1.2     ; info label character size
irregular = 0 & if field.grid_type eq 'magnetic' then irregular = 1
;
; Contour will not draw y-axis if extra non-linear right-hand axis is 
; to be drawn by pro altyax:
;
;adjusts the size of the plot and image for an extra y axis
yaxstyle = 1 & if rhyaxis gt 0 then yaxstyle = 9
xsize=xur-xll & ysize=yur-yll
imscalex=16
imscaley=6.25
nlevs=field.nlev
;initializes slt label
iltax=1
;
; controls the slt axis for minute histories
;
if mtime[2,1]-mtime[2,0] ne 0 then begin
  type_hist=2
endif else begin
  type_hist=0
endelse
;
; Display image and/or contour:
;
case utvert.plottype of
;
; Display image only. Use contour,/nodata to draw axes, ticmarks, labels:
;
;labutx is the procedure that adds an extra xaxis
;the different xyouts adjusts the window spacing for the different options

  'image_only': begin
    if utvert.slideselect ne 'LON' or utvert.add_slt eq 0 then begin
      image=congrid(image,401,330,/interp,/minus_one)
    endif else begin
      image=congrid(image,401,280,/interp,/minus_one)
    endelse
    tv,image,xll,yll,/norm,xsize=xsize,ysize=ysize       ; ras image
    contour,data,ut,levs,/noerase,/nodata,position=axespos,$       ; axes
      xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=yaxstyle,ticklen=-.015,$
      xticks=n_elements(xticlabs)-1,xminor=3,xtickname=xticlabs,charsize=chsize

    ;if utvert.slideselect eq 'LON' and utvert.add_slt gt 0 then begin
    if utvert.slideselect eq 'LON' and utvert.add_slt gt 0 or $
      utvert.slideselect eq 'LON' and type_hist ne 2 and utvert.add_slt gt 0 then begin
      labutx, utvert,[xll,yll,xur,yur],$
        charsize=chsize
    endif
    if utvert.slideselect ne 'LON' or utvert.add_slt eq 0 then begin
      clrbar,barw,barh,xbar,ybar+.1,cblabels,botcolor=1,topcolor=!d.table_size-2,$
        charsize=chsize,laboffset=baroff
      xyouts,xmid,yur+.06,fieldlab ,/norm,align=0.5,charsize=chsize
      xyouts,xmid,yur+.03,toplab   ,/norm,align=0.5,charsize=chsize
      if utvert.minmaxlab eq 1 then xyouts,xmid,yll-.18,minmaxlab,/norm,align=0.5,charsize=chsize
      if utvert.filelab eq 1 then xyouts,xmid,yll-.21,botlab1  ,/norm,align=0.5,charsize=chsize
    endif else begin 
      clrbar,barw,barh,xbar,ybar,cblabels,botcolor=1,topcolor=!d.table_size-2,$
        charsize=chsize,laboffset=baroff
      xyouts,xmid,yur+.06,fieldlab ,/norm,align=0.5,charsize=chsize
      xyouts,xmid,yur+.03,toplab   ,/norm,align=0.5,charsize=chsize
      if utvert.minmaxlab eq 1 then xyouts,xmid,yll-.28,minmaxlab,/norm,align=0.5,charsize=chsize
      if utvert.filelab eq 1 then xyouts,xmid,yll-.31,botlab1  ,/norm,align=0.5,charsize=chsize
    endelse
    if utvert.minutes le 24.*60. then begin
      xyouts,xll,yll-.07,daytitle[0],/norm,align=0.5,charsize=chsize
      xyouts,xur,yll-.07,daytitle[1],/norm,align=0.5,charsize=chsize
    endif
  end
;
; Display image with contour overlay:
;
  'image+contours': begin
    if utvert.slideselect ne 'LON' or utvert.add_slt eq 0 then begin
      image=congrid(image,401,330,/interp,/minus_one)
    endif else begin
      image=congrid(image,401,280,/interp,/minus_one)
    endelse
    tv,image,xll,yll,/norm,xsize=xsize,ysize=ysize 
    contour,data,ut,levs,/noerase,position=axespos,$              ; contour
      /follow,xstyle=5,ystyle=5,c_charsize=c_charsize,$
      levels=clevels,c_linestyle=clinestyle,max_value=missing_value,$
      c_colors=[utvert.clineclr]
    contour,data,ut,levs,/noerase,/nodata,position=axespos,$       ; axes
      xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=yaxstyle,ticklen=-.015,$
      xticks=n_elements(xticlabs)-1,xminor=3,xtickname=xticlabs,charsize=chsize
    if utvert.slideselect eq 'LON' and utvert.add_slt gt 0 or $
      utvert.slideselect eq 'LON' and type_hist ne 2 and utvert.add_slt gt 0 then begin
;      labutx, utvert.mtime,nut,utvert.slon,[xll,yll,xur,yur], $
;	charsize=charsize,isltax=isltax
      labutx, utvert,[xll,yll,xur,yur],$
        charsize=chsize
    endif
    if utvert.slideselect ne 'LON' or utvert.add_slt eq 0 then begin
      clrbar,barw,barh,xbar,ybar+.1,cblabels,botcolor=1,topcolor=!d.table_size-2,$
        charsize=chsize,laboffset=baroff
      xyouts,xmid,yur+.06,fieldlab ,/norm,align=0.5,charsize=chsize
      xyouts,xmid,yur+.03,toplab   ,/norm,align=0.5,charsize=chsize
      if utvert.minmaxlab eq 1 then xyouts,xmid,yll-.18,minmaxlab,/norm,align=0.5,charsize=chsize
      if utvert.filelab eq 1 then xyouts,xmid,yll-.21,botlab1  ,/norm,align=0.5,charsize=chsize
    endif else begin 
      clrbar,barw,barh,xbar,ybar,cblabels,botcolor=1,topcolor=!d.table_size-2,$
        charsize=chsize,laboffset=baroff
      xyouts,xmid,yur+.06,fieldlab ,/norm,align=0.5,charsize=chsize
      xyouts,xmid,yur+.03,toplab   ,/norm,align=0.5,charsize=chsize
      if utvert.minmaxlab eq 1 then xyouts,xmid,yll-.28,minmaxlab,/norm,align=0.5,charsize=chsize
      if utvert.filelab eq 1 then xyouts,xmid,yll-.31,botlab1  ,/norm,align=0.5,charsize=chsize
    endelse
    if utvert.minutes le 24.*60. then begin
      xyouts,xll,yll-.07,daytitle[0],/norm,align=0.5,charsize=chsize
      xyouts,xur,yll-.07,daytitle[1],/norm,align=0.5,charsize=chsize
    endif
  end
;
; Contour only (B&W):
;
  'monochrome_contours': begin
    contour,data,ut,levs,/noerase,position=axespos,$              ; contour
      /follow,xstyle=5,ystyle=5,c_charsize=c_charsize,$
      levels=clevels,c_linestyle=clinestyle,max_value=missing_value,$
      c_colors=[utvert.clineclr]
    contour,data,ut,levs,/noerase,/nodata,position=axespos,$       ; axes
      xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=yaxstyle,ticklen=-.015,$
      xticks=n_elements(xticlabs)-1,xminor=3,xtickname=xticlabs,charsize=chsize
    ;if utvert.slideselect eq 'LON' and utvert.add_slt gt 0 then begin
    if utvert.slideselect eq 'LON' and utvert.add_slt gt 0 or $
      utvert.slideselect eq 'LON' and type_hist ne 2 and utvert.add_slt gt 0 then begin
      labutx, utvert,[xll,yll,xur,yur],$
        charsize=chsize
    endif
    if utvert.slideselect ne 'LON' or utvert.add_slt eq 0 then begin
      xyouts,xmid,yur+.06,fieldlab ,/norm,align=0.5,charsize=chsize
      xyouts,xmid,yur+.03,toplab   ,/norm,align=0.5,charsize=chsize
      if utvert.minmaxlab eq 1 then xyouts,xmid,yll-.15,minmaxlab,/norm,align=0.5,charsize=chsize
      if utvert.filelab eq 1 then xyouts,xmid,yll-.18,botlab1  ,/norm,align=0.5,charsize=chsize
    endif else begin 
      xyouts,xmid,yur+.06,fieldlab ,/norm,align=0.5,charsize=chsize
      xyouts,xmid,yur+.03,toplab   ,/norm,align=0.5,charsize=chsize
      if utvert.minmaxlab eq 1 then xyouts,xmid,yll-.28,minmaxlab,/norm,align=0.5,charsize=chsize
      if utvert.filelab eq 1 then xyouts,xmid,yll-.31,botlab1  ,/norm,align=0.5,charsize=chsize
    endelse
    if utvert.minutes le 24.*60. then begin
      xyouts,xll,yll-.07,daytitle[0],/norm,align=0.5,charsize=chsize
      xyouts,xur,yll-.07,daytitle[1],/norm,align=0.5,charsize=chsize
    endif
  end
;
; Color fill contour:
;
;the coordinates for the contours and colorfill option are different because
;they would not match up with the same coordinates 
;
  'colorfill_contours': begin
    contour,data,ut,levs,/noerase,/nodata,position=axespos,$        ; axes
      xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=yaxstyle,ticklen=-.015,$
      xticks=n_elements(xticlabs)-1,xminor=3,xtickname=xticlabs,charsize=chsize
    contour,data,ut,levs,/noerase,position=[xll+0.002,yll,xur+.002,yur],$
     /follow,/fill,$   ; colorfill
     xstyle=5,ystyle=5,levels=clevels,min_value=fmin,max_value=fmax

    contour,data,ut,levs,/noerase,position=axespos,/follow,$         ; contour
      xstyle=5,ystyle=5,c_charsize=c_charsize,levels=clevels,$
      c_linestyle=clinestyle,max_value=missing_value,c_colors=[utvert.clineclr]

    ;if utvert.slideselect eq 'LON' and utvert.add_slt gt 0 then begin
    if utvert.slideselect eq 'LON' and utvert.add_slt gt 0 or $
      utvert.slideselect eq 'LON' and type_hist ne 2 and utvert.add_slt gt 0 then begin
      labutx, utvert,[xll,yll,xur,yur],$
        charsize=chsize
    endif
    if utvert.slideselect ne 'LON' or utvert.add_slt eq 0 then begin
      clrbar,barw,barh,xbar,ybar+.1,cblabels,botcolor=1,topcolor=!d.table_size-2,$
        charsize=chsize,laboffset=baroff
      xyouts,xmid,yur+.06,fieldlab ,/norm,align=0.5,charsize=chsize
      xyouts,xmid,yur+.03,toplab   ,/norm,align=0.5,charsize=chsize
      if utvert.minmaxlab eq 1 then xyouts,xmid,yll-.18,minmaxlab,/norm,align=0.5,charsize=chsize
      if utvert.filelab eq 1 then xyouts,xmid,yll-.21,botlab1  ,/norm,align=0.5,charsize=chsize
    endif else begin 
      clrbar,barw,barh,xbar,ybar,cblabels,botcolor=1,topcolor=!d.table_size-2,$
        charsize=chsize,laboffset=baroff
      xyouts,xmid,yur+.06,fieldlab ,/norm,align=0.5,charsize=chsize
      xyouts,xmid,yur+.03,toplab   ,/norm,align=0.5,charsize=chsize
      if utvert.minmaxlab eq 1 then xyouts,xmid,yll-.28,minmaxlab,/norm,align=0.5,charsize=chsize
      if utvert.filelab eq 1 then xyouts,xmid,yll-.31,botlab1  ,/norm,align=0.5,charsize=chsize
    endelse
    if utvert.minutes le 24.*60. then begin
      xyouts,xll,yll-.07,daytitle[0],/norm,align=0.5,charsize=chsize
      xyouts,xur,yll-.07,daytitle[1],/norm,align=0.5,charsize=chsize
    endif
  end
  else: print,'>>> pltutvert: unknown plot type ',utvert.plottype
endcase ; plot type
;calls the procedure to make another y axis 

if rhyaxis gt 0 and utvert.plotz GE 1 then presyax,info,utvert,'ut',xll,xur,yll,yur,chsize

if rhyaxis gt 0  and utvert.plotz eq 0 then begin
  altyax,info,utvert,'utvert',xll,xur,yll,yur,chsize 
endif
;
; utvert.fmin,max may have been changed, so update state:
;
*info.putvert =utvert 
end
;-----------------------------------------------------------------------
