;
function yaxpos,x,vec0,vec1,nvec,vb,vt
;             zp   ht
  bracket, x,vec1,nvec,1,k0,k1,ier
  f1 = (x-vec1(k0)) / (vec1(k1)-vec1(k0))
  xvec0 = f1*vec0(k1) + (1.-f1)*vec0(k0)
  ypos = vb + (vt-vb)*(xvec0-vec0(0))/(vec0(nvec-1)-vec0(0))
  return,ypos
end
;-----------------------------------------------------------------------
;
pro bracket, x,xx,nx,inc,n1,n2,ier
;
; Bracket x in xx(nx), returning lower index in n1 and upper index in n2
; If inc > 0 -> array increases from bottom to top,
; If inc <= 0 -> array increases from top to bottom
;
ier = 0
;
; Array increases from bottom to top:
;
if (inc gt 0) then begin
  if (x lt xx(0)) then begin
    n1 = 0
    n2 = 1
    ier = 1
    return
  endif
  if (x gt xx(nx-1)) then begin
    n1 = nx-2
    n2 = nx-1
    ier = 2
    return
  endif
  for i=0,nx-2 do begin
    if (x ge xx(i) and x le xx(i+1)) then begin
      n1 = i
      n2 = i+1
      return
    endif
  endfor
;   
; Array increases from top to bottom:
;
endif else begin
  if (x gt xx(0)) then begin
    n1 = 0
    n2 = 1
    ier = 3
    return
  endif
  if (x lt xx(nx-1)) then begin
    n1 = nx-2
    n2 = nx-1
    ier = 4
    return
  endif
  for i=1,nx-2 do begin
    if (x le xx(i) and x ge xx(i+1)) then begin
      n1 = i
      n2 = i+1
      return
    endif
  endfor
endelse
return
end
;-----------------------------------------------------------------------
pro presyax,info,slice,slicetype,vl,vr,vb,vt,charsize
;this procedure was taken from the tgcmidl model written by Ben Foster
;it was slightly modified to work with the utvert structure
;
levsZPIn = *slice.levszp
IF info.ftype EQ 'WACCM' THEN levsZPIn = *slice.field.levs
levsAlt = *slice.levs

IF slicetype eq 'lon' or slicetype eq 'lat' or slicetype eq 'ut' THEN BEGIN
;print, 'Calling getzprof in presyax for lon'
;
  fields = *info.fields  ; fields info structure
  getzprof, info, slice, slicetype, fields, levsAlt
;
ENDIF
;
;  Get the index of the minimum and maximim vertical levels to use in original data  
;  
levMin = slice.levmin
IF slicetype eq 'lon' or slicetype eq 'lat' or slicetype eq 'ut' THEN levMin = slice.levminz
iLevMin = IXFIND_NEAREST(levsAlt,levMin)
levMax = slice.levmax
IF slicetype eq 'lon' or slicetype eq 'lat' or slicetype eq 'ut' THEN levMax = slice.levmaxz
iLevMax = IXFIND_NEAREST(levsAlt,levMax)
    
levsZP = levsZPin[iLevMin:iLevMax]

nlev = n_elements(levsZP)

dzp_axis = levsZP[nlev-1] - levsZP[0]
;
offtoax  = 0.    ; x offset from existing to new axes
offtonum = .02   ; x offset from existing axis to numeric label on new axis
offtolab = .07   ; x offset from existing axis to new axis string label
offylab  = .009  ; y offset to center numerics next to tic marks
ticlen   = .012  ; major tic len (minor tic len = .5*ticlen)
if charsize eq 0. then chsize = 1.2 else chsize = charsize
;
; Draw new vertical axis offset to right of right axis:
;
xpos = vr+offtoax
plots,[xpos,xpos],[vb,vt],/norm
xyouts,vr+offtolab,.5*(vt+vb),'LOG PRESSURE (ln(p0/p))',orientation=-90.,/norm,$
  align=.5,charsize=chsize
;
; Draw major tic marks and labels:
;
rndval = 10.
if dzp_axis lt 25. then rndval = 5.
if dzp_axis lt 20. then rndval = 3.
if dzp_axis lt 10. then rndval = 2.
botrnd = rnd(levsZP[0],rndval,dir=1)       ; round up
toprnd = rnd(levsZP[nlev-1],rndval,dir=-1) ; round down
nzplabmin = 6                   ; minimum number of major tics
del = (toprnd-botrnd)/nzplabmin ; delta
delrnd = rnd(del,rndval)
;if delrnd le 0 then delrnd = 1
if delrnd le 0 then delrnd = toprnd - botrnd
zp = botrnd
while zp le toprnd do begin
  ypos = yaxpos(zp,levsAlt,levsZP,nlev,vb,vt)
  if ypos le vt and ypos ge vb then begin
    plots,[xpos,xpos+ticlen],[ypos,ypos],/norm
    altlab = strcompress(string(format="(i4)",fix(zp+.5)),/remove_all)
    xyouts,vr+offtonum,ypos-offylab,altlab,/norm,charsize=chsize
  endif
;
; Draw minor tic marks:
;
  if dzp_axis ge 10 then begin
    zpnext = zp+delrnd                              ; height of next major
    yposnext = yaxpos(zpnext,levsAlt,levsZP,nlev,vb,vt) ; axis position of next major
    nminor = 3 & if yposnext-ypos gt 0.5*(vt-vb) then nminor = 6
    while (zpnext-zp) mod nminor ne 0 do nminor=nminor+1
    delminor = (zpnext-zp)/nminor
    if delminor le 0 then delminor = 1
    zpminor = zp-delrnd
;
; Draw minor tics below bottom major tic:
    while zpminor le zp do begin
      yposminor = yaxpos(zpminor,levsAlt,levsZP,nlev,vb,vt)
      if yposminor gt vb then $
        plots,[xpos,xpos+0.5*ticlen],[yposminor,yposminor],/norm
      zpminor = zpminor+delminor
    end 
    zpminor = zp+delminor
;
; Draw minor tics between current and next majors:
    while zpminor le zpnext do begin
      yposminor = yaxpos(zpminor,levsAlt,levsZP,nlev,vb,vt)
      if yposminor le vt and yposminor ge vb then begin
        plots,[xpos,xpos+0.5*ticlen],[yposminor,yposminor],/norm
      endif 
      if yposnext-ypos gt 0.5*(vt-vb) and zpminor eq zp+3.*delminor then begin
        altlab='('+strcompress(string(format="(i4)",fix(zp+.5)),/remove_all)+')'
;       xyouts,vr+offtonum,yposminor-offylab,altlab,/norm,charsize=chsize
      endif
      zpminor = zpminor+delminor
    end
  endif ; dzp_axis ge 10
;
; Increment major tic:
  zp = zp+delrnd
end ; zp le toprnd
end
