;
pro setaxis_data_event,event
  widget_control,event.id,get_uvalue=widget
  widget_control,event.top,get_uvalue=pdaxis
  daxis = *pdaxis
  data = *daxis.data
  ndats = n_elements(data)
  case widget of
    'VMIN': begin
      widget_control,event.id,get_value=minstring
      vmin = mkfloat(minstring[0],daxis.vmin,event.id)
      if (vmin lt data[0]) or (vmin gt data[ndats-1]) then begin
        print,'>>> Bad minimum value = ',vmin,' (must be >= ',data[0],$
          ' and <= ',data[ndats-1],')'
        widget_control,event.id,set_value=string(daxis.vmin)
      endif else begin
        daxis.vmin = vmin
        print,'Set minimum value = ',daxis.vmin
        *pdaxis = daxis
      endelse
    end
    'VMAX': begin
      widget_control,event.id,get_value=maxstring
      vmax = mkfloat(maxstring[0],daxis.vmax,event.id)
      if (vmax lt data[0]) or (vmax gt data[ndats-1]) then begin
        print,'>>> Bad max value = ',vmax,' (must be >= ',data[0],$
          ' and <= ',data[ndats-1],')'
        widget_control,event.id,set_value=string(daxis.vmax)
      endif else begin
        daxis.vmax = vmax
        print,'Set maximum value = ',daxis.vmax
        *pdaxis = daxis
      endelse
    end
    'OK': begin
      widget_control,daxis.textmin,get_value=minstring
      widget_control,daxis.textmax,get_value=maxstring
      vmin = mkfloat(minstring[0],daxis.vmin,daxis.textmin)
      vmax = mkfloat(maxstring[0],daxis.vmax,daxis.textmax)
      if vmin gt vmax then begin
        print,'>>> Minimum value must be < maximum: minimum=',vmin,' maximum=',vmax
        print,'    Resetting to full axis range: ',data[0],' to ',$
          data[ndats-1]
        daxis.vmin = data[0]
        daxis.vmax = data[ndats-1]
        widget_control,daxis.textmax,set_value=string(daxis.vmax)
        widget_control,daxis.textmin,set_value=string(daxis.vmin)
        *pdaxis = daxis
      endif else if vmin eq vmax then begin
        print,'Setting data axis minimum,maximum to full axis range: ',data[0],$
          ' to ',data[ndats-1]
        daxis.vmin = data[0]
        daxis.vmax = data[ndats-1]
        widget_control,daxis.textmax,set_value=string(daxis.vmax)
        widget_control,daxis.textmin,set_value=string(daxis.vmin)
        *pdaxis = daxis
        ;widget_control,event.top,/destroy
      endif else begin
        daxis.vmin = vmin
        daxis.vmax = vmax
        *pdaxis = daxis
        widget_control,event.top,/destroy
      endelse
    end
    'RESET': begin
      daxis.vmin = MIN(data)
      daxis.vmax = MAX(data)
      *pdaxis = daxis
      widget_control,event.top,/destroy
    end
    'CANCEL': begin
      print,'Canceling: data axis fmin,max=',daxis.vmin,daxis.vmax
      widget_control,event.top,/destroy
    end
    else: print,'>>> setaxes: unrecognized event: ',widget
  endcase
end
;-----------------------------------------------------------------------
pro setaxis_data,info,pslice
;
  slice = *pslice
  fields = *info.fields
  field = fields[slice.ifield]
  data = *field.data

  fmin = slice.fmin
  fmax = slice.fmax
;
  title = 'User set axis ranges for vertical slices'
  tlb = widget_base(column=1,title=title,group_leader=info.tlb,/modal)
;
; Bottom, top of vertical y-axis:
;
  database = widget_base(tlb,column=1,/frame)
  label = widget_label(database,value='Enter minimum value') 
  textmin = widget_text(database,/editable,value=string(fmin),$
    uvalue='VMIN')
  label = widget_label(database,value='Enter maximum value') 
  textmax = widget_text(database,/editable,value=string(fmax),$
    uvalue='VMAX')
;
; Reset to vertical range of field:
  button = widget_button(tlb,value='Reset to Data Range of Field',$
    uvalue='RESET')
;
; ok and cancel buttons:
;
  base = widget_base(tlb,/frame,row=1)
  button = widget_button(base,value='OK',uvalue='OK')
  button = widget_button(base,value='CANCEL',uvalue='CANCEL')
;
; State info:
;
  daxis = {daxis_struct, $
    vmin:fmin,   $ ; top axis value
    vmax:fmax,   $ ; bottom axis value
    textmin:textmin,     $ ; widget id of bottom
    textmax:textmax,     $ ; widget id of top
    data:ptr_new(data)   $ ; full levs array
  }
;
; Pointer to state info:
;
  pdaxis = ptr_new(daxis)
  widget_control,tlb,set_uvalue=pdaxis
  widget_control,tlb,/realize
  xmanager,'setaxis_data',tlb,/no_block
;
; Update slice state info: 
;
  slice.fmin = (*pdaxis).vmin  
  slice.fmax = (*pdaxis).vmax
  print,'Set user data bottom,top = ',slice.fmin,slice.fmax
  *pslice = slice 
end
