;
;-----------------------------------------------------------------------
function setminlat,lats,latmin,err
  err = 0
  nlats = n_elements(lats)
  if (latmin lt lats[0]) or (latmin gt lats[nlats-1]) then begin
    print,'>>> Bad latitude minimum = ',latmin,' (must be >= ',lats[0],$
      ' and <= ',lats[nlats-1],')'
    err = 1
    return,lats[0]
  endif else begin
    j = ixfind_nearest(lats,latmin)
    if j gt -1 then begin
      return,lats[j]
    endif else begin
      print,'>>> WARNING: cannot find j index to latmin=',latmin
      err = 1
      return,lats[0]
    endelse
  endelse
end
;
;-----------------------------------------------------------------------
function setmaxlat,lats,latmax,err
  err = 0
  nlats = n_elements(lats)
  if (latmax gt lats[nlats-1]) or (latmax lt lats[0]) then begin
    print,'>>> Bad latitude maximum = ',latmax,' (must be <= ',lats[nlats-1],$
      ' and >= ',lats[0],')'
    err = 1
    return,lats[nlats-1]
  endif else begin
    j = ixfind_nearest(lats,latmax)
    if j gt -1 then begin
      return,lats[j]
    endif else begin
      print,'>>> WARNING: cannot find j index to latmax=',latmax
      err = 1
      return,lats[nlats-1]
    endelse
  endelse
end
;
;-----------------------------------------------------------------------
pro setaxis_lat_event,event
  widget_control,event.id,get_uvalue=widget
  widget_control,event.top,get_uvalue=plataxis
  lataxis = *plataxis
  lats = *lataxis.lats     ; full axis latitudes
  nlats = n_elements(lats)
  case widget of
    'LATMIN': begin
      widget_control,event.id,get_value=botstring
      latmin = mkfloat(botstring[0],lataxis.latmin,event.id)
      latmin = setminlat(lats,latmin,err)
      if not err then begin
        lataxis.latmin = latmin
        print,'Set latitude minimum = ',lataxis.latmin
        *plataxis = lataxis
      endif else begin
        widget_control,event.id,setvalue=lataxis.latmin
      endelse
    end
    'LATMAX': begin
      widget_control,event.id,get_value=topstring
      latmax = mkfloat(topstring[0],lataxis.latmax,event.id)
      latmax = setmaxlat(lats,latmax,err)
      if not err then begin
        lataxis.latmax = latmax
        print,'Set latitude maximum = ',lataxis.latmax
        *plataxis = lataxis
      endif else begin
        widget_control,event.id,setvalue=lataxis.latmax
      endelse
    end
    'OK': begin

      latmin = lataxis.latmin
      latmax = lataxis.latmax
      if latmin gt latmax then begin
        print,'>>> Minimum must be < maximum: minimum=',latmin,' maximum=',latmax
        print,'    Resetting to full axis range: ',lats[0],' to ',$
          lats[nlats-1]
        lataxis.latmin = lats[0]
        lataxis.latmax = lats[nlats-1]
        widget_control,lataxis.textmax,set_value=string(lataxis.latmax)
        widget_control,lataxis.textmin,set_value=string(lataxis.latmin)
        *plataxis = lataxis
      endif else if latmin eq latmax then begin
        print,'Setting latitude axis min,max to full range: ',lats[0],$
          ' to ',lats[nlats-1]
        lataxis.latmin = lats[0]
        lataxis.latmax = lats[nlats-1]
        widget_control,lataxis.textmax,set_value=string(lataxis.latmax)
        widget_control,lataxis.textmin,set_value=string(lataxis.latmin)
        *plataxis = lataxis
        widget_control,event.top,/destroy
      endif else begin
        lataxis.latmin = latmin
        lataxis.latmax = latmax
        *plataxis = lataxis
        widget_control,event.top,/destroy
      endelse
    end
    'RESET': begin
      lataxis.latmin = lats[0]
      lataxis.latmax = lats[nlats-1]
      *plataxis = lataxis
      widget_control,event.top,/destroy
    end
    'CANCEL': begin
      print,'Canceling: y-axis latmin,max=',lataxis.latmin,lataxis.latmax
      widget_control,event.top,/destroy
    end
    else: print,'>>> setaxes: unrecognized event: ',widget
  endcase
end
;-----------------------------------------------------------------------
pro setaxis_lat,info,pslice
;
  slice = *pslice
  fields = *info.fields
  field = fields[slice.ifield]
  lats = *field.lats
  nlats = N_ELEMENTS(lats)
;
  title = 'User set latitude axis range'
  tlb = widget_base(column=1,title=title,group_leader=info.tlb,/modal)
; tlb = widget_base(column=1,title=title,group_leader=info.tlb)
;
; Begin, end of latitude axis:
;
  latbase = widget_base(tlb,column=1,/frame)
;
;  Get minimum latitude and handle when there are too many latitudes for one menu to fit on screen
;
  label = widget_label(latbase,value='Select minimum (southern most) latitude ') 
  mxlats = 30
  if nlats le mxlats then begin
    lat0_string = strcompress(string(lats[0]),/remove_all)
    latnlat_string = strcompress(string(lats[nlats]),/remove_all)
    latsmenu = widget_button(latbase,value=lat0_string + ' ' + latnlat_string,/menu)
    for i=0,nlats do begin
      lat_string = strcompress(string(lats[i]),/remove_all)
      textmin = widget_button(latsmenu1,value=lat_string,$
                             uvalue='LATMIN',event_pro=event_pro)
    endfor   
  endif else begin ; > mxlats times
    nmenus = nlats / mxlats
    menubases = intarr(nmenus)  
    ilat = 0
    for m=0,nmenus-1 do begin
      lat1_string = strcompress(string(lats[ilat]),/remove_all)
      lat2_string = strcompress(string(lats[ilat+mxlats-1]),/remove_all)
      menubases[m] = widget_button(latbase,value=lat1_string + ' to ' + lat2_string,/menu)
      for i=0,mxlats-1 do begin
        lat_string = strcompress(string(lats[ilat]),/remove_all)
        textmin = widget_button(menubases[m],value=lat_string,$
                                 uvalue='LATMIN',event_pro=event_pro)
      ilat = ilat + 1
      endfor 
    endfor 
    nlats_last = nlats mod mxlats
    if nlats_last gt 0 then begin
      lat1_string = strcompress(string(lats[ilat]),/remove_all)
      lat2_string = strcompress(string(lats[ilat+nlats_last-1]),/remove_all)
      menubase = widget_button(latbase,value=lat1_string + ' ' + lat2_string,/menu)
      for i=0,nlats_last-1 do begin
        lat_string = strcompress(string(lats[ilat]),/remove_all)
        textmin = widget_button(menubase,value=lat_string,$
                               uvalue='LATMIN',event_pro=event_pro)
       ilat = ilat + 1
     endfor
    endif
  endelse
;
;  Get minimum latitude and handle when there are too many latitudes for one menu to fit on screen
;
  label = widget_label(latbase,value='Select maximum (northern most) latitude ') 
  mxlats = 30
  if nlats le mxlats then begin
    lat0_string = strcompress(string(lats[0]),/remove_all)
    latnlat_string = strcompress(string(lats[nlats]),/remove_all)
    latsmenu = widget_button(latbase,value=lat0_string + ' ' + latnlat_string,/menu)
    for i=0,nlats do begin
      lat_string = strcompress(string(lats[i]),/remove_all)
      textmax = widget_button(latsmenu1,value=lat_string,$
                             uvalue='LATMAX',event_pro=event_pro)
    endfor   
  endif else begin ; > mxlats times
    nmenus = nlats / mxlats
    menubases = intarr(nmenus)  
    ilat = 0
    for m=0,nmenus-1 do begin
      lat1_string = strcompress(string(lats[ilat]),/remove_all)
      lat2_string = strcompress(string(lats[ilat+mxlats-1]),/remove_all)
      menubases[m] = widget_button(latbase,value=lat1_string + ' to ' + lat2_string,/menu)
      for i=0,mxlats-1 do begin
        lat_string = strcompress(string(lats[ilat]),/remove_all)
        textmax = widget_button(menubases[m],value=lat_string,$
                                 uvalue='LATMAX',event_pro=event_pro)
      ilat = ilat + 1
      endfor 
    endfor 
    nlats_last = nlats mod mxlats
    if nlats_last gt 0 then begin
      lat1_string = strcompress(string(lats[ilat]),/remove_all)
      lat2_string = strcompress(string(lats[ilat+nlats_last-1]),/remove_all)
      menubase = widget_button(latbase,value=lat1_string + ' ' + lat2_string,/menu)
      for i=0,nlats_last-1 do begin
        lat_string = strcompress(string(lats[ilat]),/remove_all)
        textmax = widget_button(menubase,value=lat_string,$
                               uvalue='LATMAX',event_pro=event_pro)
       ilat = ilat + 1
     endfor
    endif
  endelse
;
; Reset to vertical range of field:
;
  button = widget_button(tlb,value='Reset to full latitude range',$
    uvalue='RESET')
;
; ok and cancel buttons:
;
  base = widget_base(tlb,/frame,row=1)
  button = widget_button(base,value='OK',uvalue='OK')
  button = widget_button(base,value='CANCEL',uvalue='CANCEL')
;
; State info:
;
  lataxis = {lataxis_struct, $
    latmin:slice.latmin,     $ ; latitude minimum on axis 
    latmax:slice.latmax,     $ ; latitude maximum on axis
    textmin:textmin,         $ ; widget id of min
    textmax:textmax,         $ ; widget id of max
    lats:ptr_new(lats)       $ ; full latitude array
  }
;
; Pointer to state info:
;
  plataxis = ptr_new(lataxis)
  widget_control,tlb,set_uvalue=plataxis
  widget_control,tlb,/realize
  xmanager,'setaxis_lat',tlb,/no_block
;
; Update slice state info: 
;
  slice.latmin = (*plataxis).latmin  
  slice.latmax = (*plataxis).latmax
  print,'Set user latitude axis min,max = ',slice.latmin,slice.latmax
  *pslice = slice 
end
