;
;-----------------------------------------------------------------------
function setminlon,lons,lonmin,err
  err = 0
  nlons = n_elements(lons)
  if (lonmin lt lons[0]) or (lonmin gt lons[nlons-1]) then begin
    print,'>>> Bad longitude minimum = ',lonmin,' (must be >= ',lons[0],$
      ' and <= ',lons[nlons-1],')'
    err = 1
    return,lons[0]
  endif else begin
    j = ixfind_nearest(lons,lonmin)
    if j gt -1 then begin
      return,lons[j]
    endif else begin
      print,'>>> WARNING: cannot find j index to lonmin=',lonmin
      err = 1
      return,lons[0]
    endelse
  endelse
end
;
;-----------------------------------------------------------------------
function setmaxlon,lons,lonmax,err
  err = 0
  nlons = n_elements(lons)
  if (lonmax gt lons[nlons-1]) or (lonmax lt lons[0]) then begin
    print,'>>> Bad longitude maximum = ',lonmax,' (must be <= ',lons[nlons-1],$
      ' and >= ',lons[0],')'
    err = 1
    return,lons[nlons-1]
  endif else begin
    j = ixfind_nearest(lons,lonmax)
    if j gt -1 then begin
      return,lons[j]
    endif else begin
      print,'>>> WARNING: cannot find j index to lonmax=',lonmax
      err = 1
      return,lons[nlons-1]
    endelse
  endelse
end
;
;-----------------------------------------------------------------------
pro setaxis_lon_event,event
  widget_control,event.id,get_uvalue=widget
  widget_control,event.top,get_uvalue=plonaxis
  lonaxis = *plonaxis
  lons = *lonaxis.lons     ; full axis longitudes
  nlons = n_elements(lons)
  case widget of
    'LONMIN': begin
      widget_control,event.id,get_value=botstring
      lonmin = mkfloat(botstring[0],lonaxis.lonmin,event.id)
      lonmin = setminlon(lons,lonmin,err)
      if not err then begin
        lonaxis.lonmin = lonmin
        print,'Set longitude minimum = ',lonaxis.lonmin
        *plonaxis = lonaxis
      endif else begin
        widget_control,event.id,setvalue=lonaxis.lonmin
      endelse
    end
    'LONMAX': begin
      widget_control,event.id,get_value=topstring
      lonmax = mkfloat(topstring[0],lonaxis.lonmax,event.id)
      lonmax = setmaxlon(lons,lonmax,err)
      if not err then begin
        lonaxis.lonmax = lonmax
        print,'Set longitude maximum = ',lonaxis.lonmax
        *plonaxis = lonaxis
      endif else begin
        widget_control,event.id,setvalue=lonaxis.lonmax
      endelse
    end
    'OK': begin
      lonmin = lonaxis.lonmin
      lonmax = lonaxis.lonmax
      if lonmin eq lonmax then begin
        print,'Setting lonitude axis min,max to full range: ',lons[0],$
          ' to ',lons[nlons-1]
        lonaxis.lonmin = lons[0]
        lonaxis.lonmax = lons[nlons-1]
        widget_control,lonaxis.textmax,set_value=string(lonaxis.lonmax)
        widget_control,lonaxis.textmin,set_value=string(lonaxis.lonmin)
        *plonaxis = lonaxis
        widget_control,event.top,/destroy
      endif else begin
        lonaxis.lonmin = lonmin
        lonaxis.lonmax = lonmax
        *plonaxis = lonaxis
        widget_control,event.top,/destroy
      endelse
    end
    'RESET': begin
      lonaxis.lonmin = lons[0]
      lonaxis.lonmax = lons[nlons-1]
      *plonaxis = lonaxis
      widget_control,event.top,/destroy
    end
    'CANCEL': begin
      print,'Canceling: y-axis lonmin,max=',lonaxis.lonmin,lonaxis.lonmax
      widget_control,event.top,/destroy
    end
    else: print,'>>> setaxes: unrecognized event: ',widget
  endcase
end
;-----------------------------------------------------------------------
pro setaxis_lon,info,pslice
;
  slice = *pslice
  fields = *info.fields
  field = fields[slice.ifield]
  lons = *field.lons
  nlons = N_ELEMENTS(lons)
;
  title = 'User set longitude axis range'
  tlb = widget_base(column=1,title=title,group_leader=info.tlb,/modal)
;
; Begin, end of longitude axis:
;
;  Get minimum longitude value to plot
;
  lonbase = widget_base(tlb,column=1,/frame)
  label = widget_label(lonbase,value='Select minimum (western most) longitude ') 
;
;  Handle when there are too many longitudes for one menu to fit on screen
;
  mxlons = 30
  if nlons le mxlons then begin
    lon0_string = strcompress(string(lons[0]),/remove_all)
    lonnlon_string = strcompress(string(lons[nlons]),/remove_all)
    lonsmenu = widget_button(lonbase,value=lon0_string + ' ' + lonnlon_string,/menu)
    for i=0,nlons do begin
      lon_string = strcompress(string(lons[i]),/remove_all)
      textmin = widget_button(lonsmenu1,value=lon_string,$
                             uvalue='LONMIN',event_pro=event_pro)
    endfor   
  endif else begin ; > mxlons times
    nmenus = nlons / mxlons
    menubases = intarr(nmenus)  
    ilon = 0
    for m=0,nmenus-1 do begin
      lon1_string = strcompress(string(lons[ilon]),/remove_all)
      lon2_string = strcompress(string(lons[ilon+mxlons-1]),/remove_all)
      menubases[m] = widget_button(lonbase,value=lon1_string + ' to ' + lon2_string,/menu)
      for i=0,mxlons-1 do begin
        lon_string = strcompress(string(lons[ilon]),/remove_all)
        textmin = widget_button(menubases[m],value=lon_string,$
                                 uvalue='LONMIN',event_pro=event_pro)
      ilon = ilon + 1
      endfor 
    endfor 
    nlons_last = nlons mod mxlons
    if nlons_last gt 0 then begin
      lon1_string = strcompress(string(lons[ilon]),/remove_all)
      lon2_string = strcompress(string(lons[ilon+nlons_last-1]),/remove_all)
      menubase = widget_button(lonbase,value=lon1_string + ' ' + lon2_string,/menu)
      for i=0,nlons_last-1 do begin
        lon_string = strcompress(string(lons[ilon]),/remove_all)
        textmin = widget_button(menubase,value=lon_string,$
                               uvalue='LONMIN',event_pro=event_pro)
       ilon = ilon + 1
     endfor
    endif
  endelse
;
;  Get maximum longitude value to plot
;
  label = widget_label(lonbase,value='Select maximum (eastern most) longitude') 
  mxlons = 30
  if nlons le mxlons then begin
    lon0_string = strcompress(string(lons[0]),/remove_all)
    lonnlon_string = strcompress(string(lons[nlons]),/remove_all)
    lonsmenu = widget_button(lonbase,value=lon0_string + ' ' + lonnlon_string,/menu)
    for i=0,nlons do begin
      lon_string = strcompress(string(lons[i]),/remove_all)
      textmin = widget_button(lonsmenu1,value=lon_string,$
                             uvalue='LONMIN',event_pro=event_pro)
    endfor   
  endif else begin ; > mxlons times
    nmenus = nlons / mxlons
    menubases = intarr(nmenus)  
    ilon = 0
    for m=0,nmenus-1 do begin
      lon1_string = strcompress(string(lons[ilon]),/remove_all)
      lon2_string = strcompress(string(lons[ilon+mxlons-1]),/remove_all)
      menubases[m] = widget_button(lonbase,value=lon1_string + ' to ' + lon2_string,/menu)
      for i=0,mxlons-1 do begin
        lon_string = strcompress(string(lons[ilon]),/remove_all)
        textmax = widget_button(menubases[m],value=lon_string,$
                                 uvalue='LONMAX',event_pro=event_pro)
      ilon = ilon + 1
      endfor 
    endfor 
    nlons_last = nlons mod mxlons
    if nlons_last gt 0 then begin
      lon1_string = strcompress(string(lons[ilon]),/remove_all)
      lon2_string = strcompress(string(lons[ilon+nlons_last-1]),/remove_all)
      menubase = widget_button(lonbase,value=lon1_string + ' ' + lon2_string,/menu)
      for i=0,nlons_last-1 do begin
        lon_string = strcompress(string(lons[ilon]),/remove_all)
        textmax = widget_button(menubase,value=lon_string,$
                               uvalue='LONMAX',event_pro=event_pro)
       ilon = ilon + 1
     endfor
    endif
  endelse
;
; Reset to vertical range of field:
  button = widget_button(tlb,value='Reset to full longitude range',$
    uvalue='RESET')
;
; ok and cancel buttons:
;
  base = widget_base(tlb,/frame,row=1)
  button = widget_button(base,value='OK',uvalue='OK')
  button = widget_button(base,value='CANCEL',uvalue='CANCEL')
;
; State info:
;
  lonaxis = {lonaxis_struct, $
    lonmin:slice.lonmin,     $ ; longitude minimum on axis 
    lonmax:slice.lonmax,     $ ; longitude maximum on axis
    textmin:textmin,         $ ; widget id of min
    textmax:textmax,         $ ; widget id of max
    lons:ptr_new(lons)       $ ; full longitude array
  }
;
; Pointer to state info:
;
  plonaxis = ptr_new(lonaxis)
  widget_control,tlb,set_uvalue=plonaxis
  widget_control,tlb,/realize
  xmanager,'setaxis_lon',tlb,/no_block
;
; Update slice state info: 
;
  slice.lonmin = (*plonaxis).lonmin  
  slice.lonmax = (*plonaxis).lonmax
  print,'Set user longitude axis min,max = ',slice.lonmin,slice.lonmax
  *pslice = slice 
end
