;
;-----------------------------------------------------------------------
function setminlon,lons,lonmin,err
  err = 0
  nlons = n_elements(lons)
  if (lonmin lt lons[0]) or (lonmin gt lons[nlons-1]) then begin
    print,'>>> Bad longitude minimum = ',lonmin,' (must be >= ',lons[0],$
      ' and <= ',lons[nlons-1],')'
    err = 1
    return,lons[0]
  endif else begin
    j = ixfind_nearest(lons,lonmin)
    if j gt -1 then begin
      return,lons[j]
    endif else begin
      print,'>>> WARNING: cannot find j index to lonmin=',lonmin
      err = 1
      return,lons[0]
    endelse
  endelse
end
;
;-----------------------------------------------------------------------
function setmaxlon,lons,lonmax,err
  err = 0
  nlons = n_elements(lons)
  if (lonmax gt lons[nlons-1]) or (lonmax lt lons[0]) then begin
    print,'>>> Bad longitude maximum = ',lonmax,' (must be <= ',lons[nlons-1],$
      ' and >= ',lons[0],')'
    err = 1
    return,lons[nlons-1]
  endif else begin
    j = ixfind_nearest(lons,lonmax)
    if j gt -1 then begin
      return,lons[j]
    endif else begin
      print,'>>> WARNING: cannot find j index to lonmax=',lonmax
      err = 1
      return,lons[nlons-1]
    endelse
  endelse
end
;
;-----------------------------------------------------------------------
pro setaxis_slt_event,event
  widget_control,event.id,get_uvalue=widget
  widget_control,event.top,get_uvalue=psltaxis
  sltaxis = *psltaxis
  lons = *sltaxis.lons     ; full axis longitudes
  nlons = n_elements(lons)
  case widget of
    'SLTMIN': begin
      widget_control,event.id,get_value=botstring
      sltmin = mkfloat(botstring[0],sltaxis.sltmin,event.id)
;      sltmin = setminslt(lons,sltmin,err)
      if not err then begin
        print,'Set solar local time minimum = ',sltaxis.sltmin
        sltaxis.sltmin = sltmin
        *psltaxis = sltaxis
      endif else begin
        widget_control,event.id,setvalue=sltaxis.sltmin
      endelse
    end
    'sltMAX': begin
      widget_control,event.id,get_value=topstring
      sltmax = mkfloat(topstring[0],sltaxis.sltmax,event.id)
;      sltmax = setmaxslt(slts,sltmax,err)
      if not err then begin
        sltaxis.sltmax = sltmax
        print,'Set solar local time maximum = ',sltaxis.sltmax
        *psltaxis = sltaxis
      endif else begin
        widget_control,event.id,setvalue=sltaxis.sltmax
      endelse
    end
    'OK': begin
      widget_control,sltaxis.textmin,get_value=botstring
      widget_control,sltaxis.textmax,get_value=topstring
;
      sltmin = mkfloat(botstring[0],sltaxis.sltmin,sltaxis.textmin)
;      sltaxis.sltmin = setminslt(slts,sltmin,err)
;      if err then print,'>>> WARNING setaxis_slt: error from func setmaxslt'
;
      sltmax = mkfloat(topstring[0],sltaxis.sltmax,sltaxis.textmax)
;      sltaxis.sltmax = setmaxslt(slts,sltmax,err)
;      if err then print,'>>> WARNING setaxis_slt: error from func setminslt'
;
      if sltmin gt sltmax then begin
        print,'>>> Minimum must be < maximum: minimum=',sltmin,' maximum=',sltmax
        print,'    Resetting to full axis range: 0. to 24.'
        sltaxis.sltmin = 0.
        sltaxis.sltmax = 24.
        widget_control,sltaxis.textmax,set_value=string(sltaxis.sltmax)
        widget_control,sltaxis.textmin,set_value=string(sltaxis.sltmin)
        *psltaxis = sltaxis
      endif else if sltmin eq sltmax then begin
        print,'Setting solar local time axis min,max to full range: 0. to 24.'
        sltaxis.sltmin = 0.
        sltaxis.sltmax = 24.
        widget_control,sltaxis.textmax,set_value=string(sltaxis.sltmax)
        widget_control,sltaxis.textmin,set_value=string(sltaxis.sltmin)
        *psltaxis = sltaxis
        widget_control,event.top,/destroy
      endif else begin
        sltaxis.sltmin = sltmin
        sltaxis.sltmax = sltmax
        *psltaxis = sltaxis
        widget_control,event.top,/destroy
      endelse
    end
    'RESET': begin
      sltaxis.sltmin = 0.
      sltaxis.sltmax = 24.
      *psltaxis = sltaxis
      widget_control,event.top,/destroy
    end
    'CANCEL': begin
      print,'Canceling: y-axis sltmin,max=',sltaxis.sltmin,sltaxis.sltmax
      widget_control,event.top,/destroy
    end
    else: print,'>>> setaxes: unrecognized event: ',widget
  endcase
end
;-----------------------------------------------------------------------
pro setaxis_slt,info,pslice
;
  slice = *pslice
  fields = *info.fields
  field = fields[slice.ifield]
  lons = *field.lons
;
  title = 'User set solar local time axis range'
  tlb = widget_base(column=1,title=title,group_leader=info.tlb,/modal)
; tlb = widget_base(column=1,title=title,group_leader=info.tlb)
;
; Begin, end of solar local time axis:
;
  sltbase = widget_base(tlb,column=1,/frame)
  label = widget_label(sltbase,value='Enter minimum solar local time ') 
  textmin = widget_text(sltbase,/editable,value=string(slice.sltmin),$
    uvalue='SLTMIN')
  label = widget_label(sltbase,value='Enter maximum solar local time ') 
  textmax = widget_text(sltbase,/editable,value=string(slice.sltmax),$
    uvalue='SLTMAX')
;
; Reset to vertical range of field:
  button = widget_button(tlb,value='Reset to full solar local time range',$
    uvalue='RESET')
;
; ok and cancel buttons:
;
  base = widget_base(tlb,/frame,row=1)
  button = widget_button(base,value='OK',uvalue='OK')
  button = widget_button(base,value='CANCEL',uvalue='CANCEL')
;
; State info:
;
  sltaxis = {sltaxis_struct, $
    sltmin:slice.sltmin,     $ ; longitude minimum on axis 
    sltmax:slice.sltmax,     $ ; longitude maximum on axis
    textmin:textmin,         $ ; widget id of min
    textmax:textmax,         $ ; widget id of max
    lons:ptr_new(lons)       $ ; full longitude array
  }
;
; Pointer to state info:
;
  psltaxis = ptr_new(sltaxis)
  widget_control,tlb,set_uvalue=psltaxis
  widget_control,tlb,/realize
  xmanager,'setaxis_slt',tlb,/no_block
;
;  Get longitudes corresponding to solar local time min/max since plotting with 
;  solar local time axis actually uses longitude min/max to plot
;
  uthrs = float(slice.mtime[1])+float(slice.mtime[2])/60. ;mtime[1] hours and mtime[2] minutes
  censlt = ((*psltaxis).sltmin + (*psltaxis).sltmax) / 2 ; local time (hrs) of center of lon axis of projection
;
  plon=0
;  if censlt ge 0. then begin
    mag = 0 & if field.grid_type eq 'magnetic' then mag = 1
    lonmin = fslt((*psltaxis).sltmin,uthrs,plon,'getlon',mag=mag)
    lonmax = fslt((*psltaxis).sltmax,uthrs,plon,'getlon',mag=mag)
;  endif
;
; Update slice state info: 
;
  slice.sltmin = (*psltaxis).sltmin  
  slice.sltmax = (*psltaxis).sltmax
  slice.lonmin = lonmin  
  slice.lonmax = lonmax
;
; Handle where cancel chosen and lonmin and lonmax are zero
;
  if lonmin eq 0. and lonmax eq 0. then begin
    slice.lonmin = -180.
    slice.lonmax = 180.
  endif
  slice.censlt = censlt
  print,'Set user solar local time axis min,max = ',slice.sltmin,slice.sltmax
  *pslice = slice 
end
