;
;-----------------------------------------------------------------------
function setmintimew,times,timemin,err
  err = 0
  ntimes = n_elements(times)
  if (timemin lt times[0]) or (timemin gt times[ntimes-1]) then begin
    print,'>>> Bad time minimum = ',timemin,' (must be >= ',times[0],$
      ' and <= ',times[ntimes-1],')'
    err = 1
    return,times[0]
  endif else begin
    j = ixfind_nearest(times,timemin)
    if j gt -1 then begin
      return,times[j]
    endif else begin
      print,'>>> WARNING: cannot find j index to timemin=',timemin
      err = 1
      return,times[0]
    endelse
  endelse
end
;
;-----------------------------------------------------------------------
function setmaxtimew,times,timemax,err
  err = 0
  ntimes = n_elements(times)
  if (timemax gt times[ntimes-1]) or (timemax lt times[0]) then begin
    print,'>>> Bad time maximum = ',timemax,' (must be <= ',times[ntimes-1],$
      ' and >= ',times[0],')'
    err = 1
    return,times[ntimes-1]
  endif else begin
    j = ixfind_nearest(times,timemax)
    if j gt -1 then begin
      return,times[j]
    endif else begin
      print,'>>> WARNING: cannot find j index to timemax=',timemax
      err = 1
      return,times[ntimes-1]
    endelse
  endelse
end
;
;-----------------------------------------------------------------------
pro setaxis_timew_event,event
  widget_control,event.id,get_uvalue=widget
  widget_control,event.top,get_uvalue=ptimeaxis
  timeaxis = *ptimeaxis
  times = *timeaxis.times     ; full axis times
  ntimes = n_elements(times)
  mtimes = *timeaxis.mtimes
  mdays = mtimes[0,*]
  mhrs = mtimes[1,*]
  mmins = mtimes[2,*]
  
  case widget of
    'DAYMIN': begin
      widget_control,event.id,get_value=dbotstring
        timeaxis.daymin = dbotstring[0]
        *ptimeaxis = timeaxis
    end
    'DAYMAX': begin
      widget_control,event.id,get_value=dtopstring
        timeaxis.daymax = dtopstring[0]
        *ptimeaxis = timeaxis
    end
    'OK': begin
      widget_control,timeaxis.textdmin,get_value=dbotstring
      widget_control,timeaxis.textdmax,get_value=dtopstring


      timeaxis.daymin = dbotstring[0]
      timeaxis.daymax = dtopstring[0]

      timemin = timeaxis.daymin
      timemax = timeaxis.daymax     
      
      timemin = setmintimew(times,timemin,err)
      if err then print,'>>> WARNING setaxis_time: error from func setmintime'

      timemax = setmaxtimew(times,timemax,err)
      if err then print,'>>> WARNING setaxis_time: error from func setmaxtime'

      if timemin gt timemax then begin
        print,'>>> Minimum must be < maximum: minimum=',timemin,' maximum=',timemax
        print,'    Resetting to full axis range: ',times[0],' to ',$
          times[ntimes-1]
        timeaxis.timemin = times[0]
        timeaxis.timemax = times[ntimes-1]
        widget_control,timeaxis.textdmax,set_value=string(timeaxis.timemax)
        widget_control,timeaxis.textdmin,set_value=string(timeaxis.timemin)
        *ptimeaxis = timeaxis
      endif else if timemin eq timemax then begin
        print,'Setting time axis min,max to full range: ',times[0],$
          ' to ',times[ntimes-1]
        timeaxis.timemin = times[0]
        timeaxis.timemax = times[ntimes-1]
        widget_control,timeaxis.textdmax,set_value=string(timeaxis.timemax)
        widget_control,timeaxis.textdmin,set_value=string(timeaxis.timemin)
        *ptimeaxis = timeaxis
        widget_control,event.top,/destroy
      endif else begin
        timeaxis.timemin = timemin
        timeaxis.timemax = timemax
        *ptimeaxis = timeaxis
        widget_control,event.top,/destroy
      endelse
    end
    'RESET': begin
      timeaxis.timemin = times[0]
      timeaxis.timemax = times[ntimes-1]
      *ptimeaxis = timeaxis
      widget_control,event.top,/destroy
    end
    'CANCEL': begin
      print,'Canceling: y-axis timemin,max=',timeaxis.timemin,timeaxis.timemax
      widget_control,event.top,/destroy
    end
    else: print,'>>> setaxes: unrecognized event: ',widget
  endcase
end
;-----------------------------------------------------------------------
pro setaxis_timew,info,pslice
;
  slice = *pslice
  fields1D = *info.fields1D
  field1D = fields1D[slice.ifield]
  times = *field1D.times
  file = *info.pfile
  mtimes = file.mtimes
  sizemtimes = SIZE(mtimes)
  nmtimes = sizemtimes[2]
;
  title = 'User set time axis range'
  tlb = widget_base(column=1,title=title,group_leader=info.tlb,/modal)
;
; Begin, end of longitude axis:
;
  timebase = widget_base(tlb,column=1,/frame)

  label = widget_label(timebase,value='Enter minimum fractional day ') 
  textdmin = widget_text(timebase,/editable,value=string(slice.timemin),$
    uvalue='DAYMIN')
  label = widget_label(timebase,value='Enter maximum fractional day') 
  textdmax = widget_text(timebase,/editable,value=string(slice.timemax),$
    uvalue='DAYMAX')
;
; Reset to vertical range of field:
  button = widget_button(tlb,value='Reset to full time range',$
    uvalue='RESET')
;
; ok and cancel buttons:
;
  base = widget_base(tlb,/frame,row=1)
  button = widget_button(base,value='OK',uvalue='OK')
  button = widget_button(base,value='CANCEL',uvalue='CANCEL')
;
; State info:
;
  timeaxis = {timeaxis_struct, $
    daymin:0.,                  $ ; day minimum
    daymax:0.,                  $ ; day maximum
    timemin:slice.timemin,     $ ; time minimum on axis 
    timemax:slice.timemax,     $ ; time maximum on axis
    textdmin:textdmin,         $ ; widget id of day min
    textdmax:textdmax,         $ ; widget id of day max
    times:ptr_new(times),      $ ; full time array
    mtimes:ptr_new(mtimes)     $ ; full model time array
  }
;
; Pointer to state info:
;
  ptimeaxis = ptr_new(timeaxis)
  widget_control,tlb,set_uvalue=ptimeaxis
  widget_control,tlb,/realize
  xmanager,'setaxis_timeW',tlb,/no_block
;
; Update slice state info: 
;
  slice.timemin = (*ptimeaxis).timemin  
  slice.timemax = (*ptimeaxis).timemax

  print,'Set user time axis min,max = ',slice.timemin,slice.timemax
  *pslice = slice 
end
