;--------------------------------------------------------------------
function make_ut_widget,xaxis
  
  slice= *xaxis.pslice
  info= *xaxis.pinfo
  fields = *info.fields
  file = *info.pfile
  field = fields[slice.ifield]
  times=get_time_min(file.mtimes,xaxis.utbeg,xaxis.utend,no_limit=1)
  ntimes = n_elements(times)
  tlb=xaxis.tlb
  minTime=xaxis.utbeg
  maxTime=xaxis.utend
  interval=xaxis.utint

; print,'make_ut_widget: xaxis.utbeg=',xaxis.utbeg,' xaxis.utend=',$
;   xaxis.utend,' xaxis.utint=',xaxis.utint
 
  ;while loop destroys the bases to make room for new ones
  child =1
  while(child ne 0) do begin
    child=widget_info(xaxis.tlb, /child)
    if(child ne 0) then begin
      widget_control,child,/destroy
    endif
  endwhile

;
; Begin, end of UT axis:
;
  utbase = widget_base(tlb,column=1,/frame)

; print,'make_ut_widget call xaxis_menu: minTime=',minTime,' maxTime=',$
;   maxTime,' interval=',interval

  xaxis_menu= mtime_utmenu(utbase,file.mtimes,minTime,maxTime, $
    interval,'setaxis_ut_event')
;
; ok and cancel buttons:
;
  base = widget_base(tlb,/frame,row=1)
  button = widget_button(base,value='RESET',uvalue='RESET')
  button = widget_button(base,value='OK',uvalue='OK')
  button = widget_button(base,value='CANCEL',uvalue='CANCEL')
  return,xaxis_menu
end
;--------------------------------------------------------------------
;
pro setaxis_ut_event,event
  widget_control,event.id,get_uvalue=widget
  widget_control,event.top,get_uvalue=pxaxis
  widget_control,event.top,get_uvalue=pinfo

  xaxis = *pxaxis
  slice= *xaxis.pslice
  info= *xaxis.pinfo
  fields = *info.fields
  file = *info.pfile
  field = fields[slice.ifield]
  times=get_time_min(file.mtimes,xaxis.utbeg,xaxis.utend,no_limit=1)
  ntimes = n_elements(times)
  tlb=xaxis.tlb

  case widget of
    'UTBEG': begin
      widget_control,event.id,get_value=botstring
      ;
      imtime = -1
      for i=0,file.ntimes-1 do begin
        mtime_string = $
          strcompress(string(file.mtimes[0,i]),/remove_all)+','+ $
          strcompress(string(file.mtimes[1,i]),/remove_all)+','+ $
          strcompress(string(file.mtimes[2,i]),/remove_all)
        if mtime_string eq botstring then begin
          imtime = i
          goto, foundbot
        endif
      endfor
      print,'>>> WARNING UTEND: could not find botstring ',botstring
      return
      foundbot:
;
      utbeg=times[imtime]
      if (utbeg lt times[0]) or (utbeg gt times[ntimes-2]) then begin
        print,'>>> Bad beginning value = ',utbeg,' (must be >= ',times[0],$
          ' and <= ',times[ntimes-1],')'
      endif else begin
        xaxis.utbeg=get_time_mod(utbeg)
        print,'Set beginning value = ',xaxis.utbeg
        *pxaxis = xaxis
      endelse
      minTime=xaxis.utbeg
      maxTime=xaxis.utend
      *pxaxis = xaxis
      xaxis_menu=make_ut_widget(xaxis)
    end
    'UTEND': begin
      widget_control,event.id,get_value=topstring
      ;
      imtime = -1
      for i=0,file.ntimes-1 do begin
        mtime_string = $
          strcompress(string(file.mtimes[0,i]),/remove_all)+','+ $
          strcompress(string(file.mtimes[1,i]),/remove_all)+','+ $
          strcompress(string(file.mtimes[2,i]),/remove_all)
        if mtime_string eq topstring then begin
          imtime = i
          goto, foundtop
        endif
      endfor
      print,'>>> WARNING UTEND: could not find topstring ',topstring
      return
      foundtop:
      ;
     
      utend=times[imtime]
      if (utend lt times[1]) or (utend gt times[ntimes-1]) then begin
        print,'>>> Bad ending time = ',utend,' (must be >= ',times[0],$
          ' and <= ',times[ntimes-1],')'
      endif else begin
        xaxis.utend = get_time_mod(utend)
        print,'Set ending value = ',xaxis.utend
        *pxaxis = xaxis
      endelse
      minTime=xaxis.utbeg
      maxTime=xaxis.utend
      *pxaxis = xaxis
      xaxis_menu=make_ut_widget(xaxis)
    end
    'UTINT': begin
      widget_control,event.id,get_value=utintstring
      ;
      mtime=file.mtimes
      if mtime[0,0] ne mtime[0,1] and mtime[1,1] eq mtime[1,0] $
        and mtime[2,0] eq mtime[2,1] then type='day'
      if mtime[1,1] ne mtime[1,0] $
        and mtime[2,0] eq mtime[2,1] then type='hr'
      if mtime[2,0] ne mtime[2,1] then type='min'

      if type eq 'hr' then begin
        interval=mtime[1,1]-mtime[1,0] 
      endif else if type eq 'min' then begin
        interval=mtime[2,1]-mtime[2,0] 

;       print,'UTINT set interval=',interval,' mtime[2,1]=',mtime[2,1],$
;         ' mtime[2,0]=',mtime[2,0]

      endif else begin
        interval=mtime[0,1]-mtime[0,0] 
      endelse  

      imtime = -1
      for i=0,ntimes/2-1 do begin
;       mtime_string=strcompress(string(interval*i+1))+' '+type

        mtime_string=strcompress(string(interval*i))+' '+type
        if (i eq 0) then mtime_string=strcompress(string(interval*i+1))+' '+type

;       print,'Search for utintstring = $',utintstring,'$ i=',i,$
;         ' mtime_string = $',mtime_string,'$'

        if mtime_string eq utintstring then begin
          imtime = i
          goto, foundint
        endif
      endfor
      print,'>>> WARNING UTEND: could not find utintstring ',utintstring
;     print,'>>> WARNING : could not find index to model time ',$
;       mtime_request
      return
      foundint:
      ;
     
;     xaxis.utint = interval*imtime+1

;     print,'Setting xaxis.utint: interval=',interval,' imtime=',imtime

      xaxis.utint = interval*imtime

      xaxis.type = type
      *pxaxis = xaxis
      xaxis_menu=make_ut_widget(xaxis)
    end
    'RESET': begin
      utbeg=times[0]
      utend=times[ntimes-1]
      xaxis.utbeg=get_time_mod(utbeg)
      xaxis.utend = get_time_mod(utend)
      xaxis.utint = 1
      *pxaxis = xaxis
      minTime=xaxis.utbeg
      maxTime=xaxis.utend
      xaxis_menu=make_ut_widget(xaxis)
    end
    'OK': begin
      utbeg=xaxis.utbeg
      utend=xaxis.utend
;     wrong_time=0
;     if (utbeg[0] ge utend[0]) or (utbeg[1] ge utend[1]) or $
;       (utbeg[2] ge utend[2]) then begin
;       print,'>>> Beginning ut must be < Ending ut: begin=',utbeg,' end=',utend
;       print,'    Resetting to full axis range: ',times[0],' to ',$
;         times[ntimes-1]
;       *pxaxis = xaxis
;     endif else begin
        xaxis.utbeg = utbeg
        xaxis.utend = utend
        *pxaxis = xaxis
;     endelse
      widget_control,event.top,/destroy
    end
    'CANCEL': begin
      print,'Canceling: x-axis utmin,max=',xaxis.utbeg,xaxis.utend
;     print,'Setting xaxis.utint to -1'
      xaxis.utint = -1
      *pxaxis = xaxis
      widget_control,event.top,/destroy
    end
    else: print,'>>> setaxes: unrecognized event: ',widget
  endcase
end
;-----------------------------------------------------------------------
function setaxis_ut,info,pslice,utmin,utmax,interval
;
  slice = *pslice
  fields = *info.fields
  field = fields[slice.ifield]
  file = *info.pfile
  mtime=file.mtimes
  times=get_time_min(mtime,utmin,utmax)
  minTime=utmin
  maxTime=utmax
;
   title = 'Set UT ranges'
   tlb = widget_base(column=1,title=title,group_leader=info.tlb,/modal)
   utint=mtime
      if mtime[0,0] ne mtime[0,1] and mtime[1,1] eq mtime[1,0] $
        and mtime[2,0] eq mtime[2,1] then type='day'
      if mtime[1,1] ne mtime[1,0] $
        and mtime[2,0] eq mtime[2,1] then type='hr'
      if mtime[2,0] ne mtime[2,1] then type='min'

;
; State info:
;
  xaxis = {xaxis_struct, $
    utbeg:utmin,   $ ; ending axis value
    utend:utmax,   $ ; beginning axis value
    utint:interval,   $ ; increment through history
    tlb:tlb,       $ ; top level base
    type:type,          $ indicates the type of increment (day,hr,min)
    pslice:ptr_new(slice),$;slice
    times:ptr_new(times),   $ ; full times array
    pfile:ptr_new(file),    $ ; pointer to file info
    pinfo:ptr_new(info)     $ ; pointer to info structure
  }
  xaxis_menu=make_ut_widget(xaxis)
;
; Pointer to state info:
;
  pxaxis = ptr_new(xaxis)
  widget_control,tlb,set_uvalue=pxaxis
  widget_control,tlb,/realize
  xmanager,'setaxis_ut',tlb,/no_block
;
; Update slice state info: 
;
  if type eq 'hr' then begin
    typenum=1 
  endif else if type eq 'min' then begin
    typenum=2
  endif else begin
    typenum=0
  endelse  
  newtimes=intarr(3,3)
  newtimes[0,0]= (*pxaxis).utbeg[0] & newtimes[1,0]=(*pxaxis).utbeg[1] & $
    newtimes[2,0]=(*pxaxis).utbeg[2]
  newtimes[0,1]=(*pxaxis).utend[0] & newtimes[1,1]=(*pxaxis).utend[1] & $
    newtimes[2,1]=(*pxaxis).utend[2]
  newtimes[0,2]=(*pxaxis).utint
  newtimes[1,2]=typenum
  *pslice = slice 
  return,newtimes
end
