;
;-----------------------------------------------------------------------
pro times,info,linetype
;
;  Do generic set up for line plots
;
  lines,info,linetype

  line = *info.pline

  tlb = line.linebase

  fields = *info.fields  ; fields info structure
  fields1D = *info.fields1D
;
; Read data from first field:
;
  if ptr_valid(fields1D[0].data) then begin ; field has been read
;
; Update line structure:
;
    linedata = *fields1D[0].data
    line.data = ptr_new(linedata)
;
; Set min,max for first field:
;
    fminmax,*line.data,fmin,fmax,line.missing_value
    rpt_minmax,info,fields1D[0],fmin,fmax
    line.fmin = fmin
    line.fmax = fmax

  endif else begin

    widget_control,/hourglass
    varget,info,fields1D[0],ncdata
    fields1D[0].data = ptr_new(ncdata)
    field1D = fields1D[0]
    *info.fields1D = fields1D
    linedata = *fields1D[0].data
    line.data = ptr_new(linedata)

    line.field1D = field1D
;
; Set min,max for first field:
;
    fminmax,*line.data,fmin,fmax,line.missing_value
    rpt_minmax,info,fields1D[0],fmin,fmax

  endelse
;
; Set min,max for first field:
;
  fminmax,*line.data,fmin,fmax,line.missing_value
  rpt_minmax,info,fields1D[0],fmin,fmax
  line.fmin = fmin
  line.fmax = fmax
;  widget_control,line.minmaxmenu,sensitive=0 ; because default plottype is image+contour
;
; Update state info, realize the widgets, plot the first slice:
;
  *info.fields1D = fields1D
  *info.fields = fields
  info.pline = ptr_new(line)
  widget_control,tlb,/realize
  pinfo = ptr_new(info)

  pltline,info

  widget_control,tlb,set_uvalue=pinfo
  xmanager,'lines',tlb,/no_block

end
