
pro varget,info,field,data
;
; Read variable from the netcdf file.
;
; Handle special case of ntime==1 (only one time on the file)
;   by sizing the time dimension 2 instead of 1. If it is dimensioned
;   only 1, then IDL chops it off, producing a var with ndims-1 
;   dimensions!
;
var = ncdf_varinq(info.cdfid,field.idvar)
ndims = var.ndims

;print,' '
;print,'VARGET: ndims=',ndims,' field.dimnames=',field.dimnames,$
;  ' field.ntime=',field.ntime
;print,'  dimnames[ndimes-1]=',field.dimnames[ndims-1]
;print,'help,field=' & help,field,/struct
;print,' '

ncdf_varget,info.cdfid,field.idvar,rddata

if info.nfiles gt 1 and field.dimnames[ndims-1] eq 'time' then begin

  dims = size(rddata,/dimensions)
  ndims = n_elements(dims)
  alltimes    = info.ntimes                          ; total times (all files)
  if ndims eq 4 then rddataAllIn = FLTARR(dims[0],dims[1],dims[2],alltimes)  ; data from all input files
  if ndims eq 3 then rddataAllIn = FLTARR(dims[0],dims[1],alltimes)  ; data from all input files
  if ndims eq 2 then rddataAllIn = FLTARR(dims[0],alltimes)  ; data from all input files
  if ndims eq 1 then rddataAllIn = FLTARR(alltimes)  ; data from all input files
  ntimes = 0
  nfiletimes = *info.ntime_files
  rddataIn = rddata
  files = *info.files
  
  for ifile=0,info.nfiles-1 do begin
  
    if ifile gt 0 then ncdfid = ncdf_open(files[ifile],/nowrite)
    if ifile gt 0 then ncdf_varget,ncdfid,field.idvar,rddataIn
    ntime = nfiletimes[ifile]
    if ndims eq 4 then rddataAllIn[*,*,*,ntimes:ntimes+ntime-1] = rddataIn[*,*,*,*]
    if ndims eq 3 then rddataAllIn[*,*,ntimes:ntimes+ntime-1] = rddataIn[*,*,*]
    if ndims eq 2 then rddataAllIn[*,ntimes:ntimes+ntime-1] = rddataIn[*,*]
    if ndims eq 1 then rddataAllIn[ntimes:ntimes+ntime-1] = rddataIn[*]
    if ifile gt 0 then ncdf_close,ncdfid

    ntimes = ntimes + ntime
  
  endfor  

  if ndims eq 4 then rddata = rddataAllIn[*,*,*,0:ntimes-1]
  if ndims eq 3 then rddata = rddataAllIn[*,*,0:ntimes-1]
  if ndims eq 2 then rddata = rddataAllIn[*,0:ntimes-1]
  if ndims eq 1 then rddata = rddataAllIn[0:ntimes-1]

endif  

rddataAllIn = 0
dummy = TEMPORARY(rddataAllIn)

prefill = 9.96921e+36
ifilled = where(rddata eq prefill,nfilled)
;print,'varget: nfilled=',nfilled,' ifilled=',ifilled
if (nfilled gt 0) then begin
  rddata[ifilled] = field.missing_value
  print,'varget: replaced ',nfilled,' pre-fill values (',prefill,') of field ',$
    field.name,' with missing_value ',field.missing_value 
endif
;
; Handle 1D variable with time dimension
;
IF ndims EQ 1 AND field.dimnames[0] EQ 'time' THEN BEGIN

print, '1D variable with time dimension ', field.name

  if field.ntime ne 1 then begin

    data = rddata
 
  endif else begin ; ntime=1
 
    data = fltarr(2) 
    data[0] = rddata
    
  endelse

ENDIF ELSE BEGIN

if field.dimnames[ndims-1] ne 'time' then return
;
dims = size(rddata,/dimensions)
ndimsdata = n_elements(dims)

if field.ntime ne 1 then begin
  data = rddata
;
;  WACCM data fields need to have vertical dimension reversed and longitudes 
;  converted from 0,360 to -180,180
;
  IF info.ftype EQ 'WACCM' AND ndimsdata EQ 4 THEN BEGIN

    vertreverse, info, rddata, data

    if field.grid_type eq 'geographic' THEN convertlons, info, data

  ENDIF

endif else begin ; ntime=1
; print,'  varget: ndimsdata=',ndimsdata,' dims=',dims & help,dims
  case ndimsdata of
    3: begin
;     print,'varget: adding time dimension to 3d var ',field.name
; Note data[*,*,*,1] will never be referenced
;
      IF info.ftype EQ 'WACCM' THEN BEGIN
  
        tempdata = fltarr(dims[0],dims[1],dims[2],2) 
      
        tempdata[*,*,*,0] = rddata[*,*,*]
	rddata = tempdata

        vertreverse, info, rddata, data

        if field.grid_type eq 'geographic' THEN convertlons, info, data

      ENDIF ELSE BEGIN

        data = fltarr(dims[0],dims[1],dims[2],2) 

        data[*,*,*,0] = rddata[*,*,*]
	
      ENDELSE	
;
; Reform works, but still causes problems later when, 
; e.g. data = *fields[i].data then data has ndims-1 dimensions...
;
;     data = reform(rddata,dims[0],dims[1],dims[2],1)
;     print,'varget: help,data = ' & help,data
    end
    2: begin
;     print,'varget: adding time dimension to 2d var ',field.name
      data = fltarr(dims[0],dims[1],2)
      data[*,*,0] = rddata[*,*]
    end
    1: begin
;     print,'varget: adding time dimension to 1d var ',field.name
      data = fltarr(dims[0],2)
      data[*,0] = rddata[*]
    end
  endcase
endelse

ENDELSE ;Not 1D time data

end ; pro varget
