pro vertreverse, info, indata, outdata
;
;  Reverse the order of the order of the data in the vertical dimension
;
;
levID = NCDF_DIMID(info.cdfid,'lev')
NCDF_DIMINQ,info.cdfid,levID,levName,nLevs

varDims = SIZE(indata,/DIMENSIONS)
levDim = WHERE(varDims eq nLevs)
IF levDim LT 0 THEN nLevs = nLevs + 1
levDim = WHERE(varDims eq nLevs)

IF levDim LT 0 THEN BEGIN

  PRINT, 'Could not find lev dimension for this variable '
  RETURN

ENDIF

IF (levDim eq 2) THEN BEGIN

  outdata = indata

  FOR iLev=0,nLevs-1 DO BEGIN

    iLevNew = nLevs - iLev - 1

    outdata[*,*,iLevNew,*] = indata[*,*,iLev,*]

  ENDFOR

ENDIF ELSE BEGIN

  MESSAGE,' Third dimension of variable is not lev.  Quitting. '

ENDELSE
  
END ; pro vertreverse
