function windminmax,londata,latdata,missing_val
  numint=10.0 
  value=sqrt(londata^2+latdata^2) 
  dims=size(value)
  nlon=dims[1]
  nlat=dims[2]
  k=0
  for i=0,nlon-1 do begin
    for j=0,nlat-1 do begin
      if finite(value[i,j]) then begin
	k=k+1
      endif
    endfor
  endfor

  datavalue=fltarr(k)
  z=0
  for i=0,nlon-1 do begin
    for j=0,nlat-1 do begin
      if finite(value[i,j]) then begin
      datavalue[z]=value[i,j]
        z=z+1
      endif
    endfor
  endfor

  windmin=min(datavalue,max=windmax)
  windint=(windmax-windmin)/numint
  winddata=fltarr(3)
  winddata[0]=windmin
  winddata[1]=windmax
  winddata[2]=windint
  return,winddata
end
